/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api.monitor;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.profiler.api.monitor.JavaProcessMonitor;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.lang.module.FindException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/api/monitor/JCmdProcessMonitor;", "Lcom/intellij/profiler/api/monitor/JavaProcessMonitor;", "pid", "", "<init>", "(I)V", "getPid", "()I", "vm", "Lcom/sun/tools/attach/VirtualMachine;", "getVm", "()Lcom/sun/tools/attach/VirtualMachine;", "setVm", "(Lcom/sun/tools/attach/VirtualMachine;)V", "close", "", "dumpHeap", "filePath", "", "dumpThreads", "jcmp", "command", "Companion", "intellij.profiler.common"})
public final class JCmdProcessMonitor
extends JavaProcessMonitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int pid;
    @Nullable
    private VirtualMachine vm;

    private JCmdProcessMonitor(int pid) {
        this.pid = pid;
        if (this.pid == OSProcessUtil.getCurrentProcessId()) {
            this.vm = null;
        } else {
            VirtualMachine it = VirtualMachine.attach(String.valueOf(this.pid));
            boolean bl = false;
            this.vm = it;
        }
    }

    public final int getPid() {
        return this.pid;
    }

    @Nullable
    public final VirtualMachine getVm() {
        return this.vm;
    }

    public final void setVm(@Nullable VirtualMachine virtualMachine) {
        this.vm = virtualMachine;
    }

    @Override
    public void close() {
        try {
            VirtualMachine virtualMachine = this.vm;
            if (virtualMachine != null) {
                virtualMachine.detach();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dumpHeap(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.jcmp("GC.heap_dump", filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String dumpThreads() {
        Path dump = Files.createTempFile("thread-dump", ".txt", new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)dump);
        String filePath = ((Object)dump.toAbsolutePath()).toString();
        try {
            this.jcmp("Thread.dump_to_file", filePath);
            File file = dump.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            String string = FilesKt.readText$default((File)file, null, (int)1, null);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            dump.toFile().delete();
        }
    }

    private final void jcmp(String command, String filePath) {
        block0: {
            Class[] classArray;
            Object object = this.vm;
            if (object == null || (object = object.getClass()) == null || (object = ((Class)object).getMethod("executeJCmd", classArray = new Class[]{String.class})) == null) break block0;
            Object it = object;
            boolean bl = false;
            Object[] objectArray = new Object[]{command + " " + filePath + " -overwrite"};
            ((Method)it).invoke((Object)this.vm, objectArray);
        }
    }

    @JvmStatic
    @Nullable
    public static final String dumpThreads(int pid) throws IOException, FindException {
        return Companion.dumpThreads(pid);
    }

    @JvmStatic
    public static final void dumpHeap(int pid, @NotNull String filePath) throws IOException, FindException {
        Companion.dumpHeap(pid, filePath);
    }

    @JvmStatic
    public static final <T> T connect(int pid, @NotNull Function1<? super JCmdProcessMonitor, ? extends T> block) {
        return Companion.connect(pid, block);
    }

    public /* synthetic */ JCmdProcessMonitor(int pid, DefaultConstructorMarker $constructor_marker) {
        this(pid);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0007J4\u0010\u0004\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u000f0\u0011\u00a2\u0006\u0002\b\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/api/monitor/JCmdProcessMonitor$Companion;", "", "<init>", "()V", "connect", "Lcom/intellij/profiler/api/monitor/JCmdProcessMonitor;", "pid", "", "connectOrNull", "connectOrNull$intellij_profiler_common", "dumpThreads", "", "dumpHeap", "", "filePath", "T", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JCmdProcessMonitor connect(int pid) {
            JCmdProcessMonitor jCmdProcessMonitor;
            try {
                jCmdProcessMonitor = new JCmdProcessMonitor(pid, null);
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable == null) {
                    throwable = e;
                }
                throw throwable;
            }
            return jCmdProcessMonitor;
        }

        @Nullable
        public final JCmdProcessMonitor connectOrNull$intellij_profiler_common(int pid) {
            try {
                return this.connect(pid);
            }
            catch (ExecutionException executionException) {
                return null;
            }
        }

        @JvmStatic
        @Nullable
        public final String dumpThreads(int pid) throws IOException, FindException {
            return (String)this.connect(pid, Companion::dumpThreads$lambda$0);
        }

        @JvmStatic
        public final void dumpHeap(int pid, @NotNull String filePath) throws IOException, FindException {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.connect(pid, arg_0 -> Companion.dumpHeap$lambda$0(filePath, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T connect(int pid, @NotNull Function1<? super JCmdProcessMonitor, ? extends T> block) {
            Object object;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            AutoCloseable autoCloseable = this.connect(pid);
            Throwable throwable = null;
            try {
                object = block.invoke((Object)autoCloseable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return (T)object;
        }

        private static final String dumpThreads$lambda$0(JCmdProcessMonitor $this$connect) {
            Intrinsics.checkNotNullParameter((Object)$this$connect, (String)"$this$connect");
            return $this$connect.dumpThreads();
        }

        private static final Unit dumpHeap$lambda$0(String $filePath, JCmdProcessMonitor $this$connect) {
            Intrinsics.checkNotNullParameter((Object)$this$connect, (String)"$this$connect");
            $this$connect.dumpHeap($filePath);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

