/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.BaseSshConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseSshTunnelEstablisher;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.openapi.util.Ref;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SshConnectionInterceptor
extends BaseSshConnectionInterceptor {
    public boolean interceptConnectionFast(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent) {
        if (proto == null) {
            SshConnectionInterceptor.$$$reportNull$$$0(0);
        }
        if (SshConnectionInterceptor.sshTunnelProcessed(proto)) {
            return false;
        }
        List<DatabaseSshTunnelEstablisher.SshTunnel> tunnels = SshConnectionInterceptor.getTunnels(proto);
        if (!SshConnectionInterceptor.checkSshConfiguration(proto, tunnels)) {
            return false;
        }
        DatabaseDriver driver = proto.getConnectionPoint().getDatabaseDriver();
        Ref parser = Ref.create();
        List hostsPorts = JdbcUrlParserUtil.extractHostsPorts((Collection)(driver == null ? Collections.emptyList() : driver.getJDBCUrlParsers()), (String)proto.getUrl(), (Ref)parser);
        if (hostsPorts.isEmpty()) {
            return false;
        }
        ArrayList<JdbcSettings.PortForwarding> portForwardings = new ArrayList<JdbcSettings.PortForwarding>();
        int index = 0;
        for (DatabaseSshTunnelEstablisher.SshTunnel tunnel : tunnels) {
            HostPort localHostPort = new HostPort("localhost", Integer.valueOf(tunnel.localPort));
            ((JdbcUrlParser)parser.get()).setParameter("host", index, localHostPort.getHost());
            ((JdbcUrlParser)parser.get()).setParameter("port", index, localHostPort.getPort());
            portForwardings.add(new JdbcSettings.PortForwarding(localHostPort.getHost(), localHostPort.getPort(), tunnel.remoteHostPort.getHost(), tunnel.remoteHostPort.getPort()));
            ++index;
        }
        proto.setUrl(((JdbcUrlParser)parser.get()).getUrlText());
        JdbcSettings.PORT_FORWARDINGS.put(proto.getExtraProperties(), portForwardings);
        return true;
    }

    private static boolean sshTunnelProcessed(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto) {
        if (proto == null) {
            SshConnectionInterceptor.$$$reportNull$$$0(1);
        }
        return Boolean.TRUE.equals(SSH_TUNNEL_PROCESSED.get(proto.getExtraProperties()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "proto";
        objectArray2[1] = "com/intellij/database/dataSource/SshConnectionInterceptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "interceptConnectionFast";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "sshTunnelProcessed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

