/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.flask.codeInsight;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.pro.flask.FlaskFQNamesProvider;
import com.intellij.python.pro.flask.codeInsight.FlaskTemplateManager;
import com.intellij.template.lang.core.templateLanguages.TemplateContextProvider;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class FlaskTemplateContextProvider
implements TemplateContextProvider {
    @Override
    public Collection<LookupElement> getTemplateContext(@NotNull PsiFile template) {
        PsiElement flaskModule;
        if (template == null) {
            FlaskTemplateContextProvider.$$$reportNull$$$0(0);
        }
        if ((flaskModule = (PsiElement)PyResolveImportUtil.resolveQualifiedName((QualifiedName)QualifiedName.fromDottedString((String)"flask"), (PyQualifiedNameResolveContext)PyResolveImportUtil.fromFoothold((PsiElement)template)).stream().findFirst().orElse(null)) == null) {
            return null;
        }
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        List<PyStringLiteralExpression> references = FlaskTemplateManager.findTemplateReferences(template);
        if (references.isEmpty()) {
            return null;
        }
        for (PyStringLiteralExpression reference : references) {
            PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference, PyCallExpression.class);
            assert (call != null);
            for (PyExpression arg : call.getArguments()) {
                if (!(arg instanceof PyKeywordArgument)) continue;
                PyKeywordArgument keywordArgument = (PyKeywordArgument)arg;
                String keyword = keywordArgument.getKeyword();
                PyExpression value2 = keywordArgument.getValueExpression();
                if (keyword == null || value2 == null) continue;
                result.add((LookupElement)LookupElementBuilder.create((Object)keywordArgument, (String)keyword));
            }
        }
        if (flaskModule instanceof PsiDirectory) {
            flaskModule = ((PsiDirectory)flaskModule).findFile("__init__.py");
        }
        if (flaskModule instanceof PyFile) {
            PyTargetExpression attribute;
            FlaskTemplateContextProvider.addFlaskVariable(result, (PyFile)flaskModule, "request");
            FlaskTemplateContextProvider.addFlaskVariable(result, (PyFile)flaskModule, "session");
            FlaskTemplateContextProvider.addFlaskVariable(result, (PyFile)flaskModule, "g");
            PyPsiFacade facade = PyPsiFacade.getInstance((Project)flaskModule.getProject());
            Optional<PyClass> flaskClass = Arrays.stream(FlaskFQNamesProvider.FLASK_CLASS.getNames()).map(name -> facade.createClassByQName(name, (PsiElement)template)).filter(o -> o != null).findFirst();
            if (flaskClass.isPresent() && (attribute = flaskClass.get().findInstanceAttribute("config", false)) != null) {
                result.add((LookupElement)LookupElementBuilder.createWithIcon((PsiNamedElement)attribute));
            }
            FlaskTemplateContextProvider.addFlaskVariable(result, (PyFile)flaskModule, "url_for");
            FlaskTemplateContextProvider.addFlaskVariable(result, (PyFile)flaskModule, "get_flashed_messages");
        }
        return result;
    }

    private static void addFlaskVariable(List<LookupElement> result, PyFile module, String name) {
        PsiElement named = module.getElementNamed(name);
        if (named instanceof PsiNamedElement) {
            result.add((LookupElement)LookupElementBuilder.createWithIcon((PsiNamedElement)((PsiNamedElement)named)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/python/pro/flask/codeInsight/FlaskTemplateContextProvider", "getTemplateContext"));
    }
}

