/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.googleai.BaseGeminiChatModel;
import dev.langchain4j.model.googleai.GeminiFunctionCallingConfig;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.GeminiGenerateContentResponse;
import dev.langchain4j.model.googleai.GeminiHarmBlockThreshold;
import dev.langchain4j.model.googleai.GeminiHarmCategory;
import dev.langchain4j.model.googleai.GeminiMode;
import dev.langchain4j.model.googleai.GeminiSafetySetting;
import dev.langchain4j.model.googleai.GeminiStreamingResponseBuilder;
import dev.langchain4j.model.output.Response;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class GoogleAiGeminiStreamingChatModel
extends BaseGeminiChatModel
implements StreamingChatLanguageModel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GoogleAiGeminiStreamingChatModel.class);

    public GoogleAiGeminiStreamingChatModel(String apiKey, String modelName, Double temperature, Integer topK, Double topP, Integer maxOutputTokens, Duration timeout, ResponseFormat responseFormat, List<String> stopSequences, GeminiFunctionCallingConfig toolConfig, Boolean allowCodeExecution, Boolean includeCodeExecutionOutput, Boolean logRequestsAndResponses, List<GeminiSafetySetting> safetySettings, List<ChatModelListener> listeners, Integer maxRetries) {
        super(apiKey, modelName, temperature, topK, topP, maxOutputTokens, timeout, responseFormat, stopSequences, toolConfig, allowCodeExecution, includeCodeExecutionOutput, logRequestsAndResponses, safetySettings, listeners, maxRetries);
    }

    @Override
    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, Collections.emptyList(), handler);
    }

    @Override
    public void generate(List<ChatMessage> messages, ToolSpecification toolSpecification, StreamingResponseHandler<AiMessage> handler) {
        throw new RuntimeException("This method is not supported: Gemini AI cannot be forced to execute a tool.");
    }

    @Override
    public void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, StreamingResponseHandler<AiMessage> handler) {
        ChatRequestParameters parameters = ChatRequestParameters.builder().build();
        GeminiGenerateContentRequest request = this.createGenerateContentRequest(messages, toolSpecifications, this.responseFormat, parameters);
        ChatModelRequest chatModelRequest = this.createChatModelRequest(null, messages, toolSpecifications, parameters);
        ConcurrentHashMap<Object, Object> listenerAttributes = new ConcurrentHashMap<Object, Object>();
        ChatModelRequestContext chatModelRequestContext = new ChatModelRequestContext(chatModelRequest, listenerAttributes);
        this.notifyListenersOnRequest(chatModelRequestContext);
        this.processGenerateContentRequest(request, handler, chatModelRequest, listenerAttributes);
    }

    private void processGenerateContentRequest(GeminiGenerateContentRequest request, StreamingResponseHandler<AiMessage> handler, ChatModelRequest chatModelRequest, ConcurrentHashMap<Object, Object> listenerAttributes) {
        GeminiStreamingResponseBuilder responseBuilder = new GeminiStreamingResponseBuilder(this.includeCodeExecutionOutput);
        try {
            Stream contentStream = RetryUtils.withRetry(() -> this.geminiService.generateContentStream(this.modelName, this.apiKey, request), this.maxRetries);
            contentStream.forEach(partialResponse -> {
                Optional<String> text = responseBuilder.append((GeminiGenerateContentResponse)partialResponse);
                text.ifPresent(handler::onNext);
            });
            Response<AiMessage> fullResponse = responseBuilder.build();
            handler.onComplete(fullResponse);
            this.notifyListenersOnResponse(fullResponse, chatModelRequest, listenerAttributes);
        }
        catch (RuntimeException exception) {
            this.notifyListenersOnError(exception, chatModelRequest, listenerAttributes);
            handler.onError(exception);
        }
    }

    @Generated
    public static GoogleAiGeminiStreamingChatModelBuilder builder() {
        return new GoogleAiGeminiStreamingChatModelBuilder();
    }

    public static class GoogleAiGeminiStreamingChatModelBuilder {
        @Generated
        private String apiKey;
        @Generated
        private String modelName;
        @Generated
        private Double temperature;
        @Generated
        private Integer topK;
        @Generated
        private Double topP;
        @Generated
        private Integer maxOutputTokens;
        @Generated
        private Duration timeout;
        @Generated
        private ResponseFormat responseFormat;
        @Generated
        private List<String> stopSequences;
        @Generated
        private GeminiFunctionCallingConfig toolConfig;
        @Generated
        private Boolean allowCodeExecution;
        @Generated
        private Boolean includeCodeExecutionOutput;
        @Generated
        private Boolean logRequestsAndResponses;
        @Generated
        private List<GeminiSafetySetting> safetySettings;
        @Generated
        private List<ChatModelListener> listeners;
        @Generated
        private Integer maxRetries;

        public GoogleAiGeminiStreamingChatModelBuilder toolConfig(GeminiMode mode, String ... allowedFunctionNames) {
            this.toolConfig = new GeminiFunctionCallingConfig(mode, Arrays.asList(allowedFunctionNames));
            return this;
        }

        public GoogleAiGeminiStreamingChatModelBuilder safetySettings(Map<GeminiHarmCategory, GeminiHarmBlockThreshold> safetySettingMap) {
            this.safetySettings = safetySettingMap.entrySet().stream().map(entry -> new GeminiSafetySetting((GeminiHarmCategory)((Object)((Object)entry.getKey())), (GeminiHarmBlockThreshold)((Object)((Object)entry.getValue())))).collect(Collectors.toList());
            return this;
        }

        @Generated
        GoogleAiGeminiStreamingChatModelBuilder() {
        }

        @Generated
        public GoogleAiGeminiStreamingChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public GoogleAiGeminiStreamingChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Generated
        public GoogleAiGeminiStreamingChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public GoogleAiGeminiStreamingChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        @Generated
        public GoogleAiGeminiStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public GoogleAiGeminiStreamingChatModelBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        @Generated
        public GoogleAiGeminiStreamingChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public GoogleAiGeminiStreamingChatModelBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        @Generated
        public GoogleAiGeminiStreamingChatModelBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        @Generated
        public GoogleAiGeminiStreamingChatModelBuilder allowCodeExecution(Boolean allowCodeExecution) {
            this.allowCodeExecution = allowCodeExecution;
            return this;
        }

        @Generated
        public GoogleAiGeminiStreamingChatModelBuilder includeCodeExecutionOutput(Boolean includeCodeExecutionOutput) {
            this.includeCodeExecutionOutput = includeCodeExecutionOutput;
            return this;
        }

        @Generated
        public GoogleAiGeminiStreamingChatModelBuilder logRequestsAndResponses(Boolean logRequestsAndResponses) {
            this.logRequestsAndResponses = logRequestsAndResponses;
            return this;
        }

        @Generated
        public GoogleAiGeminiStreamingChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        @Generated
        public GoogleAiGeminiStreamingChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public GoogleAiGeminiStreamingChatModel build() {
            return new GoogleAiGeminiStreamingChatModel(this.apiKey, this.modelName, this.temperature, this.topK, this.topP, this.maxOutputTokens, this.timeout, this.responseFormat, this.stopSequences, this.toolConfig, this.allowCodeExecution, this.includeCodeExecutionOutput, this.logRequestsAndResponses, this.safetySettings, this.listeners, this.maxRetries);
        }

        @Generated
        public String toString() {
            return "GoogleAiGeminiStreamingChatModel.GoogleAiGeminiStreamingChatModelBuilder(apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", topK=" + this.topK + ", topP=" + this.topP + ", maxOutputTokens=" + this.maxOutputTokens + ", timeout=" + String.valueOf(this.timeout) + ", responseFormat=" + String.valueOf(this.responseFormat) + ", stopSequences=" + String.valueOf(this.stopSequences) + ", toolConfig=" + String.valueOf(this.toolConfig) + ", allowCodeExecution=" + this.allowCodeExecution + ", includeCodeExecutionOutput=" + this.includeCodeExecutionOutput + ", logRequestsAndResponses=" + this.logRequestsAndResponses + ", safetySettings=" + String.valueOf(this.safetySettings) + ", listeners=" + String.valueOf(this.listeners) + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

