/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.util.Objects;

public class NSNumber
extends NSObject {
    public static final int INTEGER = 0;
    public static final int REAL = 1;
    public static final int BOOLEAN = 2;
    private static final String NAN_SYMBOL = "nan";
    private static final String POSTIIVE_INFINITY_SYMBOL = "+infinity";
    private static final String NEGATIVE_INFINITY_SYMBOL = "-infinity";
    private static final String TRUE_SYMBOL = "true";
    private static final String YES_SYMBOL = "YES";
    private static final String FALSE_SYMBOL = "false";
    private static final String NO_SYMOBL = "NO";
    private int type;
    private long longValue;
    private double doubleValue;
    private boolean boolValue;

    public NSNumber(byte[] bytes, int type) {
        this(bytes, 0, bytes.length, type);
    }

    public NSNumber(byte[] bytes, int startIndex, int endIndex, int type) {
        switch (type) {
            case 0: {
                this.longValue = BinaryPropertyListParser.parseLong(bytes, startIndex, endIndex);
                this.doubleValue = this.longValue;
                break;
            }
            case 1: {
                this.doubleValue = BinaryPropertyListParser.parseDouble(bytes, startIndex, endIndex);
                this.longValue = Math.round(this.doubleValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type argument is not valid.");
            }
        }
        this.type = type;
    }

    public NSNumber(String text) {
        if (text == null) {
            throw new IllegalArgumentException("The given string is null and cannot be parsed as number.");
        }
        if (text.equalsIgnoreCase(TRUE_SYMBOL) || text.equalsIgnoreCase(YES_SYMBOL)) {
            this.type = 2;
            this.boolValue = true;
            this.longValue = 1L;
            this.doubleValue = 1L;
        } else if (text.equalsIgnoreCase(FALSE_SYMBOL) || text.equalsIgnoreCase(NO_SYMOBL)) {
            this.type = 2;
            this.boolValue = false;
            this.longValue = 0L;
            this.doubleValue = 0L;
        } else if (text.equalsIgnoreCase(NAN_SYMBOL)) {
            this.doubleValue = Double.NaN;
            this.longValue = 0L;
            this.type = 1;
        } else if (text.equalsIgnoreCase(POSTIIVE_INFINITY_SYMBOL)) {
            this.doubleValue = Double.POSITIVE_INFINITY;
            this.longValue = 0L;
            this.type = 1;
        } else if (text.equalsIgnoreCase(NEGATIVE_INFINITY_SYMBOL)) {
            this.doubleValue = Double.NEGATIVE_INFINITY;
            this.longValue = 0L;
            this.type = 1;
        } else {
            try {
                long l = text.startsWith("0x") ? Long.parseLong(text.substring(2), 16) : Long.parseLong(text);
                this.longValue = l;
                this.doubleValue = this.longValue;
                this.type = 0;
            }
            catch (Exception ex2) {
                try {
                    this.doubleValue = Double.parseDouble(text);
                    this.longValue = Math.round(this.doubleValue);
                    this.type = 1;
                }
                catch (Exception ex22) {
                    throw new IllegalArgumentException("The given string neither represents a double, an int nor a boolean value.");
                }
            }
        }
    }

    public NSNumber(int i2) {
        this.longValue = i2;
        this.doubleValue = this.longValue;
        this.type = 0;
    }

    public NSNumber(long l) {
        this.longValue = l;
        this.doubleValue = this.longValue;
        this.type = 0;
    }

    public NSNumber(double d) {
        this.doubleValue = d;
        this.longValue = (long)this.doubleValue;
        this.type = 1;
    }

    public NSNumber(boolean b) {
        this.boolValue = b;
        this.longValue = b ? 1L : 0L;
        this.doubleValue = this.longValue;
        this.type = 2;
    }

    public int type() {
        return this.type;
    }

    public boolean isBoolean() {
        return this.type == 2;
    }

    public boolean isInteger() {
        return this.type == 0;
    }

    public boolean isReal() {
        return this.type == 1;
    }

    public boolean boolValue() {
        if (this.type == 2) {
            return this.boolValue;
        }
        return !Double.isNaN(this.doubleValue) && this.doubleValue != 0.0;
    }

    public long longValue() {
        this.throwIfIntegerValueNotAvailable();
        return this.longValue;
    }

    public int intValue() {
        this.throwIfIntegerValueNotAvailable();
        return (int)this.longValue;
    }

    public double doubleValue() {
        return this.doubleValue;
    }

    public float floatValue() {
        return (float)this.doubleValue;
    }

    public String stringValue() {
        switch (this.type) {
            case 0: {
                return String.valueOf(this.longValue);
            }
            case 1: {
                return this.getRealStringRepresentation();
            }
            case 2: {
                return String.valueOf(this.boolValue);
            }
        }
        throw new IllegalStateException("The NSNumber instance has an invalid type: " + this.type);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NSNumber n = (NSNumber)obj;
        return this.type == n.type && this.longValue == n.longValue && this.doubleValue == n.doubleValue && this.boolValue == n.boolValue;
    }

    public int hashCode() {
        int hash = this.type;
        hash = 37 * hash + (int)(this.longValue ^ this.longValue >>> 32);
        hash = 37 * hash + (int)(Double.doubleToLongBits(this.doubleValue) ^ Double.doubleToLongBits(this.doubleValue) >>> 32);
        hash = 37 * hash + (this.boolValue() ? 1 : 0);
        return hash;
    }

    @Override
    public NSNumber clone() {
        switch (this.type) {
            case 0: {
                return new NSNumber(this.longValue);
            }
            case 1: {
                return new NSNumber(this.doubleValue);
            }
            case 2: {
                return new NSNumber(this.boolValue);
            }
        }
        throw new IllegalStateException("The NSNumber instance has an invalid type: " + this.type);
    }

    public String toString() {
        switch (this.type()) {
            case 0: {
                return String.valueOf(this.longValue);
            }
            case 1: {
                return this.getRealStringRepresentation();
            }
            case 2: {
                return String.valueOf(this.boolValue);
            }
        }
        return super.toString();
    }

    @Override
    public Object toJavaObject() {
        switch (this.type) {
            case 0: {
                long longVal = this.longValue();
                if (longVal > Integer.MAX_VALUE || longVal < Integer.MIN_VALUE) {
                    return longVal;
                }
                return this.intValue();
            }
            case 2: {
                return this.boolValue();
            }
        }
        return this.doubleValue();
    }

    @Override
    public int compareTo(NSObject o) {
        Objects.requireNonNull(o);
        if (o == this) {
            return 0;
        }
        if (o instanceof NSNumber) {
            NSNumber other = (NSNumber)o;
            return Double.compare(this.doubleValue, other.doubleValue);
        }
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    @Override
    void toXML(StringBuilder xml, int level) {
        this.indent(xml, level);
        switch (this.type()) {
            case 0: {
                xml.append("<integer>");
                xml.append(this.longValue);
                xml.append("</integer>");
                break;
            }
            case 1: {
                xml.append("<real>");
                xml.append(this.getRealStringRepresentation());
                xml.append("</real>");
                break;
            }
            case 2: {
                if (this.boolValue) {
                    xml.append("<true/>");
                    break;
                }
                xml.append("<false/>");
                break;
            }
            default: {
                throw new IllegalStateException("The NSNumber instance has an invalid type: " + this.type);
            }
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter out) throws IOException {
        switch (this.type()) {
            case 0: {
                if (this.longValue() < 0L) {
                    out.write(19);
                    out.writeBytes(this.longValue, 8);
                    break;
                }
                if (this.longValue <= 255L) {
                    out.write(16);
                    out.writeBytes(this.longValue(), 1);
                    break;
                }
                if (this.longValue <= 65535L) {
                    out.write(17);
                    out.writeBytes(this.longValue(), 2);
                    break;
                }
                if (this.longValue <= 0xFFFFFFFFL) {
                    out.write(18);
                    out.writeBytes(this.longValue, 4);
                    break;
                }
                out.write(19);
                out.writeBytes(this.longValue, 8);
                break;
            }
            case 1: {
                out.write(35);
                out.writeDouble(this.doubleValue);
                break;
            }
            case 2: {
                out.write(this.boolValue ? 9 : 8);
                break;
            }
            default: {
                throw new IllegalStateException("The NSNumber instance has an invalid type: " + this.type);
            }
        }
    }

    @Override
    protected void toASCII(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        if (this.isBoolean()) {
            ascii.append(this.boolValue ? YES_SYMBOL : NO_SYMOBL);
        } else {
            ascii.append(this.stringValue());
        }
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        switch (this.type()) {
            case 0: {
                ascii.append("<*I");
                ascii.append(this.longValue);
                ascii.append('>');
                break;
            }
            case 1: {
                ascii.append("<*R");
                ascii.append(this.getRealStringRepresentation());
                ascii.append('>');
                break;
            }
            case 2: {
                if (this.boolValue()) {
                    ascii.append("<*BY>");
                    break;
                }
                ascii.append("<*BN>");
                break;
            }
            default: {
                throw new IllegalStateException("The NSNumber instance has an invalid type: " + this.type);
            }
        }
    }

    private void throwIfIntegerValueNotAvailable() {
        if (this.type == 1) {
            if (Double.isNaN(this.doubleValue)) {
                throw new IllegalStateException("The integer value is not available because the value of this NSNumber instance is NaN.");
            }
            if (this.doubleValue == Double.POSITIVE_INFINITY) {
                throw new IllegalStateException("The integer value is not available because the value of this NSNumber instance is positive infinity.");
            }
            if (this.doubleValue == Double.NEGATIVE_INFINITY) {
                throw new IllegalStateException("The integer value is not available because the value of this NSNumber instance is negative infinity.");
            }
        }
    }

    private String getRealStringRepresentation() {
        if (Double.isNaN(this.doubleValue)) {
            return NAN_SYMBOL;
        }
        if (this.doubleValue == Double.POSITIVE_INFINITY) {
            return POSTIIVE_INFINITY_SYMBOL;
        }
        if (this.doubleValue == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY_SYMBOL;
        }
        return String.valueOf(this.doubleValue);
    }
}

