/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.inline.tracking;

import com.intellij.ml.inline.completion.impl.inline.tracking.MLCompletionUsageTracker;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0014J\u0006\u0010\u0017\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\u0014J\u0006\u0010\u0019\u001a\u00020\u0014J\b\u0010\u001a\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/tracking/MLCompletionUsageTracker;", "", "<init>", "()V", "hintsShownCountAtomic", "Ljava/util/concurrent/atomic/AtomicInteger;", "consecutiveImmediateSuggestionTrimsAfterAcceptAtomic", "acceptedSuggestionsAtomic", "consecutiveImplicitRejectionsAtomic", "lastSuggestionShownInMillis", "Ljava/util/concurrent/atomic/AtomicLong;", "hintsShown", "", "getHintsShown", "()I", "consecutiveImmediateSuggestionTrimsAfterAccept", "getConsecutiveImmediateSuggestionTrimsAfterAccept", "acceptedSuggestions", "getAcceptedSuggestions", "onHintShown", "", "onSuggestionImmediatelyTrimmedFromEnd", "onSuggestionImmediatelyUntouched", "onSuggestionAccepted", "onCompletionImplicitlyRejected", "resetConsecutiveImplicitRejections", "resetAfterInactivityPeriod", "Companion", "intellij.fullLine.core.completion"})
@ApiStatus.Internal
public final class MLCompletionUsageTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicInteger hintsShownCountAtomic = new AtomicInteger(0);
    @NotNull
    private final AtomicInteger consecutiveImmediateSuggestionTrimsAfterAcceptAtomic = new AtomicInteger(0);
    @NotNull
    private final AtomicInteger acceptedSuggestionsAtomic = new AtomicInteger(0);
    @NotNull
    private final AtomicInteger consecutiveImplicitRejectionsAtomic = new AtomicInteger(0);
    @NotNull
    private final AtomicLong lastSuggestionShownInMillis = new AtomicLong(System.currentTimeMillis());
    private static final int INITIAL_HINTS_SHOWN_COUNT = 0;
    private static final int INITIAL_CONSECUTIVE_TRIMS_AFTER_ACCEPT = 0;
    private static final int INITIAL_ACCEPTED_SUGGESTIONS = 0;
    private static final int INITIAL_CONSECUTIVE_IMPLICIT_REJECTIONS = 0;
    private static final int IMPLICIT_REJECTION_RESET_THRESHOLD = 10;
    private static final long INACTIVITY_RESET_PERIOD_MILLIS = 3600000L;
    @NotNull
    private static final ConcurrentHashMap<String, MLCompletionUsageTracker> trackerForLanguage = new ConcurrentHashMap();

    public final int getHintsShown() {
        return this.hintsShownCountAtomic.get();
    }

    public final int getConsecutiveImmediateSuggestionTrimsAfterAccept() {
        return this.consecutiveImmediateSuggestionTrimsAfterAcceptAtomic.get();
    }

    public final int getAcceptedSuggestions() {
        return this.acceptedSuggestionsAtomic.get();
    }

    public final void onHintShown() {
        this.resetAfterInactivityPeriod();
        this.hintsShownCountAtomic.incrementAndGet();
        this.lastSuggestionShownInMillis.set(System.currentTimeMillis());
    }

    public final void onSuggestionImmediatelyTrimmedFromEnd() {
        this.consecutiveImmediateSuggestionTrimsAfterAcceptAtomic.incrementAndGet();
    }

    public final void onSuggestionImmediatelyUntouched() {
        this.consecutiveImmediateSuggestionTrimsAfterAcceptAtomic.set(0);
    }

    public final void onSuggestionAccepted() {
        this.acceptedSuggestionsAtomic.incrementAndGet();
    }

    public final void onCompletionImplicitlyRejected() {
        int rejectionCount = this.consecutiveImplicitRejectionsAtomic.incrementAndGet();
        if (rejectionCount >= 10) {
            this.acceptedSuggestionsAtomic.set(0);
        }
    }

    public final void resetConsecutiveImplicitRejections() {
        this.consecutiveImplicitRejectionsAtomic.set(0);
    }

    private final void resetAfterInactivityPeriod() {
        long lastShown;
        long now = System.currentTimeMillis();
        if (now - (lastShown = this.lastSuggestionShownInMillis.get()) >= 3600000L) {
            this.hintsShownCountAtomic.set(0);
            this.consecutiveImmediateSuggestionTrimsAfterAcceptAtomic.set(0);
            this.acceptedSuggestionsAtomic.set(0);
            this.consecutiveImplicitRejectionsAtomic.set(0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/tracking/MLCompletionUsageTracker$Companion;", "", "<init>", "()V", "INITIAL_HINTS_SHOWN_COUNT", "", "INITIAL_CONSECUTIVE_TRIMS_AFTER_ACCEPT", "INITIAL_ACCEPTED_SUGGESTIONS", "INITIAL_CONSECUTIVE_IMPLICIT_REJECTIONS", "IMPLICIT_REJECTION_RESET_THRESHOLD", "INACTIVITY_RESET_PERIOD_MILLIS", "", "trackerForLanguage", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/ml/inline/completion/impl/inline/tracking/MLCompletionUsageTracker;", "getOrCreate", "languageId", "intellij.fullLine.core.completion"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MLCompletionUsageTracker getOrCreate(@NotNull String languageId) {
            Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
            MLCompletionUsageTracker mLCompletionUsageTracker = trackerForLanguage.computeIfAbsent(languageId, arg_0 -> Companion.getOrCreate$lambda$0(getOrCreate.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)mLCompletionUsageTracker, (String)"computeIfAbsent(...)");
            return mLCompletionUsageTracker;
        }

        private static final MLCompletionUsageTracker getOrCreate$lambda$0(Function1 $tmp0, Object p0) {
            return (MLCompletionUsageTracker)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

