/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.channels;

import com.google.common.net.HostAndPort;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.channels.SshChannel;
import com.intellij.ssh.impl.sshj.SshjSshConnection;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.ssh.impl.sshj.channels.EofSendingOutputStream;
import com.intellij.ssh.impl.sshj.tunnels.SingleTunnelBrokerKt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.transport.Transport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010%\u001a\u00020&H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0014\u0010\u001e\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006'"}, d2={"Lcom/intellij/ssh/impl/sshj/channels/SshjSshChannel;", "Lcom/intellij/ssh/channels/SshChannel;", "sshConnection", "Lcom/intellij/ssh/impl/sshj/SshjSshConnection;", "channel", "Lnet/schmizz/sshj/connection/channel/Channel;", "SshjSshChannel", "(Lcom/intellij/ssh/impl/sshj/SshjSshConnection;Lnet/schmizz/sshj/connection/channel/Channel;)V", "getSshConnection", "()Lcom/intellij/ssh/impl/sshj/SshjSshConnection;", "disconnectionState", "Ljava/util/concurrent/atomic/AtomicInteger;", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "getOutputStream", "()Ljava/io/OutputStream;", "close", "", "isClosed", "", "()Z", "isConnected", "getLocalTunnel", "Lcom/google/common/net/HostAndPort;", "remotePort", "", "exitStatus", "getExitStatus", "()I", "sshSession", "Lcom/intellij/ssh/SshSession;", "getSshSession", "()Lcom/intellij/ssh/SshSession;", "toString", "", "intellij.platform.ssh"})
public abstract class SshjSshChannel
implements SshChannel {
    @NotNull
    private final SshjSshConnection sshConnection;
    @NotNull
    private final Channel channel;
    @NotNull
    private final AtomicInteger disconnectionState;
    @NotNull
    private final InputStream inputStream;
    @NotNull
    private final OutputStream outputStream;
    @NotNull
    private final SshSession sshSession;

    public SshjSshChannel(@NotNull SshjSshConnection sshConnection, @NotNull Channel channel2) {
        Intrinsics.checkNotNullParameter((Object)sshConnection, (String)"sshConnection");
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        this.sshConnection = sshConnection;
        this.channel = channel2;
        this.disconnectionState = new AtomicInteger(0);
        InputStream inputStream2 = this.channel.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
        this.inputStream = inputStream2;
        Transport transport = this.sshConnection.getSshjBackend$intellij_platform_ssh().getTransport();
        Intrinsics.checkNotNullExpressionValue((Object)transport, (String)"getTransport(...)");
        OutputStream outputStream2 = this.channel.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"getOutputStream(...)");
        this.outputStream = new EofSendingOutputStream(transport, this.channel, outputStream2);
        this.sshSession = this.sshConnection;
    }

    @NotNull
    protected final SshjSshConnection getSshConnection() {
        return this.sshConnection;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void close() {
        if (!this.disconnectionState.compareAndSet(0, 1)) {
            return;
        }
        AppExecutorUtil.getAppExecutorService().execute(() -> SshjSshChannel.S(this));
    }

    @Override
    public boolean isClosed() {
        return !this.channel.isOpen();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isOpen() || this.disconnectionState.get() == 1;
    }

    @Override
    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        return this.sshConnection.getLocalTunnel$intellij_platform_ssh(remotePort);
    }

    @Override
    public int getExitStatus() {
        throw new IllegalStateException("Called exitStatus() of non-exec channel");
    }

    @Override
    @NotNull
    public SshSession getSshSession() {
        return this.sshSession;
    }

    @NotNull
    public String toString() {
        return "Channel@" + UtilKt.hexId(this) + " id " + this.channel.getID() + ", remote id " + this.channel.getRecipient() + " for " + this.sshConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void S(SshjSshChannel sshjSshChannel) {
        try {
            sshjSshChannel.channel.close();
        }
        catch (IOException iOException) {
            if (SingleTunnelBrokerKt.getCausedByConnectionLoss(iOException) || ExceptionUtil.causedBy((Throwable)iOException, TimeoutException.class)) {
                UtilKt.getSSHJ_LOG().info("Error while closing " + sshjSshChannel.channel, (Throwable)iOException);
            } else {
                UtilKt.getSSHJ_LOG().error("Error while closing " + sshjSshChannel.channel, (Throwable)iOException);
            }
        }
        finally {
            sshjSshChannel.disconnectionState.set(2);
        }
    }
}

