/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.psi;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.scss.SCSSElementTypes;
import org.jetbrains.plugins.scss.psi.SassScssElementImpl;
import org.jetbrains.plugins.scss.psi.SassScssUseAs;
import org.jetbrains.plugins.scss.psi.SassScssUseAtRule;

public class SassScssUseAtRuleImpl
extends SassScssElementImpl
implements SassScssUseAtRule {
    public SassScssUseAtRuleImpl() {
        super(SCSSElementTypes.SCSS_USE_AT_RULE);
    }

    public boolean isAsterisk() {
        SassScssUseAs useAs = (SassScssUseAs)PsiTreeUtil.getChildOfType((PsiElement)this, SassScssUseAs.class);
        return useAs != null && useAs.getLastChild().getNode().getElementType() == CssElementTypes.CSS_ASTERISK;
    }

    @Nullable
    public PsiElement getAliasElement() {
        PsiElement lastElement;
        SassScssUseAs useAs = (SassScssUseAs)PsiTreeUtil.getChildOfType((PsiElement)this, SassScssUseAs.class);
        if (useAs != null && (lastElement = useAs.getLastChild()).getNode().getElementType() == CssElementTypes.CSS_IDENT) {
            return lastElement;
        }
        return null;
    }

    @Nullable
    public String getQualifier() {
        String url;
        if (this.isAsterisk()) {
            return null;
        }
        PsiElement aliasElement = this.getAliasElement();
        if (aliasElement != null) {
            return aliasElement.getText();
        }
        CssString urlElement = this.getTargetUrl();
        String string = url = urlElement != null ? urlElement.getValue() : null;
        if (url == null || url.isEmpty() || url.equals("sass:") || url.endsWith("/")) {
            return null;
        }
        if (url.startsWith("sass:")) {
            return url.substring("sass:".length());
        }
        String fileName = PathUtil.getFileName((String)url);
        return StringUtil.trimStart((String)FileUtil.getNameWithoutExtension((String)fileName), (String)"_");
    }

    @Nullable
    public CssString getTargetUrl() {
        return (CssString)PsiTreeUtil.getChildOfType((PsiElement)this, CssString.class);
    }

    public PsiFile @NotNull [] resolveTargetFiles() {
        PsiFile[] psiFileArray = CssResolveManager.getInstance().resolveFiles((PsiElement)this.getTargetUrl());
        if (psiFileArray == null) {
            SassScssUseAtRuleImpl.$$$reportNull$$$0(0);
        }
        return psiFileArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/psi/SassScssUseAtRuleImpl", "resolveTargetFiles"));
    }
}

