/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSChangeVisibilityUtil {
    public static void setVisibility(JSAttributeListOwner element2, @Nullable JSAttributeList.AccessType visibility) {
        if (visibility == null) {
            return;
        }
        JSChangeVisibilityUtil.setVisibility(element2, visibility, null);
    }

    public static void setVisibility(JSAttributeListOwner element2, String visibility) {
        if (visibility != null) {
            JSChangeVisibilityUtil.setVisibility(element2, JSAttributeList.AccessType.valueOf((String)visibility));
        }
    }

    public static void setVisibility(@NotNull JSAttributeListOwner startElement, @Nullable JSAttributeList.AccessType visibility, @Nullable String namespace) {
        JSAttributeListWrapper wrapper;
        if (startElement == null) {
            JSChangeVisibilityUtil.$$$reportNull$$$0(0);
        }
        if ((wrapper = JSChangeVisibilityUtil.createVisibilityOverrideWrapper(startElement, visibility, namespace)) == null) {
            return;
        }
        wrapper.applyTo(startElement, true);
    }

    @Nullable
    public static JSAttributeListWrapper createVisibilityOverrideWrapper(@NotNull JSAttributeListOwner startElement, @Nullable JSAttributeList.AccessType visibility, @Nullable String namespace) {
        if (startElement == null) {
            JSChangeVisibilityUtil.$$$reportNull$$$0(1);
        }
        if (startElement.isPhysical()) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)startElement)) {
                return null;
            }
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(startElement);
        if (visibility != null) {
            wrapper.overrideAccessType(visibility);
        } else if (namespace != null) {
            wrapper.overrideNamespace(namespace);
        }
        return wrapper;
    }

    public static void removeAccessModifier(JSAttributeListOwner element2) {
        JSAttributeList attributeList = element2.getAttributeList();
        if (attributeList == null) {
            return;
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(attributeList);
        wrapper.removeAccessModifier();
        wrapper.applyTo(element2);
    }

    public static String accessTypeToCodeString(@NotNull JSAttributeList.AccessType type2, @Nullable PsiElement context2) {
        DialectOptionHolder holder;
        if (type2 == null) {
            JSChangeVisibilityUtil.$$$reportNull$$$0(2);
        }
        DialectOptionHolder dialectOptionHolder = holder = context2 == null ? null : DialectDetector.dialectOfElement((PsiElement)context2);
        if (holder != null && holder.isECMA6) {
            return "";
        }
        if (type2 == JSAttributeList.AccessType.PUBLIC && holder != null && holder.isTypeScript && !TypeScriptCodeStyleSettings.getTypeScriptSettings((PsiElement)context2).USE_PUBLIC_MODIFIER) {
            return "";
        }
        return JSVisibilityUtil.accessTypeToKeyword((JSAttributeList.AccessType)type2, (DialectOptionHolder)holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSChangeVisibilityUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setVisibility";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisibilityOverrideWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "accessTypeToCodeString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

