/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.MetaDataUtil;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.sql.SQLException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableFKeyColumnIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.TableFKeyColumn> {
    private final DatabaseMetaDataWrapper.Table myTable;
    private int myNumber;

    public TableFKeyColumnIt(@Nullable RemoteResultSet rs, @NotNull DatabaseMetaDataWrapper.Table table) throws SQLException {
        if (table == null) {
            TableFKeyColumnIt.$$$reportNull$$$0(0);
        }
        super(rs);
        this.myTable = table;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.TableFKeyColumn createStorage() {
        return new DatabaseMetaDataWrapper.TableFKeyColumn(new DatabaseMetaDataWrapper.TableFKey(this.myTable, new DatabaseMetaDataWrapper.Table(new DatabaseMetaDataWrapper.Schema("", null), ""), ""));
    }

    @Override
    protected DatabaseMetaDataWrapper.TableFKeyColumn calcValue() {
        DatabaseMetaDataWrapper.TableFKeyColumn res = (DatabaseMetaDataWrapper.TableFKeyColumn)this.getStorageToFill();
        try {
            Object fkName;
            String targetName = this.myRs.getString("PKTABLE_NAME", 3);
            String sourceName = this.myRs.getString("FKTABLE_NAME", 7);
            if (StringUtil.isEmpty((String)targetName) || StringUtil.isEmpty((String)sourceName)) {
                return (DatabaseMetaDataWrapper.TableFKeyColumn)this.skip();
            }
            String srcSchema = StringUtil.notNullize((String)this.myRs.getString("FKTABLE_SCHEM", 6), (String)this.myTable.schema.schema);
            if (!Objects.equals(srcSchema, this.myTable.schema.schema) || !Objects.equals(sourceName, this.myTable.name)) {
                return (DatabaseMetaDataWrapper.TableFKeyColumn)this.skip();
            }
            res.position = this.myRs.getShort("KEY_SEQ", 9);
            if (res.position == 0 || res.position == 1) {
                ++this.myNumber;
            }
            if (StringUtil.isEmpty((String)(fkName = this.myRs.getString("FK_NAME", 12)))) {
                fkName = "#FAKE_" + sourceName + "_" + this.myNumber;
                res.fk.surrogateName = true;
            } else {
                res.fk.surrogateName = false;
            }
            res.fk.name = fkName;
            res.fk.targetTable.schema.database = (String)ObjectUtils.chooseNotNull((Object)StringUtil.nullize((String)this.myRs.getString("PKTABLE_CAT", 1)), (Object)this.myTable.schema.database);
            res.fk.targetTable.schema.schema = (String)ObjectUtils.chooseNotNull((Object)this.myRs.getString("PKTABLE_SCHEM", 2), (Object)this.myTable.schema.schema);
            res.fk.targetTable.name = targetName;
            res.fk.updateRule = this.myRs.getShort("UPDATE_RULE", 10);
            res.fk.deleteRule = this.myRs.getShort("DELETE_RULE", 11);
            res.fk.deferrability = this.myRs.getShort("DEFERRABILITY", 14);
            res.name = this.myRs.getString("FKCOLUMN_NAME", 8);
            res.targetName = this.myRs.getString("PKCOLUMN_NAME", 4);
        }
        catch (SQLException e) {
            this.onError(res, e);
            return (DatabaseMetaDataWrapper.TableFKeyColumn)this.skip();
        }
        return res;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.TableFKeyColumn cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.fk.table.schema.database, cur.fk.table.schema.schema, cur.fk.table.name);
        this.addError(title, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableFKeyColumnIt", "<init>"));
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.TableFKey, DatabaseMetaDataWrapper.TableFKeyColumn, DatabaseMetaDataWrapper.TableFKeyColumn> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.TableFKeyColumn> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableFKeyColumn> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.TableFKeyColumn> it) {
            final String fkName = ((DatabaseMetaDataWrapper.TableFKeyColumn)it.current()).fk.name;
            return new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableFKeyColumn>(this, it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.TableFKeyColumn item) {
                    return Objects.equals(fkName, item.fk.name);
                }
            };
        }

        @Override
        protected DatabaseMetaDataWrapper.TableFKey getItem(ClosableIt<DatabaseMetaDataWrapper.TableFKeyColumn> it) {
            return ((DatabaseMetaDataWrapper.TableFKeyColumn)it.current()).fk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableFKeyColumnIt$Grouping", "<init>"));
        }
    }
}

