/*************************************************************
 *
 *  MathJax/jax/output/SVG/fonts/TeX/svg/Main/Bold/MathOperators.js
 *
 *  Copyright (c) 2011-2019 The MathJax Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

MathJax.Hub.Insert(
  MathJax.OutputJax.SVG.FONTDATA.FONTS['MathJax_Main-bold'],
  {
    // FOR ALL
    0x2200: [694,16,639,0,640,'1 664Q-2 685 23 693H27Q46 693 54 680T102 578L148 475H492L533 570Q541 586 548 603T560 630T569 650T576 667T582 678T588 686T594 691T600 693T609 694Q622 694 631 684T639 662Q637 653 492 325T341 -8Q333 -16 320 -16Q306 -16 298 -8Q294 -4 147 326L1 656V664ZM464 414H319Q175 414 175 413L319 88L464 414'],

    // PARTIAL DIFFERENTIAL
    0x2202: [710,17,628,60,657,'230 475Q202 475 189 492T175 526T186 570T221 631T288 687T389 710Q430 710 438 709Q495 701 537 679T601 629T637 568T653 509T657 459Q657 409 640 341Q617 248 581 180T507 75T424 16T348 -11T282 -17Q171 -17 113 37Q60 88 60 159Q60 192 71 231Q96 336 184 402Q264 462 366 462Q407 462 439 448T497 389L502 380Q503 381 508 403T519 463T525 531Q523 580 499 610T447 648T387 657Q324 657 283 616Q271 604 276 604Q279 604 286 600T302 583T311 555Q311 523 287 499T230 475ZM196 110Q196 41 287 41Q351 41 398 88Q422 111 437 151Q473 243 473 298Q473 386 409 409Q408 409 383 411Q316 411 278 373Q265 360 259 351T241 311T217 226Q196 143 196 110'],

    // THERE EXISTS
    0x2203: [694,-1,639,64,574,'81 347Q81 359 84 363T104 378H513V633H300L87 634Q64 642 64 664Q64 685 84 692Q89 694 321 694H552Q571 681 574 669V25Q567 7 552 1H87Q64 12 64 30T87 61H513V317H308Q103 317 99 319Q81 328 81 347'],

    // EMPTY SET
    0x2205: [767,73,575,46,528,'285 711Q307 711 326 708T357 701T370 698Q371 698 375 710T383 735T389 750Q395 767 415 767Q431 767 438 757T446 738T436 701T426 670Q426 668 433 664Q468 633 489 588Q511 542 519 488T528 344Q528 286 524 243T508 150T466 63T394 6Q345 -17 287 -17Q265 -17 246 -14T216 -7T203 -4Q191 -47 183 -60T159 -73Q146 -73 137 -63T128 -44Q128 -38 138 -7L148 24L141 30Q134 35 120 49Q94 77 78 113T56 194T48 268T46 344Q46 388 47 416T56 494T78 577T122 644T194 694Q239 711 285 711ZM351 639Q350 639 346 642T337 648T325 654T306 658T283 660Q254 660 221 638T181 567Q171 513 171 375Q171 164 182 129L351 639ZM402 356Q402 516 395 555Q395 557 395 559T394 563T394 566L393 568L223 57Q252 34 286 34H288Q318 34 346 53T387 109Q402 152 402 329V356'],

    // NABLA
    0x2207: [686,24,958,56,901,'56 673Q56 679 65 686H892Q901 679 901 673Q901 668 714 331T521 -15Q518 -18 506 -24H452Q440 -19 436 -15Q431 -8 337 162T150 501L57 669Q57 670 56 672V673ZM528 136L758 553H297Q298 551 414 341L528 136'],

    // ELEMENT OF
    0x2208: [587,86,767,97,671,'97 251Q97 393 194 484T417 586Q418 586 436 586T482 586T538 587H648Q649 586 652 584T658 580T664 575T668 568T670 557Q670 536 648 527L534 526Q515 526 491 526T457 526T435 526T417 525T404 523T390 521T374 517Q298 498 243 447T167 324Q159 295 159 283Q159 281 403 281H648Q649 280 652 278T658 274T664 269T668 262T670 251Q670 230 648 221L403 220Q159 220 159 218Q159 206 166 182T190 122T247 50T341 -6Q380 -20 405 -22T534 -25H648Q649 -26 654 -29T661 -34T667 -43T670 -56Q670 -74 648 -85L541 -86Q419 -86 396 -82Q276 -65 187 24T97 251'],

    // stix-negated (vert) set membership, variant
    0x2209: [711,210,767,97,671,'126 -210Q116 -210 107 -203T97 -179Q97 -171 99 -166Q99 -165 111 -145T150 -80T203 8Q97 104 97 251Q97 393 194 484T417 586Q418 586 436 586T482 586T538 587H549Q565 614 582 643T608 685L616 698Q623 711 641 711Q651 711 660 704T670 681Q670 672 667 667Q666 666 661 657T644 627T620 587H648Q649 586 652 584T658 580T664 575T668 568T670 557Q670 536 648 527L584 526L437 281H648Q649 280 652 278T658 274T664 269T668 262T670 251Q670 230 648 221L403 220H401L283 23Q311 5 341 -6Q380 -20 405 -22T534 -25H648Q649 -26 654 -29T661 -34T667 -43T670 -56Q670 -74 648 -85L541 -86Q419 -86 396 -82Q320 -71 252 -29Q152 -197 148 -201Q139 -210 126 -210ZM235 62L330 220Q159 219 159 218Q159 196 176 150T235 62ZM366 281L513 526Q503 526 487 526T465 526T448 525T433 525T422 525T412 524T403 523T394 521T385 519T374 517Q298 498 243 447T167 324Q159 295 159 283Q159 281 366 281'],

    // CONTAINS AS MEMBER
    0x220B: [588,86,767,96,670,'96 251Q96 268 119 281H363Q607 281 607 283Q607 295 600 319T576 379T519 451T425 507Q386 521 361 523T233 526L119 527Q96 535 96 557Q96 578 116 585Q121 587 229 587Q238 587 257 587T288 588Q366 588 435 568T568 488Q670 388 670 251Q670 155 621 78T499 -39T345 -85Q336 -86 225 -86L119 -85Q96 -77 96 -55Q96 -38 119 -25H233Q356 -24 371 -21Q373 -21 393 -16Q468 3 523 55T599 177Q607 206 607 218Q607 220 363 220L119 221Q96 229 96 251'],

    // MINUS SIGN
    0x2212: [281,-221,894,96,797,'119 221Q96 230 96 251T116 279Q121 281 448 281H775Q776 280 779 278T785 274T791 269T795 262T797 251Q797 230 775 221H119'],

    // MINUS-OR-PLUS SIGN
    0x2213: [537,227,894,64,829,'64 155Q64 172 87 185H416V476H251L87 477Q64 485 64 507Q64 528 84 535Q89 537 448 537H807Q808 536 811 534T817 530T823 525T827 518T829 507Q829 486 807 477L642 476H477V185H807Q808 184 811 182T817 178T823 173T827 166T829 155Q829 134 807 125L642 124H477V-39Q477 -203 475 -208Q466 -227 446 -227Q427 -227 417 -205L416 -41V124H251L87 125Q64 133 64 155'],

    // DIVISION SLASH
    0x2215: [750,250,575,64,510,'451 730Q460 750 479 750Q492 750 501 740T510 718Q508 708 318 244L122 -232Q112 -250 95 -250Q82 -250 73 -241T64 -218Q66 -205 258 261T451 730'],

    // SET MINUS
    0x2216: [750,250,575,63,511,'64 718Q63 731 72 740T94 750Q106 750 113 743Q118 741 122 732L318 256Q508 -208 510 -218Q511 -231 502 -240T480 -250Q460 -250 451 -230Q451 -229 259 238T64 718'],

    // ASTERISK OPERATOR
    0x2217: [473,-28,575,72,502,'236 431Q237 447 251 459T287 472T323 459T338 431Q338 423 328 363L317 300Q318 300 340 317T392 356T435 387Q442 390 450 390Q470 390 485 374T501 335Q501 326 500 320T494 309T486 300T473 293T458 287T438 280T414 272L353 250L414 228Q422 225 436 221T457 214T472 208T485 201T493 192T499 181T501 166Q501 141 484 126T450 111Q447 111 445 111T441 111T437 112T433 114T428 117T422 121T414 127T404 135T391 145T374 158L317 200L328 137Q338 77 338 69Q336 52 321 40T287 28T253 40T236 69Q236 77 246 137L257 200Q256 200 234 183T182 144T139 113Q132 110 124 110Q104 110 89 126T73 165Q73 174 74 180T80 191T88 200T101 207T116 213T136 220T160 228L221 250L160 272Q152 275 138 279T117 286T102 292T89 299T81 308T75 319T73 334Q73 359 90 374T124 389Q127 389 129 389T133 389T137 388T141 386T146 383T152 379T160 373T170 365T183 355T200 342L257 300L246 363Q236 423 236 431'],

    // RING OPERATOR
    0x2218: [475,-27,575,64,510,'64 251Q64 303 80 344T121 409T175 448T230 469T275 474Q277 474 283 474T292 473Q385 473 447 415T510 251Q510 149 449 89T287 28T126 88T64 251ZM448 251Q448 325 405 369T286 413Q215 413 171 371T126 251Q126 177 168 133T287 89Q361 89 404 132T448 251'],

    // BULLET OPERATOR
    0x2219: [475,-27,575,64,510,'64 251Q64 303 80 344T121 409T175 448T230 469T275 474Q277 474 283 474T292 473Q385 473 447 415T510 251Q510 149 449 89T287 28T126 88T64 251'],

    // SQUARE ROOT
    0x221A: [820,180,958,78,988,'107 178Q100 178 89 188T78 207Q78 216 84 220Q85 221 124 248T207 304T260 338Q269 340 275 335Q276 334 370 156L463 -20L698 393Q928 800 935 811Q944 820 954 820Q972 820 980 811T988 789Q988 781 858 553Q776 409 718 306Q452 -166 447 -171Q439 -179 422 -180Q405 -180 400 -175Q399 -174 346 -73T241 128T187 229L151 205Q111 178 107 178'],

    // PROPORTIONAL TO
    0x221D: [451,8,894,65,830,'65 222Q65 282 88 329T144 401T208 438T261 451H273Q312 451 320 450Q456 431 526 330L537 316Q638 451 778 451Q813 451 830 445V388Q821 391 799 391Q758 391 721 377T660 342T618 301T592 266L584 251Q648 152 697 114Q748 74 804 74H806Q823 74 829 77Q830 77 830 38V-1L820 -3Q801 -7 786 -7H771Q699 -7 632 25T527 114L516 128Q414 -8 276 -8Q192 -8 129 56T65 222ZM256 53Q296 53 332 67T392 102T434 143T461 178L469 193Q405 292 356 330Q308 369 251 369H243Q196 369 156 328T116 221Q116 191 124 161T158 99T225 55Q234 53 256 53'],

    // INFINITY
    0x221E: [452,8,1150,65,1084,'65 219Q65 318 132 385T302 452Q473 452 573 331L589 312L596 320Q710 452 857 452Q948 452 1016 386T1084 225Q1084 125 1017 59T848 -8Q679 -8 576 113L560 132L553 124Q439 -8 292 -8Q200 -8 133 58T65 219ZM1033 224Q1033 291 987 340T875 389Q748 389 648 261Q641 253 642 251Q717 163 748 137Q813 81 880 81Q941 81 987 120T1033 224ZM275 56Q315 56 353 70T418 104T466 144T497 178L507 192Q507 193 474 230T441 269Q355 362 267 362Q210 362 163 324T116 221Q116 150 162 103T275 56'],

    // ANGLE
    0x2220: [714,0,722,55,676,'71 0L68 2Q65 3 63 5T58 11T55 20Q55 21 56 23V25Q55 27 55 30Q55 31 56 33V35Q55 37 55 40Q55 42 57 48Q67 63 346 381Q421 467 518 578Q607 680 623 697T647 714Q656 714 661 708T666 694V692Q676 687 676 674Q676 668 673 663Q672 662 637 622T534 503T400 350L147 61L386 60H653Q666 50 666 40V38Q676 31 676 20Q676 8 661 0H71'],

    // DIVIDES
    0x2223: [750,249,319,129,190,'160 -249Q138 -249 129 -225V250Q129 725 131 729Q139 750 159 750T190 725V-225Q181 -249 160 -249'],

    // PARALLEL TO
    0x2225: [751,248,575,145,430,'205 -225Q201 -234 199 -237T191 -244T175 -248T161 -246Q151 -240 146 -229Q145 -224 145 251Q145 725 146 730Q156 750 176 750Q193 748 205 727V-225ZM369 727L372 732Q375 737 377 740T385 747T398 750Q406 750 413 747Q423 740 428 730Q430 720 430 251Q430 -219 428 -229Q423 -240 413 -246Q408 -248 400 -248Q393 -248 388 -247T379 -242T375 -236T371 -230L369 -225V727'],

    // LOGICAL AND
    0x2227: [604,17,767,64,702,'95 -16Q78 -16 71 -6T64 14Q64 20 65 22L212 308Q359 593 361 595Q370 604 385 604Q398 602 405 595Q407 593 554 308L701 22Q702 20 702 15Q702 1 693 -8T671 -17Q661 -17 651 -9Q647 -5 515 251L383 506L251 251Q119 -5 116 -8Q108 -16 95 -16'],

    // LOGICAL OR
    0x2228: [605,16,767,64,702,'64 572Q64 585 72 594T94 604T116 595Q119 592 251 336L383 81L515 336Q647 592 651 596Q661 604 671 604Q684 604 693 595T702 572Q702 567 701 565L554 279Q407 -6 405 -8Q404 -9 401 -11T397 -14Q392 -16 383 -16H380Q369 -16 361 -8Q359 -6 212 279L65 565Q65 566 65 568T64 572'],

    // stix-intersection, serifs
    0x2229: [603,16,767,64,702,'94 -16Q73 -16 64 8V209Q64 239 64 287Q65 418 69 432Q70 434 70 435Q84 487 125 523T216 575T299 597T354 603H372Q444 603 501 590T591 558T648 515T681 471T696 435Q696 434 697 432Q701 417 702 309Q702 303 702 287Q702 239 702 209V8Q693 -16 672 -16Q650 -16 643 3Q641 8 641 201Q641 397 640 403Q631 472 558 507T383 542Q339 542 298 535T219 511T156 468T126 403Q125 397 125 201Q125 8 123 3Q116 -16 94 -16'],

    // stix-union, serifs
    0x222A: [604,16,767,64,702,'672 603Q693 603 702 579V378Q702 348 702 300Q701 169 697 155Q696 153 696 152Q676 78 593 31T383 -16Q265 -16 179 28T70 152Q70 153 69 155Q65 170 64 278Q64 285 64 300Q64 348 64 378Q64 579 65 583Q74 604 94 604T123 584Q125 579 125 386Q125 190 126 184Q135 115 210 80T383 44Q426 44 467 51T546 75T609 119T640 184Q641 190 641 386Q641 579 643 584Q650 603 672 603'],

    // INTEGRAL
    0x222B: [711,211,569,64,632,'204 -71Q204 -108 181 -124T137 -141Q132 -141 132 -142Q142 -161 154 -161Q164 -161 186 -152Q200 -145 210 -135T228 -107T241 -77T249 -38T254 -2T258 38T262 74Q282 265 334 489Q334 490 337 503T341 523T347 544T355 569T365 594T379 620T397 643T420 666T447 685T481 700Q511 711 539 711T587 696T616 656T628 612T632 573Q632 536 610 519T562 501Q534 501 513 519T492 571Q492 608 515 624T559 641Q564 641 564 642Q554 661 542 661Q532 661 510 652Q496 645 486 635T468 607T455 577T447 538T442 502T438 462T434 426Q414 235 362 11Q352 -35 347 -54T328 -101T291 -152Q235 -208 162 -211Q147 -211 136 -208T109 -196T83 -165T67 -108Q64 -94 64 -73Q64 -37 86 -19T134 -1Q162 -1 183 -19T204 -71'],

    // TILDE OPERATOR
    0x223C: [392,-109,894,64,828,'64 155Q64 210 84 262T150 353T257 391Q300 391 341 371T417 321T484 264T557 215T637 194Q702 194 745 244T788 367Q796 391 808 391Q815 391 821 381T828 353V342Q828 252 776 181T637 109Q594 109 552 129T476 179T409 236T336 285T256 306Q193 306 149 258T105 132Q98 109 86 109Q76 109 70 122T64 155'],

    // WREATH PRODUCT
    0x2240: [583,82,319,64,254,'64 561Q64 570 76 576T108 583Q174 583 214 535T254 407Q254 368 238 324T202 248T166 173T149 92Q149 43 169 2T217 -39Q231 -40 242 -46T254 -60Q254 -69 241 -75T210 -82Q145 -82 105 -34T64 93Q64 133 80 177T116 253T152 328T169 408Q169 461 148 500T105 540Q92 540 78 545T64 561'],

    // ASYMPTOTICALLY EQUAL TO
    0x2243: [502,3,894,64,829,'64 295Q64 378 117 440T257 502Q298 502 339 485T416 443T486 394T560 352T637 335Q693 335 740 373T788 478Q796 502 808 502Q815 502 821 492T828 465V455Q828 365 771 308T640 250Q603 250 562 265T501 294T439 336L370 382Q308 417 256 417Q205 417 164 388T110 317Q110 316 109 304T107 286T103 270T97 255T86 250Q76 250 70 263T64 295ZM64 6T64 27T87 56H93Q99 56 110 56T137 56T173 56T217 56T267 57T323 57T383 57T448 57H807Q808 56 811 54T815 52T819 49T823 45T826 40T828 34T829 27Q829 7 807 -3H87Q64 6 64 27'],

    // APPROXIMATELY EQUAL TO
    0x2245: [639,27,1000,64,829,'64 402Q64 457 84 509T150 600T257 638Q300 638 341 618T417 569T484 511T557 462T637 441Q702 441 745 491T788 614Q796 638 808 638Q815 638 821 628T828 600V589Q828 499 776 428T637 356Q594 356 552 376T476 425T409 483T336 532T256 553Q193 553 149 505T105 379Q98 356 86 356Q76 356 70 369T64 402ZM87 197Q64 207 64 226Q64 247 84 255Q89 257 448 257H807Q808 256 811 254T817 250T823 245T827 238T829 227Q829 209 807 197H87ZM87 -27Q64 -18 64 3Q64 23 86 32Q89 33 448 33H807L812 30Q816 27 818 26T823 21T827 13T829 3Q829 -18 807 -27H87'],

    // ALMOST EQUAL TO
    0x2248: [524,-31,894,64,829,'64 345Q64 423 119 473T250 524Q301 524 356 503T451 455T542 407T636 385Q700 385 743 417T786 481Q786 493 791 508T807 524Q817 524 823 512T829 479Q829 404 776 352T638 300Q590 300 537 321T443 369T352 417T256 439Q207 439 166 417T110 359Q109 357 107 341T100 312T85 300Q77 300 71 313T64 345ZM64 77Q64 155 119 205T250 256Q302 256 357 235T451 187T541 139T636 117Q699 117 742 148T786 213Q786 231 792 243T808 256T823 242T829 208Q829 134 776 83T640 32Q591 32 537 53T443 101T352 149T256 171Q206 171 165 148T110 91Q109 89 107 73T100 44T85 32Q77 32 71 45T64 77'],

    // EQUIVALENT TO
    0x224D: [533,32,894,64,830,'798 533Q812 533 820 524T829 502T819 480T769 440Q655 355 537 330Q492 322 447 322Q401 322 356 330Q289 344 219 381T118 443T73 481Q64 490 64 503Q64 517 72 525T94 533Q99 533 102 532Q107 531 138 507T209 456T314 405T446 382Q604 382 765 515Q788 533 798 533ZM95 -32Q81 -32 73 -23T64 -1Q64 10 74 21T124 61Q213 127 293 153T421 179L422 180Q424 180 426 180T432 180T441 180T452 179Q612 179 769 61Q811 29 820 19T829 -1Q829 -14 821 -23T798 -32Q788 -32 765 -14Q608 118 446 118Q287 118 128 -14Q105 -32 95 -32'],

    // APPROACHES THE LIMIT
    0x2250: [721,-109,894,64,829,'87 333Q64 343 64 362Q64 383 84 391Q89 393 448 393H807Q808 392 811 390T817 386T823 381T827 374T829 363Q829 345 807 333H87ZM87 109Q64 118 64 139Q64 159 86 168Q89 169 448 169H807L812 166Q816 163 818 162T823 157T827 149T829 139Q829 118 807 109H87ZM362 635Q362 671 387 696T444 721Q488 721 510 693T533 635Q533 606 512 579T448 551Q406 551 384 577T362 635'],

    // stix-not (vert) equals
    0x2260: [711,210,894,64,829,'189 -210Q179 -210 170 -203T160 -179Q160 -171 162 -166Q165 -163 327 109H87Q64 118 64 139Q64 159 86 168Q89 169 363 169L461 333H87Q64 343 64 362Q64 383 84 391Q89 393 448 393H496Q533 455 583 539T656 660T679 698Q686 711 704 711Q714 711 723 704T733 681Q733 672 730 667Q729 664 709 631T645 523T567 393H807Q808 392 811 390T817 386T823 381T827 374T829 363Q829 345 807 333H532L433 169H807L812 166Q816 163 818 162T823 157T827 149T829 139Q829 118 807 109H398Q217 -195 211 -201Q202 -210 189 -210'],

    // IDENTICAL TO
    0x2261: [505,3,894,64,829,'87 445Q64 454 64 475Q64 497 84 503Q89 505 448 505H807Q808 504 812 502T818 497T823 492T827 484T829 474Q829 456 807 445H87ZM87 221Q64 230 64 251T84 279Q89 281 448 281H807Q808 280 811 278T817 274T823 269T827 262T829 251Q829 230 807 221H87ZM64 6T64 27T87 56H93Q99 56 110 56T137 56T173 56T217 56T267 57T323 57T383 57T448 57H807Q808 56 811 54T815 52T819 49T823 45T826 40T828 34T829 27Q829 7 807 -3H87Q64 6 64 27'],

    // LESS-THAN OR EQUAL TO
    0x2264: [697,199,894,96,797,'797 55Q797 45 790 35T767 25H759L434 180Q108 336 105 339Q96 348 96 360Q96 378 114 388Q126 394 439 544T757 695Q763 697 766 697Q780 697 788 688T797 666Q797 654 788 645Q784 641 507 509T197 361L466 232Q785 80 790 74Q797 66 797 55ZM119 -199Q96 -191 96 -169Q96 -160 102 -152T119 -140H124Q130 -140 140 -140T164 -140T197 -140T237 -140T283 -139T334 -139T389 -139T448 -139H775Q797 -153 797 -169Q797 -187 775 -199H119'],

    // GREATER-THAN OR EQUAL TO
    0x2265: [697,199,894,96,797,'127 25Q110 25 103 34T96 54Q96 66 105 75Q109 80 439 238L696 361Q113 637 105 645Q96 654 96 667Q96 679 104 688T128 697Q137 696 460 541T788 382Q797 373 797 360Q797 348 788 339Q785 336 459 180L135 25H127ZM119 -199Q96 -191 96 -169Q96 -160 102 -152T119 -140H124Q130 -140 140 -140T164 -140T197 -140T237 -140T283 -139T334 -139T389 -139T448 -139H775Q797 -153 797 -169Q797 -187 775 -199H119'],

    // MUCH LESS-THAN
    0x226A: [617,116,1150,64,1085,'734 -74T734 -86T727 -107T704 -116H702Q694 -116 584 -55Q473 7 380 58Q87 219 73 229Q64 238 64 250Q64 263 73 272Q87 282 380 443Q695 616 699 617H700Q718 617 726 607T734 588Q734 568 717 560Q705 554 435 404L157 250L439 94Q721 -61 726 -66Q734 -74 734 -86ZM1085 -74T1085 -86T1078 -107T1055 -116H1053Q1045 -116 935 -55Q824 7 731 58Q438 219 424 229Q415 238 415 250Q415 263 424 272Q438 282 731 443Q1046 616 1050 617H1051Q1069 617 1077 607T1085 588Q1085 568 1068 560Q1056 554 786 404L508 250L790 94Q1072 -61 1077 -66Q1085 -74 1085 -86'],

    // MUCH GREATER-THAN
    0x226B: [618,116,1150,64,1085,'64 588Q64 600 72 609T94 618H95Q103 618 209 559Q322 496 419 443Q712 282 725 272Q734 263 734 250Q734 238 725 229Q714 220 415 55T110 -113Q103 -116 95 -116Q78 -116 71 -106T64 -86Q64 -74 72 -66Q77 -61 359 94L641 250L363 404Q277 452 173 509Q95 552 82 560T66 576V577Q64 585 64 588ZM415 588Q415 600 423 609T445 618H446Q454 618 560 559Q673 496 770 443Q1063 282 1076 272Q1085 263 1085 250Q1085 238 1076 229Q1065 220 766 55T461 -113Q454 -116 446 -116Q429 -116 422 -106T415 -86Q415 -74 423 -66Q428 -61 710 94L992 250L714 404Q628 452 524 509Q446 552 433 560T417 576V577Q415 585 415 588'],

    // PRECEDES
    0x227A: [585,86,894,96,797,'797 -57Q797 -65 790 -75T766 -86Q748 -86 741 -74T733 -43T719 8T681 72Q647 112 588 141T475 185T343 207T230 216T136 219Q96 219 96 250Q96 280 132 280H136Q193 281 239 283T347 292T457 310T556 342T643 391T703 460T735 553Q741 585 763 585Q781 585 789 575T797 556Q797 540 792 513T758 434T682 345Q605 285 481 254L462 249Q483 246 526 233T633 185T733 104Q767 63 782 15T797 -57'],

    // SUCCEEDS
    0x227B: [586,86,894,96,797,'96 556Q96 568 104 577T126 586Q152 586 158 553Q164 503 188 462T247 394T331 345T429 313T539 294T649 284T758 280H760Q797 280 797 250Q797 219 760 219H758Q627 217 529 204T347 160T216 77T158 -54Q152 -86 126 -86Q110 -86 103 -76T96 -57Q96 -41 101 -14T135 65T211 154Q288 214 412 245L431 250Q410 252 367 265T259 314T160 395Q127 435 112 483T96 556'],

    // SUBSET OF
    0x2282: [588,85,894,96,798,'96 251Q96 389 191 482T417 586Q418 586 428 586T456 586T496 586T546 587T601 587H775Q776 586 779 584T785 580T791 575T795 568T797 557Q797 536 775 527L597 526Q411 525 395 522Q390 521 370 516Q285 494 222 424T158 251Q158 131 246 53Q313 -9 408 -23Q417 -24 597 -25H775Q776 -26 781 -29T788 -34T794 -43T797 -56Q797 -74 775 -85H493Q407 -85 376 -79Q257 -55 177 35T96 251'],

    // SUPERSET OF
    0x2283: [587,86,894,96,796,'96 -55Q96 -38 119 -25H296Q482 -24 498 -21Q503 -20 523 -15Q609 7 672 77T735 251T665 431T485 524Q476 525 296 526L119 527Q96 535 96 557Q96 578 116 585Q121 587 300 587Q451 586 476 585T522 579Q632 556 714 468T796 251Q796 112 695 13Q612 -65 497 -82Q473 -86 289 -86L119 -85Q96 -77 96 -55'],

    // SUBSET OF OR EQUAL TO
    0x2286: [698,199,894,96,798,'96 361Q96 499 191 592T417 696Q418 696 428 696T456 696T496 696T546 697T601 697H775Q776 696 779 694T785 690T791 685T795 678T797 667Q797 646 775 637L597 636Q411 635 395 632Q390 631 370 626Q285 604 222 534T158 361Q158 241 246 163Q313 101 408 87Q417 86 597 85H775Q776 84 781 81T788 76T794 67T797 54Q797 36 775 25H493Q407 25 376 31Q257 55 177 145T96 361ZM149 -199Q127 -191 127 -169T149 -140H154Q160 -140 169 -140T192 -140T224 -140T262 -140T306 -139T354 -139T407 -139T463 -139H775Q776 -140 779 -142T785 -146T791 -151T795 -158T797 -169Q797 -190 775 -199H149'],

    // SUPERSET OF OR EQUAL TO
    0x2287: [697,199,894,96,796,'96 55Q96 72 119 85H296Q482 86 498 89Q503 90 523 95Q609 117 672 187T735 361T665 541T485 634Q476 635 296 636L119 637Q96 645 96 667Q96 688 116 695Q121 697 300 697Q451 696 476 695T522 689Q632 666 714 578T796 361Q796 222 695 123Q612 45 497 28Q473 24 289 24L119 25Q96 33 96 55ZM119 -199Q96 -190 96 -169T116 -141Q121 -139 433 -139H745Q766 -152 766 -170Q766 -190 745 -199H119'],

    // MULTISET UNION
    0x228E: [604,16,767,64,702,'672 603Q693 603 702 579V378Q702 348 702 300Q701 169 697 155Q696 153 696 152Q676 78 593 31T383 -16Q265 -16 179 28T70 152Q70 153 69 155Q65 170 64 278Q64 285 64 300Q64 348 64 378Q64 579 65 583Q74 604 94 604T123 584Q125 579 125 386Q125 190 126 184Q135 115 210 80T383 44Q426 44 467 51T546 75T609 119T640 184Q641 190 641 386Q641 579 643 584Q650 603 672 603ZM353 412Q353 420 353 435T352 456Q352 483 358 495T385 507Q403 506 409 494T415 457Q415 451 415 436T414 411V341H558Q579 329 579 311Q579 289 558 281L486 280H414V136Q400 114 384 114Q363 114 354 136L353 208V280H281L209 281Q187 289 187 310Q187 328 209 341H353V412'],

    // SQUARE IMAGE OF OR EQUAL TO
    0x2291: [698,199,894,96,828,'127 25Q111 29 104 49V362L105 675Q114 693 127 696H132Q138 696 149 696T174 696T208 696T249 696T297 697T350 697T407 697T468 697H806Q828 683 828 666Q828 646 806 637L485 636H165V85H805Q806 84 809 82T813 80T817 77T821 73T824 68T826 62T827 55Q827 34 806 25H127ZM96 -190T96 -169T119 -140H125Q131 -140 141 -140T167 -140T201 -140T242 -140T290 -139T344 -139T402 -139T463 -139H805Q806 -140 809 -142T813 -144T817 -147T821 -151T824 -156T826 -162T827 -169Q827 -190 806 -199H119Q96 -190 96 -169'],

    // SQUARE ORIGINAL OF OR EQUAL TO
    0x2292: [698,199,894,66,797,'66 55Q66 74 89 85H728V636H408L88 637Q66 645 66 667T88 696H94Q99 696 110 696T135 696T169 696T210 696T258 697T311 697T368 697T429 697H767Q786 684 789 672V49Q782 31 767 25H88Q66 32 66 55ZM88 -199Q66 -191 66 -169Q66 -148 87 -140Q91 -139 433 -139H775Q776 -140 779 -142T783 -144T787 -147T791 -151T794 -156T796 -162T797 -169Q797 -189 775 -199H88'],

    // stix-square intersection, serifs
    0x2293: [604,-1,767,70,696,'131 25Q121 1 100 1Q81 1 71 23L70 301Q70 579 72 583Q77 598 90 602Q95 604 385 604H674Q693 591 696 579V25Q686 1 665 1Q646 1 636 23L635 283V543H131V25'],

    // stix-square union, serifs
    0x2294: [604,-1,767,70,696,'696 25Q689 7 674 1H93Q77 7 71 23L70 301Q70 579 72 583Q80 604 100 604T131 579V61H635V579Q644 603 666 603Q687 603 696 579V25'],

    // stix-circled plus (with rim)
    0x2295: [632,132,894,64,828,'64 250Q64 350 98 426T189 546T307 610T434 632Q485 632 496 631Q572 621 635 592Q669 575 699 550T760 484T809 384T828 250Q828 77 725 -27T446 -132Q272 -132 168 -27T64 250ZM416 282V570H414Q341 564 285 535T202 475T156 397T134 332T128 287Q127 283 127 282H416ZM765 288Q760 344 743 389T700 462T647 512T589 543T538 560T499 568L483 570H478V282H766L765 288ZM416 -69V220H127Q130 195 131 189T138 155T150 115T168 76T196 35T234 0T286 -35Q337 -61 410 -69H416ZM483 -69Q554 -60 607 -33T687 21T733 93T756 156T764 209Q766 217 766 220H478V-69H483'],

    // CIRCLED MINUS
    0x2296: [632,132,894,64,828,'64 250Q64 350 98 426T189 546T307 610T434 632Q485 632 496 631Q572 621 635 592Q669 575 699 550T760 484T809 384T828 250Q828 77 725 -27T446 -132Q272 -132 168 -27T64 250ZM765 288Q753 424 666 497T446 571T227 498T128 288L127 282H766L765 288ZM446 -70Q578 -70 666 4T765 213L766 220H127Q130 195 131 189T138 155T150 115T168 76T196 35T234 0T286 -35Q353 -70 446 -70'],

    // stix-circled times (with rim)
    0x2297: [632,132,894,64,828,'64 250Q64 350 98 426T189 546T307 610T434 632Q485 632 496 631Q572 621 635 592Q669 575 699 550T760 484T809 384T828 250Q828 77 725 -27T446 -132Q272 -132 168 -27T64 250ZM647 512Q567 571 447 571Q340 571 262 523Q237 507 237 505L342 399L447 295L657 505L647 512ZM298 356L192 461Q180 445 161 411Q126 341 126 251Q126 128 192 40L403 250L298 356ZM701 41Q704 41 719 63T750 138T767 250Q767 310 750 362T719 437T701 460L491 250L701 41ZM238 -5Q238 -8 261 -22T336 -53T447 -70Q567 -70 647 -11L657 -4L447 206L342 101Q238 -1 238 -5'],

    // CIRCLED DIVISION SLASH
    0x2298: [632,132,894,64,828,'64 250Q64 350 98 426T189 546T307 610T434 632Q485 632 496 631Q572 621 635 592Q669 575 699 550T760 484T809 384T828 250Q828 77 725 -27T446 -132Q272 -132 168 -27T64 250ZM657 505Q656 506 650 510T638 518T623 527T604 537T581 547T553 556T522 563T486 569T446 571Q305 571 216 487T126 251Q126 128 192 40L657 505ZM447 -70Q591 -70 679 16T767 250Q767 308 751 360T719 436T701 460L469 228Q238 -1 238 -5Q238 -8 261 -22T336 -53T447 -70'],

    // CIRCLED DOT OPERATOR
    0x2299: [632,132,894,64,828,'64 250Q64 350 98 426T189 546T307 610T434 632Q485 632 496 631Q572 621 635 592Q669 575 699 550T760 484T809 384T828 250Q828 77 725 -27T446 -132Q272 -132 168 -27T64 250ZM767 252Q767 395 681 483T446 571Q303 571 215 486T126 249Q126 107 212 19T446 -70Q596 -70 681 18T767 252ZM335 251Q335 297 368 329T441 361Q498 361 527 327T557 250Q557 202 525 171T446 140Q397 140 366 173T335 251'],

    // RIGHT TACK
    0x22A2: [693,-1,703,65,637,'65 672Q76 693 91 693Q115 693 123 674Q125 669 125 523V378H615Q618 376 622 373T628 369T632 366T635 362T636 356T637 347Q637 328 619 319Q615 317 370 317H125V171Q125 25 123 20Q114 1 94 1Q73 1 65 23V672'],

    // LEFT TACK
    0x22A3: [693,-1,703,64,638,'64 327T64 347T89 378H577V525L578 672Q592 693 604 693Q629 693 638 669V25Q628 1 607 1Q588 1 578 23L577 170V317H88Q64 327 64 347'],

    // DOWN TACK
    0x22A4: [695,-1,894,64,829,'64 664Q64 675 71 683T87 693H93Q99 693 110 693T137 693T173 693T217 694T267 694T323 694T383 694T448 694H807Q808 693 811 691T817 687T823 682T827 675T829 664Q829 643 807 634L642 633H477V25Q467 1 446 1Q427 1 417 23L416 328V633H251L87 634Q64 643 64 664'],

    // UP TACK
    0x22A5: [693,-1,894,65,829,'65 31Q65 38 66 41T71 50T87 61H416V366L417 672Q431 693 443 693Q468 693 477 669V61H807Q808 60 811 58T817 54T823 49T827 42T829 31Q829 10 807 1H87Q65 10 65 31'],

    // TRUE
    0x22A8: [750,249,974,129,918,'160 -249Q138 -249 129 -225V250Q129 725 131 729Q139 750 159 750T190 725V392Q219 393 537 393H896Q897 392 900 390T906 386T912 381T916 374T918 363Q918 345 896 333H190V169H896L900 166Q905 163 907 162T912 157T916 149T918 139Q918 118 896 109H190V-225Q181 -249 160 -249'],

    // DIAMOND OPERATOR
    0x22C4: [523,21,575,15,560,'280 522Q281 523 285 523H289Q301 523 366 457Q404 420 431 393Q533 291 546 277T560 250Q560 239 548 226T431 108Q313 -10 304 -16Q297 -21 287 -21Q278 -21 275 -19Q270 -17 146 107T18 238Q15 242 15 251Q15 258 18 263Q20 268 145 392T274 519L280 522ZM388 350L288 449L188 350L89 250L288 52L487 250L388 350'],

    // DOT OPERATOR
    0x22C5: [336,-165,319,74,245,'74 251Q74 286 99 311T156 336Q200 336 222 308T245 250Q245 221 224 194T160 166T96 193T74 251'],

    // STAR OPERATOR
    0x22C6: [502,0,575,24,550,'270 491Q274 502 287 502Q298 502 304 491Q304 486 323 396T342 303L438 314Q520 324 534 324Q540 324 545 320T550 307Q550 298 539 290T456 243Q377 198 377 197L416 111Q456 26 456 22Q457 21 457 18Q457 11 451 6T438 0H437Q432 0 415 16Q387 42 358 68L287 133L216 68Q193 47 167 23Q142 0 136 0Q129 0 123 5T117 18Q117 21 118 22Q118 26 158 111L197 197Q197 198 156 221T72 269T26 298Q24 304 24 307Q24 315 29 319T40 324Q53 324 136 314L232 303Q232 306 251 396T270 491'],

    // BOWTIE
    0x22C8: [540,39,1000,33,967,'906 251Q906 456 905 456Q550 252 549 251Q549 250 726 148T905 45T906 251ZM967 -14Q958 -38 939 -38H937Q928 -38 923 -35Q919 -34 748 64T500 209L71 -38Q69 -39 63 -39Q42 -39 33 -16V518Q45 540 63 540H65Q72 540 174 481Q247 439 302 407L500 292Q578 339 750 438T929 539H933Q958 539 967 515V-14ZM449 251L94 456Q93 456 93 251Q93 45 94 45L106 52Q119 59 139 71T186 98T242 131T301 165T357 197T404 225T437 244L449 251'],

    // VERTICAL ELLIPSIS
    0x22EE: [951,29,319,74,245,'74 55Q74 91 99 116T156 141Q200 141 222 113T245 55Q245 26 224 -1T160 -29Q118 -29 96 -3T74 55ZM74 465Q74 501 99 526T156 551Q200 551 222 523T245 465Q245 436 224 409T160 381Q118 381 96 407T74 465ZM74 865Q74 901 99 926T156 951Q200 951 222 923T245 865Q245 836 224 809T160 781Q118 781 96 807T74 865'],

    // MIDLINE HORIZONTAL ELLIPSIS
    0x22EF: [336,-165,1295,74,1221,'74 251Q74 286 99 311T156 336Q200 336 222 308T245 250Q245 221 224 194T160 166T96 193T74 251ZM562 251Q562 286 587 311T644 336Q688 336 710 308T733 250Q733 221 712 194T648 166T584 193T562 251ZM1050 251Q1050 286 1075 311T1132 336Q1176 336 1198 308T1221 250Q1221 221 1200 194T1136 166T1072 193T1050 251'],

    // DOWN RIGHT DIAGONAL ELLIPSIS
    0x22F1: [871,-101,1323,129,1194,'129 785Q129 821 154 846T211 871Q255 871 277 843T300 785Q300 756 279 729T215 701Q173 701 151 727T129 785ZM576 485Q576 521 601 546T658 571Q702 571 724 543T747 485Q747 456 726 429T662 401Q620 401 598 427T576 485ZM1023 185Q1023 221 1048 246T1105 271Q1149 271 1171 243T1194 185Q1194 156 1173 129T1109 101Q1067 101 1045 127T1023 185']
  }
);

MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Bold/MathOperators.js");
