/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ca extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Hora del meridià de Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Hora estàndard d’Apia",
               "",
               "Hora d’estiu d’Apia",
               "",
               "Hora d’Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Hora estàndard de les illes Cook",
               "",
               "Hora de mig estiu de les illes Cook",
               "",
               "Hora de les illes Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Hora estàndard de Cuba",
               "CST",
               "Hora d’estiu de Cuba",
               "CDT",
               "Hora de Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Hora estàndard de Fiji",
               "",
               "Hora d’estiu de Fiji",
               "",
               "Hora de Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Hora estàndard del Golf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hora estàndard de Khovd",
               "",
               "Hora d’estiu de Khovd",
               "",
               "Hora de Khovd",
               "",
            };
        final String[] Iran = new String[] {
               "Hora estàndard de l’Iran",
               "",
               "Hora d’estiu de l’Iran",
               "",
               "Hora de l’Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Hora de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Hora estàndard d’Omsk",
               "",
               "Hora d’estiu d’Omsk",
               "",
               "Hora d’Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Hora estàndard del Perú",
               "",
               "Hora d’estiu del Perú",
               "",
               "Hora del Perú",
               "",
            };
        final String[] Truk = new String[] {
               "Hora de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Hora de les illes Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Hora estàndard de Xile",
               "",
               "Hora d’estiu de Xile",
               "",
               "Hora de Xile",
               "",
            };
        final String[] China = new String[] {
               "Hora estàndard de la Xina",
               "CST",
               "Hora d’estiu de la Xina",
               "CDT",
               "Hora de la Xina",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Hora de les illes Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Hora de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Hora de l’Índia",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Hora estàndard del Japó",
               "JST",
               "Hora d’estiu del Japó",
               "JDT",
               "Hora del Japó",
               "JT",
            };
        final String[] Korea = new String[] {
               "Hora estàndard de Corea",
               "KST",
               "Hora d’estiu de Corea",
               "KST",
               "Hora de Corea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Hora de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Hora del Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Hora de Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Hora estàndard de Samoa",
               "SST",
               "Hora d’estiu de Samoa",
               "SST",
               "Hora de Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Hora de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Hora estàndard de Tonga",
               "",
               "Hora d’estiu de Tonga",
               "",
               "Hora de Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Hora de Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Hora estàndard d’Alaska",
               "AKST",
               "Hora d’estiu d’Alaska",
               "AKDT",
               "Hora d’Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Hora estàndard de l’Amazones",
               "",
               "Hora d’estiu de l’Amazones",
               "",
               "Hora de l’Amazones",
               "",
            };
        final String[] Anadyr = new String[] {
               "Hora estàndard d’Anadyr",
               "",
               "Horari d’estiu d’Anadyr",
               "",
               "Hora d’Anàdir",
               "",
            };
        final String[] Azores = new String[] {
               "Hora estàndard de les Açores",
               "",
               "Hora d’estiu de les Açores",
               "",
               "Hora de les Açores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Hora de Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Hora de Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Hora estàndard de l’illa de Pasqua",
               "",
               "Hora d’estiu de l’illa de Pasqua",
               "",
               "Hora de l’illa de Pasqua",
               "",
            };
        final String[] Guyana = new String[] {
               "Hora de Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Hora estàndard d’Israel",
               "IST",
               "Hora d’estiu d’Israel",
               "IDT",
               "Hora d’Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Hora de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Hora de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Hora estàndard de Moscou",
               "MSK",
               "Hora d’estiu de Moscou",
               "MSK",
               "Hora de Moscou",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Hora de Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Hora estàndard de Samara",
               "",
               "Hora d’estiu de Samara",
               "",
               "Hora de Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Hora de Tahití",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Hora estàndard de Taipei",
               "CST",
               "Hora d’estiu de Taipei",
               "CDT",
               "Hora de Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Hora de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Hora de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Hora de Wallis i Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Hora estàndard àrab",
               "",
               "Hora d’estiu àrab",
               "",
               "Hora àrab",
               "",
            };
        final String[] Armenia = new String[] {
               "Hora estàndard d’Armènia",
               "",
               "Hora d’estiu d’Armènia",
               "",
               "Hora d’Armènia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Hora de Bolívia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Hora estàndard de Chatham",
               "",
               "Hora d’estiu de Chatham",
               "",
               "Hora de Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Temps universal coordinat",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Hora de l’Equador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Hora de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Hora estàndard de Geòrgia",
               "",
               "Hora d’estiu de Geòrgia",
               "",
               "Hora de Geòrgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Hora estàndard d’Irkutsk",
               "",
               "Hora d’estiu d’Irkutsk",
               "",
               "Hora d’Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Hora estàndard de Magadan",
               "",
               "Hora d’estiu de Magadan",
               "",
               "Hora de Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Hora de Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Hora estàndard de l’illa Norfolk",
               "",
               "Hora d’estiu de l’illa Norfolk",
               "",
               "Hora de l’illa Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Hora estàndard de Fernando de Noronha",
               "",
               "Hora d’estiu de Fernando de Noronha",
               "",
               "Hora de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Hora de Reunió",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Hora de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Hora de les illes Salomó",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Hora de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Hora estàndard de l’Uruguai",
               "",
               "Hora d’estiu de l’Uruguai",
               "",
               "Hora de l’Uruguai",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Hora estàndard de Vanatu",
               "",
               "Hora d’estiu de Vanatu",
               "",
               "Hora de Vanatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Hora estàndard de Iakutsk",
               "",
               "Hora d’estiu de Iakutsk",
               "",
               "Hora de Iakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Hora estàndard de l’Atlàntic",
               "AST",
               "Hora d’estiu de l’Atlàntic",
               "AST",
               "Hora de l’Atlàntic",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Hora estàndard de Brasília",
               "",
               "Hora d’estiu de Brasília",
               "",
               "Hora de Brasília",
               "",
            };
        final String[] Chamorro = new String[] {
               "Hora estàndard de Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Hora estàndard de Colòmbia",
               "",
               "Hora d’estiu de Colòmbia",
               "",
               "Hora de Colòmbia",
               "",
            };
        final String[] Falkland = new String[] {
               "Hora estàndard de les illes Malvines",
               "",
               "Hora d’estiu de les illes Malvines",
               "",
               "Hora de les illes Malvines",
               "",
            };
        final String[] Malaysia = new String[] {
               "Hora de Malàisia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Hora de les Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Hora estàndard d’Ulaanbaatar",
               "",
               "Hora d’estiu d’Ulaanbaatar",
               "",
               "Hora d’Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Hora estàndard del Pakistan",
               "PKT",
               "Hora d’estiu del Pakistan",
               "PKST",
               "Hora del Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Hora estàndard del Paraguai",
               "",
               "Hora d’estiu del Paraguai",
               "",
               "Hora del Paraguai",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Hora de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Hora estàndard de Sakhalín",
               "",
               "Hora d’estiu de Sakhalín",
               "",
               "Hora de Sakhalín",
               "",
            };
        final String[] Suriname = new String[] {
               "Hora de Surinam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Hora estàndard de l’Argentina",
               "",
               "Hora d’estiu de l’Argentina",
               "",
               "Hora de l’Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Hora de Kiritimati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Hora de Galápagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hora estàndard de Hong Kong",
               "HKT",
               "Hora d’estiu de Hong Kong",
               "HKST",
               "Hora de Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Hora de l’Indoxina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Hora estàndard de Petropavlovsk de Kamtxatka",
               "",
               "Horari d’estiu de Petropavlovsk de Kamtxatka",
               "",
               "Hora de Kamtxatka",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Hora del Kirguizstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Hora estàndard de Lord Howe",
               "",
               "Horari d’estiu de Lord Howe",
               "",
               "Hora de Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Hora de les Marqueses",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Hora estàndard de Maurici",
               "",
               "Hora d’estiu de Maurici",
               "",
               "Hora de Maurici",
               "",
            };
        final String[] Singapore = new String[] {
               "Hora de Singapur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Hora de Veneçuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Hora estàndard de Volgograd",
               "MSK",
               "Hora d’estiu de Volgograd",
               "MSK",
               "Hora de Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Hora estàndard de l’Azerbaidjan",
               "",
               "Hora d’estiu de l’Azerbaidjan",
               "",
               "Hora de l’Azerbaidjan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Hora estàndard de Bangladesh",
               "",
               "Hora d’estiu de Bangladesh",
               "",
               "Hora de Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Hora estàndard de Cap Verd",
               "",
               "Hora d’estiu de Cap Verd",
               "",
               "Hora de Cap Verd",
               "",
            };
        final String[] East_Timor = new String[] {
               "Hora de Timor Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Hora del Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Hora de les Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Hora del Tadjikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Hora estàndard de l’Uzbekistan",
               "",
               "Hora d’estiu de l’Uzbekistan",
               "",
               "Hora de l’Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Hora de l’Afganistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hora estàndard de Krasnoiarsk",
               "",
               "Hora d’estiu de Krasnoiarsk",
               "",
               "Hora de Krasnoiarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Hora estàndard de Nova Zelanda",
               "NZST",
               "Hora d’estiu de Nova Zelanda",
               "NZDT",
               "Hora de Nova Zelanda",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Hora estàndard de Novossibirsk",
               "",
               "Hora d’estiu de Novossibirsk",
               "",
               "Hora de Novossibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Hora estàndard de les Filipines",
               "PST",
               "Hora d’estiu de les Filipines",
               "PDT",
               "Hora de les Filipines",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Hora estàndard de Vladivostok",
               "",
               "Hora d’estiu de Vladivostok",
               "",
               "Hora de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Hora de l’oceà Índic",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Hora de les illes Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Hora estàndard de Terranova",
               "NST",
               "Hora d’estiu de Terranova",
               "NDT",
               "Hora de Terranova",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Hora estàndard del Turkmenistan",
               "",
               "Hora d’estiu del Turkmenistan",
               "",
               "Hora del Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Hora de la Guaiana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Hora estàndard de Nova Caledònia",
               "",
               "Hora d’estiu de Nova Caledònia",
               "",
               "Hora de Nova Caledònia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Hora de Geòrgia del Sud",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Hora estàndard de Iekaterinburg",
               "",
               "Hora d’estiu de Iekaterinburg",
               "",
               "Hora de Iekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Hora de l’Àfrica central",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Hora de l’Àfrica oriental",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Hora estàndard de l’Àfrica occidental",
               "WAT",
               "Hora d’estiu de l’Àfrica occidental",
               "WAT",
               "Hora de l’Àfrica occidental",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Hora de Dumont d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Hora estàndard d’Europa central",
               "CET",
               "Hora d’estiu d’Europa central",
               "CEST",
               "Hora d’Europa central",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Hora estàndard d’Europa oriental",
               "EET",
               "Hora d’estiu d’Europa oriental",
               "EEST",
               "Hora d’Europa oriental",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Hora estàndard d’Europa occidental",
               "WET",
               "Hora d’estiu d’Europa occidental",
               "WEST",
               "Hora d’Europa occidental",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Hora estàndard del Pacífic de Mèxic",
               "MST",
               "Hora d’estiu del Pacífic de Mèxic",
               "MDT",
               "Hora del Pacífic de Mèxic",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Hora estàndard de l’Àfrica meridional",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Hora estàndard central d’Amèrica del Nord",
               "CST",
               "Hora d’estiu central d’Amèrica del Nord",
               "CDT",
               "Hora central d’Amèrica del Nord",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Hora estàndard oriental d’Amèrica del Nord",
               "EST",
               "Hora d’estiu oriental d’Amèrica del Nord",
               "EST",
               "Hora oriental d’Amèrica del Nord",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Hora estàndard del Pacífic d’Amèrica del Nord",
               "PST",
               "Hora d’estiu del Pacífic d’Amèrica del Nord",
               "PDT",
               "Hora del Pacífic d’Amèrica del Nord",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Hora d’Antàrtida i de les Terres Australs Antàrtiques Franceses",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Hora de les illes Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hora estàndard de Hawaii-Aleutianes",
               "HST",
               "Hora d’estiu de Hawaii-Aleutianes",
               "HST",
               "Hora de Hawaii-Aleutianes",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Hora de les illes Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hora estàndard de Saint-Pierre-et-Miquelon",
               "",
               "Hora d’estiu de Saint-Pierre-et-Miquelon",
               "",
               "Hora de Saint-Pierre-et-Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Hora estàndard de muntanya d’Amèrica del Nord",
               "MST",
               "Hora d’estiu de muntanya d’Amèrica del Nord",
               "MST",
               "Hora de muntanya d’Amèrica del Nord",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Hora de les illes Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Hora de Papua Nova Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Hora estàndard d’Austràlia central",
               "ACST",
               "Hora d’estiu d’Austràlia central",
               "ACDT",
               "Hora d’Austràlia central",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Hora estàndard d’Austràlia oriental",
               "AEST",
               "Hora d’estiu d’Austràlia oriental",
               "AEDT",
               "Hora d’Austràlia oriental",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Hora estàndard d’Austràlia occidental",
               "AWST",
               "Hora d’estiu d’Austràlia occidental",
               "AWDT",
               "Hora d’Austràlia occidental",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Hora central d’Indonèsia",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hora de l’est d’Indonèsia",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Hora de l’oest d’Indonèsia",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hora estàndard d’Austràlia centre-occidental",
               "",
               "Hora d’estiu d’Austràlia centre-occidental",
               "",
               "Hora d’Austràlia centre-occidental",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Hora del meridià de Greenwich",
                    "GMT",
                    "Hora d’estiu britànica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Temps universal coordinat",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Hora del meridià de Greenwich",
                    "GMT",
                    "Hora estàndard d’Irlanda",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Temps universal coordinat",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Temps universal coordinat",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Hora del meridià de Greenwich",
                    "GMT",
                    "Hora d’estiu britànica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Temps universal coordinat",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Temps universal coordinat",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Temps universal coordinat",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Hora del meridià de Greenwich",
                    "GMT",
                    "Hora estàndard d’Irlanda",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Hora del meridià de Greenwich",
                    "GMT",
                    "Hora d’estiu britànica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Hora del meridià de Greenwich",
                    "GMT",
                    "Hora d’estiu britànica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Hora del meridià de Greenwich",
                    "GMT",
                    "Hora d’estiu britànica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Hora del meridià de Greenwich",
                    "GMT",
                    "Hora d’estiu britànica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Hora del meridià de Greenwich",
                    "GMT",
                    "Hora d’estiu britànica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Baku", "Bakú" },
            { "timezone.excity.Asia/Hovd", "Khovd" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aqtaý" },
            { "timezone.excity.Asia/Chita", "Txità" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "timezone.excity.Asia/Seoul", "Seül" },
            { "timezone.excity.Asia/Tokyo", "Tòquio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Anadyr", "Anàdir" },
            { "timezone.excity.Asia/Aqtobe", "Aqtóbe" },
            { "timezone.excity.Asia/Atyrau", "Atyraý" },
            { "timezone.excity.Asia/Muscat", "Masqat" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Saigon", "Hồ Chí Minh" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "Ürümchi" },
            { "timezone.excity.Etc/Unknown", "Ciutat desconeguda" },
            { "timezone.excity.Europe/Kiev", "Kíiv" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Caire, el" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Barnaul", "Barnaül" },
            { "timezone.excity.Asia/Nicosia", "Nicòsia" },
            { "timezone.excity.Asia/Yakutsk", "Iakutsk" },
            { "timezone.excity.Europe/Kirov", "Kírov" },
            { "timezone.excity.Europe/Paris", "París" },
            { "timezone.excity.America/Belem", "Belém" },
            { "timezone.excity.Asia/Ashgabat", "Aşgabat" },
            { "timezone.excity.Asia/Calcutta", "Calcuta" },
            { "timezone.excity.Asia/Damascus", "Damasc" },
            { "timezone.excity.Asia/Dushanbe", "Duixanbé" },
            { "timezone.excity.Asia/Jayapura", "Jaipur" },
            { "timezone.excity.Asia/Katmandu", "Katmandú" },
            { "timezone.excity.Asia/Qostanay", "Qostanai" },
            { "timezone.excity.Asia/Sakhalin", "Sakhalín" },
            { "timezone.excity.Asia/Tashkent", "Taixkent" },
            { "timezone.excity.Asia/Ust-Nera", "Ust’-Nera" },
            { "timezone.excity.Europe/Athens", "Atenes" },
            { "timezone.excity.Europe/Berlin", "Berlín" },
            { "timezone.excity.Europe/Dublin", "Dublín" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/London", "Londres" },
            { "timezone.excity.Europe/Monaco", "Mònaco" },
            { "timezone.excity.Europe/Moscow", "Moscou" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Varsòvia" },
            { "timezone.excity.Europe/Zurich", "Zúric" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Alger" },
            { "timezone.excity.Africa/Tripoli", "Trípoli" },
            { "timezone.excity.America/Bogota", "Bogotà" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Cayman", "Caiman" },
            { "timezone.excity.America/Cuiaba", "Cuiabá" },
            { "timezone.excity.America/Maceio", "Maceió" },
            { "timezone.excity.America/Panama", "Panamà" },
            { "timezone.excity.Asia/Kamchatka", "Kamtxatka" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Europe/Saratov", "Saràtov" },
            { "timezone.excity.Europe/Vatican", "Vaticà" },
            { "timezone.excity.Europe/Vilnius", "Vílnius" },
            { "timezone.excity.Indian/Reunion", "Reunió" },
            { "timezone.excity.Pacific/Easter", "Illa de Pasqua" },
            { "timezone.excity.Pacific/Kanton", "Canton" },
            { "timezone.excity.Pacific/Noumea", "Nouméa" },
            { "timezone.excity.Pacific/Tahiti", "Tahití" },
            { "timezone.excity.Africa/El_Aaiun", "al-Aaiun" },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "timezone.excity.Africa/Monrovia", "Monròvia" },
            { "timezone.excity.Africa/Ndjamena", "N’Djamena" },
            { "timezone.excity.America/Cayenne", "Caiena" },
            { "timezone.excity.America/Cordoba", "Córdoba" },
            { "timezone.excity.Atlantic/Azores", "Açores" },
            { "timezone.excity.Atlantic/Canary", "Illes Canàries" },
            { "timezone.excity.Atlantic/Faeroe", "Illes Fèroe" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Brussel·les" },
            { "timezone.excity.Europe/Helsinki", "Hèlsinki" },
            { "timezone.excity.Africa/Mogadishu", "Mogadiscio" },
            { "timezone.excity.America/Eirunepe", "Eirunepé" },
            { "timezone.excity.America/Mazatlan", "Mazatlán" },
            { "timezone.excity.America/New_York", "Nova York" },
            { "timezone.excity.America/Santarem", "Santarém" },
            { "timezone.excity.America/St_Johns", "Saint John’s" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "timezone.excity.America/St_Lucia", "Saint Lucia" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoiarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Novossibirsk" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudes" },
            { "timezone.excity.Europe/Astrakhan", "Astracan" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "timezone.excity.Europe/Stockholm", "Estocolm" },
            { "timezone.excity.Europe/Ulyanovsk", "Uliànovsk" },
            { "timezone.excity.Indian/Mauritius", "Maurici" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.America/Araguaina", "Araguaína" },
            { "timezone.excity.America/Sao_Paulo", "São Paulo" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Copenhagen", "Copenhaguen" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "timezone.excity.Europe/Simferopol", "Simferòpol" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Galápagos" },
            { "timezone.excity.Pacific/Marquesas", "Marqueses" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "timezone.excity.America/St_Vincent", "Saint Vincent" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Iekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavík" },
            { "timezone.excity.Atlantic/St_Helena", "Saint Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Man" },
            { "timezone.excity.America/Mexico_City", "Ciutat de Mèxic" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cap Verd" },
            { "timezone.excity.America/Blanc-Sablon", "Blanc Sablon" },
            { "timezone.excity.America/Scoresbysund", "Scoresbysund" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barthélemy" },
            { "timezone.excity.Atlantic/South_Georgia", "Geòrgia del Sud" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucumán" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota del Nord" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota del Nord" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Río Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota del Nord" },
        };
        return data;
    }
}
