/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_tk extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_chr = "çeroki";
        final Object[][] data = new Object[][] {
            { "001", "Dünýä" },
            { "002", "Afrika" },
            { "003", "Demirgazyk Amerika" },
            { "005", "Günorta Amerika" },
            { "009", "Okeaniýa" },
            { "011", "Günbatar Afrika" },
            { "013", "Orta Amerika" },
            { "014", "Gündogar Afrika" },
            { "015", "Demirgazyk Afrika" },
            { "017", "Orta Afrika" },
            { "018", "Afrikanyň günorta sebitleri" },
            { "019", "Amerika" },
            { "021", "Amerikanyň demirgazyk ýurtlary" },
            { "029", "Karib basseýni" },
            { "030", "Gündogar Aziýa" },
            { "034", "Günorta Aziýa" },
            { "035", "Günorta-gündogar Aziýa" },
            { "039", "Günorta Ýewropa" },
            { "053", "Awstralaziýa" },
            { "054", "Melaneziýa" },
            { "057", "Mikroneziýa sebti" },
            { "061", "Polineziýa" },
            { "142", "Aziýa" },
            { "143", "Merkezi Aziýa" },
            { "145", "Günbatar Aziýa" },
            { "150", "Ýewropa" },
            { "151", "Gündogar Ýewropa" },
            { "154", "Demirgazyk Ýewropa" },
            { "155", "Günbatar Ýewropa" },
            { "202", "Saharadan aşakdaky Afrika" },
            { "419", "Latyn Amerikasy" },
            { "AC", "Beýgeliş adasy" },
            { "AD", "Andorra" },
            { "AE", "Birleşen Arap Emirlikleri" },
            { "AF", "Owganystan" },
            { "AG", "Antigua we Barbuda" },
            { "AI", "Angilýa" },
            { "AL", "Albaniýa" },
            { "AM", "Ermenistan" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentina" },
            { "AS", "Amerikan Samoasy" },
            { "AT", "Awstriýa" },
            { "AU", "Awstraliýa" },
            { "AW", "Aruba" },
            { "AX", "Aland adalary" },
            { "AZ", "Azerbaýjan" },
            { "BA", "Bosniýa we Gersegowina" },
            { "BB", "Barbados" },
            { "BD", "Bangladeş" },
            { "BE", "Belgiýa" },
            { "BF", "Burkina-Faso" },
            { "BG", "Bolgariýa" },
            { "BH", "Bahreýn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sen-Bartelemi" },
            { "BM", "Bermuda" },
            { "BN", "Bruneý" },
            { "BO", "Boliwiýa" },
            { "BQ", "Karib Niderlandlary" },
            { "BR", "Braziliýa" },
            { "BS", "Bagama adalary" },
            { "BT", "Butan" },
            { "BV", "Buwe adasy" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Beliz" },
            { "CA", "Kanada" },
            { "CC", "Kokos (Kiling) adalary" },
            { "CD", "Kongo - Kinşasa" },
            { "CF", "Merkezi Afrika Respublikasy" },
            { "CG", "Kongo - Brazzawil" },
            { "CH", "Şweýsariýa" },
            { "CI", "Kot-d’Iwuar" },
            { "CK", "Kuk adalary" },
            { "CL", "Çili" },
            { "CM", "Kamerun" },
            { "CN", "Hytaý" },
            { "CO", "Kolumbiýa" },
            { "CP", "Klipperton adasy" },
            { "CR", "Kosta-Rika" },
            { "CU", "Kuba" },
            { "CV", "Kabo-Werde" },
            { "CW", "Kýurasao" },
            { "CX", "Roždestwo adasy" },
            { "CY", "Kipr" },
            { "CZ", "Çehiýa" },
            { "DE", "Germaniýa" },
            { "DG", "Diýego-Garsiýa" },
            { "DJ", "Jibuti" },
            { "DK", "Daniýa" },
            { "DM", "Dominika" },
            { "DO", "Dominikan Respublikasy" },
            { "DZ", "Alžir" },
            { "EA", "Seuta we Melilýa" },
            { "EC", "Ekwador" },
            { "EE", "Estoniýa" },
            { "EG", "Müsür" },
            { "EH", "Günbatar Sahara" },
            { "ER", "Eritreýa" },
            { "ES", "Ispaniýa" },
            { "ET", "Efiopiýa" },
            { "EU", "Ýewropa Bileleşigi" },
            { "EZ", "Ýewro sebiti" },
            { "FI", "Finlýandiýa" },
            { "FJ", "Fiji" },
            { "FK", "Folklend adalary" },
            { "FM", "Mikroneziýa" },
            { "FO", "Farer adalary" },
            { "FR", "Fransiýa" },
            { "GA", "Gabon" },
            { "GB", "Birleşen Patyşalyk" },
            { "GD", "Grenada" },
            { "GE", "Gruziýa" },
            { "GF", "Fransuz Gwianasy" },
            { "GG", "Gernsi" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Grenlandiýa" },
            { "GM", "Gambiýa" },
            { "GN", "Gwineýa" },
            { "GP", "Gwadelupa" },
            { "GQ", "Ekwatorial Gwineýa" },
            { "GR", "Gresiýa" },
            { "GS", "Günorta Georgiýa we Günorta Sendwiç adasy" },
            { "GT", "Gwatemala" },
            { "GU", "Guam" },
            { "GW", "Gwineýa-Bisau" },
            { "GY", "Gaýana" },
            { "HK", "Gonkong AAS Hytaý" },
            { "HM", "Herd we Makdonald adalary" },
            { "HN", "Gonduras" },
            { "HR", "Horwatiýa" },
            { "HT", "Gaiti" },
            { "HU", "Wengriýa" },
            { "IC", "Kanar adalary" },
            { "ID", "Indoneziýa" },
            { "IE", "Irlandiýa" },
            { "IL", "Ysraýyl" },
            { "IM", "Men adasy" },
            { "IN", "Hindistan" },
            { "IO", "Britaniýanyň Hindi okeanyndaky territoriýalary" },
            { "IQ", "Yrak" },
            { "IR", "Eýran" },
            { "IS", "Islandiýa" },
            { "IT", "Italiýa" },
            { "JE", "Jersi" },
            { "JM", "Ýamaýka" },
            { "JO", "Iordaniýa" },
            { "JP", "Ýaponiýa" },
            { "KE", "Keniýa" },
            { "KG", "Gyrgyzystan" },
            { "KH", "Kamboja" },
            { "KI", "Kiribati" },
            { "KM", "Komor adalary" },
            { "KN", "Sent-Kits we Newis" },
            { "KP", "Demirgazyk Koreýa" },
            { "KR", "Günorta Koreýa" },
            { "KW", "Kuweýt" },
            { "KY", "Kaýman adalary" },
            { "KZ", "Gazagystan" },
            { "LA", "Laos" },
            { "LB", "Liwan" },
            { "LC", "Sent-Lýusiýa" },
            { "LI", "Lihtenşteýn" },
            { "LK", "Şri-Lanka" },
            { "LR", "Liberiýa" },
            { "LS", "Lesoto" },
            { "LT", "Litwa" },
            { "LU", "Lýuksemburg" },
            { "LV", "Latwiýa" },
            { "LY", "Liwiýa" },
            { "MA", "Marokko" },
            { "MC", "Monako" },
            { "MD", "Moldowa" },
            { "ME", "Çernogoriýa" },
            { "MF", "Sen-Marten" },
            { "MG", "Madagaskar" },
            { "MH", "Marşall adalary" },
            { "MK", "Demirgazyk Makedoniýa" },
            { "ML", "Mali" },
            { "MM", "Mýanma (Birma)" },
            { "MN", "Mongoliýa" },
            { "MO", "Makao AAS Hytaý" },
            { "MP", "Demirgazyk Mariana adalary" },
            { "MQ", "Martinika" },
            { "MR", "Mawritaniýa" },
            { "MS", "Monserrat" },
            { "MT", "Malta" },
            { "MU", "Mawrikiý" },
            { "MV", "Maldiwler" },
            { "MW", "Malawi" },
            { "MX", "Meksika" },
            { "MY", "Malaýziýa" },
            { "MZ", "Mozambik" },
            { "NA", "Namibiýa" },
            { "NC", "Täze Kaledoniýa" },
            { "NE", "Niger" },
            { "NF", "Norfolk adasy" },
            { "NG", "Nigeriýa" },
            { "NI", "Nikaragua" },
            { "NL", "Niderlandlar" },
            { "NO", "Norwegiýa" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Täze Zelandiýa" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Fransuz Polineziýasy" },
            { "PG", "Papua - Täze Gwineýa" },
            { "PH", "Filippinler" },
            { "PK", "Pakistan" },
            { "PL", "Polşa" },
            { "PM", "Sen-Pýer we Mikelon" },
            { "PN", "Pitkern adalary" },
            { "PR", "Puerto-Riko" },
            { "PS", "Palestina territoriýasy" },
            { "PT", "Portugaliýa" },
            { "PW", "Palau" },
            { "PY", "Paragwaý" },
            { "QA", "Katar" },
            { "QO", "Daşky Okeaniýa" },
            { "RE", "Reýunýon" },
            { "RO", "Rumyniýa" },
            { "RS", "Serbiýa" },
            { "RU", "Russiýa" },
            { "RW", "Ruanda" },
            { "SA", "Saud Arabystany" },
            { "SB", "Solomon adalary" },
            { "SC", "Seýşel adalary" },
            { "SD", "Sudan" },
            { "SE", "Şwesiýa" },
            { "SG", "Singapur" },
            { "SH", "Keramatly Ýelena adasy" },
            { "SI", "Sloweniýa" },
            { "SJ", "Şpisbergen we Ýan-Maýen" },
            { "SK", "Slowakiýa" },
            { "SL", "Sýerra-Leone" },
            { "SM", "San-Marino" },
            { "SN", "Senegal" },
            { "SO", "Somali" },
            { "SR", "Surinam" },
            { "SS", "Günorta Sudan" },
            { "ST", "San-Tome we Prinsipi" },
            { "SV", "Salwador" },
            { "SX", "Sint-Marten" },
            { "SY", "Siriýa" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan-da-Kunýa" },
            { "TC", "Terks we Kaýkos adalary" },
            { "TD", "Çad" },
            { "TF", "Fransuz günorta territoriýalary" },
            { "TG", "Togo" },
            { "TH", "Taýland" },
            { "TJ", "Täjigistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Türkmenistan" },
            { "TN", "Tunis" },
            { "TO", "Tonga" },
            { "TR", "Türkiýe" },
            { "TT", "Trinidad we Tobago" },
            { "TV", "Tuwalu" },
            { "TW", "Taýwan" },
            { "TZ", "Tanzaniýa" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "ABŞ-nyň daşarky adalary" },
            { "UN", "Birleşen Milletler Guramasy" },
            { "US", "Amerikanyň Birleşen Ştatlary" },
            { "UY", "Urugwaý" },
            { "UZ", "Özbegistan" },
            { "VA", "Watikan" },
            { "VC", "Sent-Winsent we Grenadinler" },
            { "VE", "Wenesuela" },
            { "VG", "Britan Wirgin adalary" },
            { "VI", "ABŞ-nyň Wirgin adalary" },
            { "VN", "Wýetnam" },
            { "VU", "Wanuatu" },
            { "WF", "Uollis we Futuna" },
            { "WS", "Samoa" },
            { "XA", "psewdo-şiweler" },
            { "XB", "psewdo-bidi" },
            { "XK", "Kosowo" },
            { "YE", "Ýemen" },
            { "YT", "Maýotta" },
            { "ZA", "Günorta Afrika" },
            { "ZM", "Zambiýa" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Näbelli sebit" },
            { "aa", "afar dili" },
            { "ab", "abhaz dili" },
            { "af", "afrikaans dili" },
            { "ak", "akan dili" },
            { "am", "amhar dili" },
            { "an", "aragon dili" },
            { "ar", "arap dili" },
            { "as", "assam dili" },
            { "av", "awar dili" },
            { "ay", "aýmara dili" },
            { "az", "azerbaýjan dili" },
            { "ba", "başgyrt dili" },
            { "be", "belarus dili" },
            { "bg", "bolgar dili" },
            { "bi", "bislama dili" },
            { "bm", "bamana" },
            { "bn", "bengal dili" },
            { "bo", "tibet dili" },
            { "br", "breton dili" },
            { "bs", "bosniýa dili" },
            { "ca", "katalan dili" },
            { "ce", "çeçen dili" },
            { "ch", "çamorro" },
            { "co", "korsikan dili" },
            { "cs", "çeh dili" },
            { "cu", "buthana slaw dili" },
            { "cv", "çuwaş dili" },
            { "cy", "walliý dili" },
            { "da", "daniýa dili" },
            { "de", "nemes dili" },
            { "dv", "diwehi dili" },
            { "dz", "dzong-ke dili" },
            { "ee", "ewe dili" },
            { "el", "grek dili" },
            { "en", "iňlis dili" },
            { "eo", "esperanto dili" },
            { "es", "ispan dili" },
            { "et", "eston dili" },
            { "eu", "bask dili" },
            { "fa", "pars dili" },
            { "ff", "fula dili" },
            { "fi", "fin dili" },
            { "fj", "fiji dili" },
            { "fo", "farer dili" },
            { "fr", "fransuz dili" },
            { "fy", "günbatar friz dili" },
            { "ga", "irland dili" },
            { "gd", "şotland kelt dili" },
            { "gl", "galisiý dili" },
            { "gn", "guarani dili" },
            { "gu", "gujarati dili" },
            { "gv", "men dili" },
            { "ha", "hausa dili" },
            { "he", "ýewreý dili" },
            { "hi", "hindi dili" },
            { "hr", "horwat dili" },
            { "ht", "gaiti kreol dili" },
            { "hu", "wenger dili" },
            { "hy", "ermeni dili" },
            { "hz", "gerero dili" },
            { "ia", "interlingwa dili" },
            { "id", "indonez dili" },
            { "ie", "interlingwe dili" },
            { "ig", "igbo dili" },
            { "ii", "syçuan-i dili" },
            { "io", "ido dili" },
            { "is", "island dili" },
            { "it", "italýan dili" },
            { "iu", "inuktitut dili" },
            { "ja", "ýapon dili" },
            { "jv", "ýawa dili" },
            { "ka", "gruzin dili" },
            { "ki", "kikuýu dili" },
            { "kj", "kwanýama dili" },
            { "kk", "gazak dili" },
            { "kl", "grenland dili" },
            { "km", "khmer dili" },
            { "kn", "kannada dili" },
            { "ko", "koreý dili" },
            { "kr", "kanuri" },
            { "ks", "kaşmiri dili" },
            { "ku", "kürt dili" },
            { "kv", "komi dili" },
            { "kw", "korn dili" },
            { "ky", "gyrgyz dili" },
            { "la", "latyn dili" },
            { "lb", "lýuksemburg dili" },
            { "lg", "ganda dili" },
            { "li", "limburg dili" },
            { "ln", "lingala dili" },
            { "lo", "laos dili" },
            { "lt", "litwa dili" },
            { "lu", "luba-katanga dili" },
            { "lv", "latyş dili" },
            { "mg", "malagasiý dili" },
            { "mh", "marşall dili" },
            { "mi", "maori dili" },
            { "mk", "makedon dili" },
            { "ml", "malaýalam dili" },
            { "mn", "mongol dili" },
            { "mr", "marathi dili" },
            { "ms", "malaý dili" },
            { "mt", "malta dili" },
            { "my", "birma dili" },
            { "na", "nauru dili" },
            { "nb", "norwegiýa bukmol dili" },
            { "nd", "demirgazyk ndebele dili" },
            { "ne", "nepal dili" },
            { "ng", "ndonga dili" },
            { "nl", "niderland dili" },
            { "nn", "norwegiýa nýunorsk dili" },
            { "no", "norweg dili" },
            { "nr", "günorta ndebele dili" },
            { "nv", "nawaho dili" },
            { "ny", "nýanja dili" },
            { "oc", "oksitan dili" },
            { "om", "oromo dili" },
            { "or", "oriýa dili" },
            { "os", "osetin dili" },
            { "pa", "penjab dili" },
            { "pl", "polýak dili" },
            { "ps", "peştun dili" },
            { "pt", "portugal dili" },
            { "qu", "keçua dili" },
            { "rm", "retoroman dili" },
            { "rn", "rundi dili" },
            { "ro", "rumyn dili" },
            { "ru", "rus dili" },
            { "rw", "kinýaruanda dili" },
            { "sa", "sanskrit dili" },
            { "sc", "sardin dili" },
            { "sd", "sindhi dili" },
            { "se", "demirgazyk saam dili" },
            { "sg", "sango dili" },
            { "si", "singal dili" },
            { "sk", "slowak dili" },
            { "sl", "slowen dili" },
            { "sm", "samoa dili" },
            { "sn", "şona dili" },
            { "so", "somali dili" },
            { "sq", "alban dili" },
            { "sr", "serb dili" },
            { "ss", "swati dili" },
            { "st", "günorta soto dili" },
            { "su", "sundan dili" },
            { "sv", "şwed dili" },
            { "sw", "suahili dili" },
            { "ta", "tamil dili" },
            { "te", "telugu dili" },
            { "tg", "täjik dili" },
            { "th", "taý dili" },
            { "ti", "tigrinýa dili" },
            { "tk", "türkmen dili" },
            { "tn", "tswana dili" },
            { "to", "tongan dili" },
            { "tr", "türk dili" },
            { "ts", "tsonga dili" },
            { "tt", "tatar dili" },
            { "ty", "taiti dili" },
            { "ug", "uýgur dili" },
            { "uk", "ukrain dili" },
            { "ur", "urdu" },
            { "uz", "özbek dili" },
            { "ve", "wenda dili" },
            { "vi", "wýetnam dili" },
            { "vo", "wolapýuk dili" },
            { "wa", "wallon dili" },
            { "wo", "wolof dili" },
            { "xh", "kosa dili" },
            { "yi", "idiş dili" },
            { "yo", "ýoruba dili" },
            { "za", "çžuan dili" },
            { "zh", "hytaý dili" },
            { "zu", "zulu dili" },
            { "ace", "açeh dili" },
            { "ada", "adangme dili" },
            { "ady", "adygeý dili" },
            { "agq", "ahem dili" },
            { "ain", "aýn dili" },
            { "ale", "aleut dili" },
            { "alt", "günorta Altaý dili" },
            { "ann", "obolo dili" },
            { "anp", "angika dili" },
            { "arn", "mapuçe dili" },
            { "arp", "arapaho dili" },
            { "ars", "nejdi arap dili" },
            { "asa", "asu dili" },
            { "ast", "asturiý dili" },
            { "atj", "atikamekw dili" },
            { "awa", "awadhi dili" },
            { "ban", "baliý dili" },
            { "bas", "basaa dili" },
            { "bem", "bemba dili" },
            { "bez", "bena dili" },
            { "bgc", "harýanwi dili" },
            { "bho", "bhojpuri dili" },
            { "bin", "bini dili" },
            { "bla", "siksika dili" },
            { "blo", "blo dili" },
            { "brx", "bodo dili" },
            { "bug", "bugiý dili" },
            { "byn", "blin dili" },
            { "cay", "kaýuga dili" },
            { "ccp", "çakma dili" },
            { "ceb", "sebuan dili" },
            { "cgg", "kiga" },
            { "chk", "çuuk dili" },
            { "chm", "mariý dili" },
            { "cho", "çokto" },
            { "chp", "çipewýan dili" },
            { "chr", metaValue_chr },
            { "chy", "şaýenn dili" },
            { "ckb", "merkezi kürt dili" },
            { "clc", "çilkotin dili" },
            { "crg", "miçif dili" },
            { "crj", "günorta-gündogar kri dili" },
            { "crk", "düzdeçi kri dili" },
            { "crl", "demirgazyk-gündogar kri dili" },
            { "crm", "los-kri dili" },
            { "crr", "karolina algonkin dili" },
            { "crs", "seselwa kreole-fransuz dili" },
            { "csw", "batgalyk kri dili" },
            { "dak", "dakota dili" },
            { "dar", "dargi dili" },
            { "dav", "taita dili" },
            { "dgr", "dogrib dili" },
            { "dje", "zarma dili" },
            { "doi", "dogri" },
            { "dsb", "aşaky lužits dili" },
            { "dua", "duala dili" },
            { "dyo", "ýola-fonýi dili" },
            { "dzg", "daza dili" },
            { "ebu", "embu dili" },
            { "efi", "efik dili" },
            { "eka", "ekajuk dili" },
            { "ewo", "ewondo dili" },
            { "fil", "filippin dili" },
            { "fon", "fon dili" },
            { "frc", "fransuz diliniň kajun şiwesi" },
            { "frr", "demirgazyk friz dili" },
            { "fur", "friul dili" },
            { "gaa", "ga dili" },
            { "gez", "geez dili" },
            { "gil", "gilbert dili" },
            { "gor", "gorontalo dili" },
            { "gsw", "nemes dili (Şweýsariýa)" },
            { "guz", "gusii dili" },
            { "gwi", "gwiçin dili" },
            { "hai", "haýda dili" },
            { "haw", "gawaý dili" },
            { "hax", "günorta haýda dili" },
            { "hil", "hiligaýnon dili" },
            { "hmn", "hmong dili" },
            { "hsb", "ýokarky lužits dili" },
            { "hup", "hupa" },
            { "hur", "halkomelem dili" },
            { "iba", "iban dili" },
            { "ibb", "ibibio dili" },
            { "ikt", "Günorta Kanada iniktitut dili" },
            { "ilo", "iloko dili" },
            { "inh", "inguş dili" },
            { "jbo", "lojban dili" },
            { "jgo", "ngomba dili" },
            { "jmc", "maçame dili" },
            { "kab", "kabil dili" },
            { "kac", "kaçin dili" },
            { "kaj", "ju dili" },
            { "kam", "kamba dili" },
            { "kbd", "kabardin dili" },
            { "kcg", "tiap dili" },
            { "kde", "makonde dili" },
            { "kea", "kabuwerdianu dili" },
            { "kfo", "koro dili" },
            { "kgp", "kaýngang dili" },
            { "kha", "khasi dili" },
            { "khq", "koýra-çini dili" },
            { "kkj", "kako dili" },
            { "kln", "kalenjin dili" },
            { "kmb", "kimbundu dili" },
            { "kok", "konkani dili" },
            { "kpe", "kpelle dili" },
            { "krc", "karaçaý-balkar dili" },
            { "krl", "karel dili" },
            { "kru", "kuruh dili" },
            { "ksb", "şambala dili" },
            { "ksf", "bafia dili" },
            { "ksh", "keln dili" },
            { "kum", "kumyk dili" },
            { "kwk", "kwakwala dili" },
            { "kxv", "kuwi dili" },
            { "lad", "ladino dili" },
            { "lag", "langi dili" },
            { "lez", "lezgin dili" },
            { "lij", "ligur dili" },
            { "lil", "lilluet dili" },
            { "lkt", "lakota dili" },
            { "lmo", "lombard dili" },
            { "lou", "Luiziana kreol dili" },
            { "loz", "lozi dili" },
            { "lrc", "demirgazyk luri dili" },
            { "lsm", "samiýa dili" },
            { "lua", "luba-Lulua dili" },
            { "lun", "lunda dili" },
            { "luo", "luo dili" },
            { "lus", "mizo dili" },
            { "luy", "luýýa dili" },
            { "mad", "madur dili" },
            { "mag", "magahi dili" },
            { "mai", "maýthili dili" },
            { "mak", "makasar dili" },
            { "mas", "masai dili" },
            { "mdf", "mokşa dili" },
            { "men", "mende dili" },
            { "mer", "meru dili" },
            { "mfe", "morisýen dili" },
            { "mgh", "makuwa-mito dili" },
            { "mgo", "meta dili" },
            { "mic", "mikmak dili" },
            { "min", "minangkabau dili" },
            { "mni", "manipuri dili" },
            { "moe", "innu-aýmun dili" },
            { "moh", "mogauk dili" },
            { "mos", "mossi dili" },
            { "mua", "mundang dili" },
            { "mul", "birnäçe dil" },
            { "mus", "krik dili" },
            { "mwl", "mirand dili" },
            { "myv", "erzýan dili" },
            { "mzn", "mazanderan dili" },
            { "nap", "neapolitan dili" },
            { "naq", "nama dili" },
            { "nds", "aşaky nemes dili" },
            { "new", "newari dili" },
            { "nia", "nias dili" },
            { "niu", "niue dili" },
            { "nmg", "kwasio dili" },
            { "nnh", "ngembun dili" },
            { "nog", "nogaý dili" },
            { "nqo", "nko dili" },
            { "nso", "demirgazyk soto dili" },
            { "nus", "nuer dili" },
            { "nyn", "nýankole dili" },
            { "ojb", "demirgazyk-günbatar ojibwa dili" },
            { "ojc", "merkezi ojibwa dili" },
            { "ojs", "oji-kri dili" },
            { "ojw", "günbatar ojibwa dili" },
            { "oka", "okanagan dili" },
            { "pag", "pangansinan dili" },
            { "pam", "kapampangan dili" },
            { "pap", "papýamento dili" },
            { "pau", "palau dili" },
            { "pcm", "nigeriýa-pijin dili" },
            { "pis", "pijin dili" },
            { "pqm", "malisit-passamakwodi dili" },
            { "prg", "prussiýa dili" },
            { "quc", "kiçe dili" },
            { "raj", "rajastani dili" },
            { "rap", "rapanuý dili" },
            { "rar", "kuk dili" },
            { "rhg", "rohinýa dili" },
            { "rof", "rombo dili" },
            { "rup", "arumyn dili" },
            { "rwk", "rwa dili" },
            { "sad", "sandawe dili" },
            { "sah", "ýakut dili" },
            { "saq", "samburu dili" },
            { "sat", "santali dili" },
            { "sba", "ngambaý dili" },
            { "sbp", "sangu dili" },
            { "scn", "sisiliýa dili" },
            { "sco", "şotland dili" },
            { "seh", "sena dili" },
            { "ses", "koýraboro-senni dili" },
            { "shi", "tahelhit dili" },
            { "shn", "şan dili" },
            { "slh", "günorta Luşutsid dili" },
            { "sma", "günorta saam dili" },
            { "smj", "lule-saam dili" },
            { "smn", "inari-saam dili" },
            { "sms", "skolt-saam dili" },
            { "snk", "soninke dili" },
            { "srn", "sranan-tongo dili" },
            { "ssy", "saho dili" },
            { "str", "demirgazyk bogaz saliş dili" },
            { "suk", "sukuma dili" },
            { "swb", "komor dili" },
            { "syr", "siriýa dili" },
            { "szl", "silez dili" },
            { "tce", "günorta tutçone dili" },
            { "tem", "temne dili" },
            { "teo", "teso dili" },
            { "tet", "tetum dili" },
            { "tgx", "tagiş dili" },
            { "tht", "taltan dili" },
            { "tig", "tigre dili" },
            { "tlh", "klingon dili" },
            { "tli", "tlinkit dili" },
            { "tok", "toki pona dili" },
            { "tpi", "tok-pisin dili" },
            { "trv", "taroko dili" },
            { "ttm", "demirgazyk tutçone dili" },
            { "tum", "tumbuka dili" },
            { "tvl", "tuwalu dili" },
            { "twq", "tasawak dili" },
            { "tyv", "tuwa dili" },
            { "tzm", "orta-atlas tamazight dili" },
            { "udm", "udmurt dili" },
            { "umb", "umbundu dili" },
            { "und", "näbelli dil" },
            { "vai", "wai dili" },
            { "vec", "wenesian dili" },
            { "vmw", "mahuwa dili" },
            { "vun", "wunýo dili" },
            { "wae", "walzer dili" },
            { "wal", "wolaýta dili" },
            { "war", "waraý dili" },
            { "wuu", "u hytaý dili" },
            { "xal", "galmyk dili" },
            { "xnr", "kangri dili" },
            { "xog", "soga dili" },
            { "yav", "ýangben dili" },
            { "ybb", "ýemba dili" },
            { "yrl", "nhengatu dili" },
            { "yue", "kanton dili" },
            { "zgh", "standart Marokko tamazight dili" },
            { "zun", "zuni dili" },
            { "zxx", "dilçilige degişli mazmun ýok" },
            { "zza", "zazaki dili" },
            { "Adlm", "adlam" },
            { "Arab", "Arap elipbiýi" },
            { "Aran", "Nastalik ýazuwy" },
            { "Armn", "Ermeni elipbiýi" },
            { "Beng", "Bengal elipbiýi" },
            { "Bopo", "Bopomofo elipbiýi" },
            { "Brai", "Braýl elipbiýi" },
            { "Cakm", "çakma" },
            { "Cans", "Kanadanyň ýerlileriniň bogunlarynyň bitewileşdirilen ulgamy" },
            { "Cher", metaValue_chr },
            { "Cyrl", "Kiril elipbiýi" },
            { "Deva", "Dewanagari elipbiýi" },
            { "Ethi", "Efiop elipbiýi" },
            { "Geor", "Gruzin elipbiýi" },
            { "Grek", "Grek elipbiýi" },
            { "Gujr", "Gujarati elipbiýi" },
            { "Guru", "Gurmuhi elipbiýi" },
            { "Hanb", "Bopomofo han elipbiýi" },
            { "Hang", "Hangyl elipbiýi" },
            { "Hani", "Han elipbiýi" },
            { "Hans", "Ýönekeýleşdirilen" },
            { "Hant", "Adaty" },
            { "Hebr", "Ýewreý elipbiýi" },
            { "Hira", "Hiragana elipbiýi" },
            { "Hrkt", "Ýapon bogun elipbiýleri" },
            { "Jamo", "Jamo elipbiýi" },
            { "Jpan", "Ýapon elipbiýi" },
            { "Kana", "Katakana elipbiýi" },
            { "Khmr", "Khmer elipbiýi" },
            { "Knda", "Kannada elipbiýi" },
            { "Kore", "Koreý elipbiýi" },
            { "Laoo", "Laos elipbiýi" },
            { "Latn", "Latyn elipbiýi" },
            { "Mlym", "Malaýalam elipbiýi" },
            { "Mong", "Mongol elipbiýi" },
            { "Mtei", "meýteý-maýek" },
            { "Mymr", "Mýanma elipbiýi" },
            { "Nkoo", "nko" },
            { "Olck", "ol-çiki" },
            { "Orya", "Oriýa elipbiýi" },
            { "Rohg", "hanifi" },
            { "Sinh", "Singal elipbiýi" },
            { "Sund", "Sundanez ýazuwy" },
            { "Syrc", "Siriýa ýazuwy" },
            { "Taml", "Tamil elipbiýi" },
            { "Telu", "Telugu elipbiýi" },
            { "Tfng", "Tifinag ýazuwy" },
            { "Thaa", "Taana elipbiýi" },
            { "Thai", "Taý elipbiýi" },
            { "Tibt", "Tibet elipbiýi" },
            { "Vaii", "Waý ýazuwy" },
            { "Yiii", "Ýi ýazuwy" },
            { "Zmth", "Matematiki belgiler" },
            { "Zsye", "Emoji" },
            { "Zsym", "Nyşanlar" },
            { "Zxxx", "Ýazuwsyz" },
            { "Zyyy", "Umumy" },
            { "Zzzz", "Näbelli elipbiý" },
            { "de_CH", "ýokarky nemes dili (Şweýsariýa)" },
            { "en_GB", "iňlis dili (Beýik Britaniýa)" },
            { "en_US", "iňlis dili (Amerika)" },
            { "es_ES", "ispan dili (Ýewropa)" },
            { "fa_AF", "dari dili" },
            { "nl_BE", "flamand dili" },
            { "pt_PT", "portugal dili (Ýewropa)" },
            { "ro_MD", "moldaw dili" },
            { "sw_CD", "kongo suahili dili" },
            { "ar_001", "häzirki zaman standart arap dili" },
            { "key.ca", "Senenama" },
            { "key.cf", "Pul birliginiň formaty" },
            { "key.co", "Tertip rejesi" },
            { "key.cu", "Pul birligi" },
            { "key.hc", "Sagat aýlawy (12–24 sagat)" },
            { "key.lb", "Setirden setire geçiş stili" },
            { "key.ms", "Ölçeg ulgamy" },
            { "key.nu", "Sanlar" },
            { "zh_Hans", "ýönekeýleşdirilen hytaý dili" },
            { "zh_Hant", "adaty hytaý dili" },
            { "type.ca.roc", "Minguo senenamasy" },
            { "type.hc.h11", "12 sagat ulgamy (0–11)" },
            { "type.hc.h12", "12 sagat ulgamy (1–12)" },
            { "type.hc.h23", "24 sagat ulgamy (0–23)" },
            { "type.hc.h24", "24 sagat ulgamy (1–24)" },
            { "type.nu.arab", "Arap-hindi sanlary" },
            { "type.nu.armn", "Ermeni sanlary" },
            { "type.nu.beng", "Bengal sanlary" },
            { "type.nu.cakm", "Çakma sanlary" },
            { "type.nu.deva", "Dewanagari sanlary" },
            { "type.nu.ethi", "Efiop sanlary" },
            { "type.nu.geor", "Gruzin sanlary" },
            { "type.nu.grek", "Grek sanlary" },
            { "type.nu.gujr", "Gujarati sanlary" },
            { "type.nu.guru", "Gurmuhi sanlary" },
            { "type.nu.hans", "Ýönekeýleşdirilen hytaý sanlary" },
            { "type.nu.hant", "Adaty hytaý sanlary" },
            { "type.nu.hebr", "Ýewreý sanlary" },
            { "type.nu.java", "Ýawa sanlary" },
            { "type.nu.jpan", "Ýapon sanlary" },
            { "type.nu.khmr", "Khmer sanlary" },
            { "type.nu.knda", "Kannada sanlary" },
            { "type.nu.laoo", "Laos sanlary" },
            { "type.nu.latn", "Latyn sanlary" },
            { "type.nu.mlym", "Malaýalam sanlary" },
            { "type.nu.mtei", "Miteý Maýek sanlary" },
            { "type.nu.mymr", "Mýanma sanlary" },
            { "type.nu.olck", "Ol Çiki sanlary" },
            { "type.nu.orya", "Oriýa sanlary" },
            { "type.nu.taml", "Adaty tamil sanlary" },
            { "type.nu.telu", "Telugu sanlary" },
            { "type.nu.thai", "Taý sanlary" },
            { "type.nu.tibt", "Tibet sanlary" },
            { "type.nu.vaii", "Waý sanlary" },
            { "type.ca.dangi", "Dangi senenamasy" },
            { "type.co.ducet", "Deslapky Ýunikod tertip rejesi" },
            { "type.lb.loose", "Setirden setire geçişiň gowşak stili" },
            { "type.nu.roman", "Rim sanlary" },
            { "type.ca.coptic", "Kopt senenamasy" },
            { "type.ca.hebrew", "Ýewreý senenamasy" },
            { "type.co.search", "Umumy maksatly gözleg" },
            { "type.lb.normal", "Setirden setire geçişiň adaty stili" },
            { "type.lb.strict", "Setirden setire geçişiň berk stili" },
            { "type.ms.metric", "Metrik ulgam" },
            { "type.ca.chinese", "Hytaý senenamasy" },
            { "type.ca.islamic", "Hijri-kamary senenamasy" },
            { "type.ca.iso8601", "ISO-8601 senenamasy" },
            { "type.ca.persian", "Pars senenamasy" },
            { "type.cf.account", "Pul birliginiň buhgalterçilik formaty" },
            { "type.nu.arabext", "Arap-hindi sanlarynyň giňeldilen görnüşi" },
            { "type.nu.armnlow", "Ermeni setir sanlary" },
            { "type.nu.greklow", "Grek setir sanlary" },
            { "type.nu.hanidec", "Hytaý onluk sanlary" },
            { "type.nu.hansfin", "Ýönekeýleşdirilen hytaý maliýe sanlary" },
            { "type.nu.hantfin", "Adaty hytaý maliýe sanlary" },
            { "type.nu.jpanfin", "Ýapon maliýe sanlary" },
            { "type.nu.tamldec", "Tamil sanlary" },
            { "type.ca.buddhist", "Buddist senenamasy" },
            { "type.ca.ethiopic", "Efiop senenamasy" },
            { "type.ca.japanese", "Ýapon senenamasy" },
            { "type.cf.standard", "Pul birliginiň standart formaty" },
            { "type.co.standard", "Standart tertip rejesi" },
            { "type.ms.uksystem", "Imperial ölçeg ulgamy" },
            { "type.ms.ussystem", "ABŞ ölçeg ulgamy" },
            { "type.nu.fullwide", "Doly giňlikdäki sanlar" },
            { "type.nu.romanlow", "Rim setir sanlary" },
            { "type.ca.gregorian", "Grigorian senenamasy" },
            { "type.ca.islamic-tbla", "Hijri-kamary senenamasy (tablisaly, astronomik eýýam)" },
            { "type.ca.islamic-civil", "Hijri-kamary senenamasy (tablisaly, raýat eýýamy)" },
            { "type.ca.islamic-umalqura", "Hijri-kamary senenamasy (Umm al-Kura)" },
            { "type.ca.ethiopic-amete-alem", "Efiopiýa Amete Alem senenamasy" },
        };
        return data;
    }
}
