/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_dsb extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "swět" },
            { "002", "Afrika" },
            { "003", "Pódpołnocna Amerika" },
            { "005", "Pódpołdnjowa Amerika" },
            { "009", "Oceaniska" },
            { "011", "Pódwjacorna Afrika" },
            { "013", "Srjejźna Amerika" },
            { "014", "pódzajtšna Afrika" },
            { "015", "pódpołnocna Afrika" },
            { "017", "srjejźna Afrika" },
            { "018", "pódpołdnjowa Afrika" },
            { "019", "Amerika" },
            { "021", "pódpołnocny ameriski kontinent" },
            { "029", "Karibiska" },
            { "030", "pódzajtšna Azija" },
            { "034", "pódpołdnjowa Azija" },
            { "035", "krotkozajtšna Azija" },
            { "039", "pódpołdnjowa Europa" },
            { "053", "Awstralazija" },
            { "054", "Melaneziska" },
            { "057", "Mikroneziska (kupowy region)" },
            { "061", "Polyneziska" },
            { "142", "Azija" },
            { "143", "centralna Azija" },
            { "145", "pódwjacorna Azija" },
            { "150", "Europa" },
            { "151", "pódzajtšna Europa" },
            { "154", "pódpołnocna Europa" },
            { "155", "pódwjacorna Europa" },
            { "202", "subsaharojska Afrika" },
            { "419", "Łatyńska Amerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Zjadnośone arabiske emiraty" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua a Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albańska" },
            { "AM", "Armeńska" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentinska" },
            { "AS", "Ameriska Samoa" },
            { "AT", "Awstriska" },
            { "AU", "Awstralska" },
            { "AW", "Aruba" },
            { "AX", "Åland" },
            { "AZ", "Azerbajdžan" },
            { "BA", "Bosniska a Hercegowina" },
            { "BB", "Barbados" },
            { "BD", "Bangladeš" },
            { "BE", "Belgiska" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarska" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barthélemy" },
            { "BM", "Bermudy" },
            { "BN", "Brunei" },
            { "BO", "Boliwiska" },
            { "BQ", "Karibiska Nižozemska" },
            { "BR", "Brazilska" },
            { "BS", "Bahamy" },
            { "BT", "Bhutan" },
            { "BV", "Bouvetowa kupa" },
            { "BW", "Botswana" },
            { "BY", "Běłoruska" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosowe kupy" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Centralnoafriska republika" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Šwicarska" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Cookowe kupy" },
            { "CL", "Chilska" },
            { "CM", "Kamerun" },
            { "CN", "China" },
            { "CO", "Kolumbiska" },
            { "CP", "Clippertonowa kupa" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CW", "Curaçao" },
            { "CX", "Gódowne kupy" },
            { "CY", "Cypriska" },
            { "CZ", "Česka republika" },
            { "DE", "Nimska" },
            { "DG", "Diego Garcia" },
            { "DJ", "Džibuti" },
            { "DK", "Dańska" },
            { "DM", "Dominika" },
            { "DO", "Dominikańska republika" },
            { "DZ", "Algeriska" },
            { "EA", "Ceuta a Melilla" },
            { "EC", "Ekwador" },
            { "EE", "Estniska" },
            { "EG", "Egyptojska" },
            { "EH", "Pódwjacorna Sahara" },
            { "ER", "Eritreja" },
            { "ES", "Špańska" },
            { "ET", "Etiopiska" },
            { "EU", "Europska unija" },
            { "EZ", "europasmo" },
            { "FI", "Finska" },
            { "FJ", "Fidži" },
            { "FK", "Falklandske kupy" },
            { "FM", "Mikroneziska" },
            { "FO", "Färöje" },
            { "FR", "Francojska" },
            { "GA", "Gabun" },
            { "GB", "Zjadnośone kralejstwo" },
            { "GD", "Grenada" },
            { "GE", "Georgiska" },
            { "GF", "Francojska Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Grönlandska" },
            { "GM", "Gambija" },
            { "GN", "Gineja" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekwatorialna Gineja" },
            { "GR", "Grichiska" },
            { "GS", "Pódpołdnjowa Georgiska a Pódpołdnjowe Sandwichowe kupy" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Gineja-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Wósebna zastojnstwowa cona Hongkong" },
            { "HM", "Heardowa kupa a McDonaldowe kupy" },
            { "HN", "Honduras" },
            { "HR", "Chorwatska" },
            { "HT", "Haiti" },
            { "HU", "Hungorska" },
            { "IC", "Kanariske kupy" },
            { "ID", "Indoneziska" },
            { "IE", "Irska" },
            { "IL", "Israel" },
            { "IM", "Man" },
            { "IN", "Indiska" },
            { "IO", "Britiski indiskooceaniski teritorium" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandska" },
            { "IT", "Italska" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordaniska" },
            { "JP", "Japańska" },
            { "KE", "Kenia" },
            { "KG", "Kirgizistan" },
            { "KH", "Kambodža" },
            { "KI", "Kiribati" },
            { "KM", "Komory" },
            { "KN", "St. Kitts a Nevis" },
            { "KP", "Pódpołnocna Koreja" },
            { "KR", "Pódpołdnjowa Koreja" },
            { "KW", "Kuwait" },
            { "KY", "Kajmaniske kupy" },
            { "KZ", "Kazachstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "St. Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberija" },
            { "LS", "Lesotho" },
            { "LT", "Litawska" },
            { "LU", "Luxemburgska" },
            { "LV", "Letiska" },
            { "LY", "Libyska" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldawska" },
            { "ME", "Carna Góra" },
            { "MF", "St. Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallowe kupy" },
            { "MK", "Pódpołnocna Makedańska" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongolska" },
            { "MO", "Wósebna zastojnstwowa cona Macao" },
            { "MP", "Pódpołnocne Mariany" },
            { "MQ", "Martinique" },
            { "MR", "Mawretańska" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Malediwy" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malajzija" },
            { "MZ", "Mosambik" },
            { "NA", "Namibija" },
            { "NC", "Nowa Kaledoniska" },
            { "NE", "Niger" },
            { "NF", "Norfolkowa kupa" },
            { "NG", "Nigerija" },
            { "NI", "Nikaragua" },
            { "NL", "Nižozemska" },
            { "NO", "Norwegska" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nowoseelandska" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Francojska Polyneziska" },
            { "PG", "Papua-Neuguinea" },
            { "PH", "Filipiny" },
            { "PK", "Pakistan" },
            { "PL", "Pólska" },
            { "PM", "St. Pierre a Miquelon" },
            { "PN", "Pitcairnowe kupy" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinski awtonomny teritorium" },
            { "PT", "Portugalska" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "wenkowna Oceaniska" },
            { "RE", "Réunion" },
            { "RO", "Rumuńska" },
            { "RS", "Serbiska" },
            { "RU", "Ruska" },
            { "RW", "Ruanda" },
            { "SA", "Saudi-Arabiska" },
            { "SB", "Salomony" },
            { "SC", "Seychelle" },
            { "SD", "Sudan" },
            { "SE", "Šwedska" },
            { "SG", "Singapur" },
            { "SH", "St. Helena" },
            { "SI", "Słowjeńska" },
            { "SJ", "Svalbard a Jan Mayen" },
            { "SK", "Słowakska" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalija" },
            { "SR", "Surinamska" },
            { "SS", "Pódpołdnjowy Sudan" },
            { "ST", "São Tomé a Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syriska" },
            { "SZ", "Swasiska" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks a Caicos kupy" },
            { "TD", "Čad" },
            { "TF", "Francojski pódpołdnjowy a antarktiski teritorium" },
            { "TG", "Togo" },
            { "TH", "Thailandska" },
            { "TJ", "Tadźikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmeniska" },
            { "TN", "Tuneziska" },
            { "TO", "Tonga" },
            { "TR", "Turkojska" },
            { "TT", "Trinidad a Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansanija" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Ameriska Oceaniska" },
            { "UN", "Zjadnośone narody" },
            { "US", "Zjadnośone staty Ameriki" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikańske město" },
            { "VC", "St. Vincent a Grenadiny" },
            { "VE", "Venezuela" },
            { "VG", "Britiske kněžniske kupy" },
            { "VI", "Ameriske kněžniske kupy" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis a Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudo-akcenty" },
            { "XB", "pseudo-bidi" },
            { "XK", "Kosowo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Pódpołdnjowa Afrika (Republika)" },
            { "ZM", "Sambija" },
            { "ZW", "Simbabwe" },
            { "ZZ", "njeznaty region" },
            { "aa", "afaršćina" },
            { "ab", "abchazšćina" },
            { "af", "afrikans" },
            { "ak", "akanšćina" },
            { "am", "amharšćina" },
            { "an", "aragonšćina" },
            { "ar", "arabšćina" },
            { "as", "asamšćina" },
            { "av", "awaršćina" },
            { "ay", "aymaršćina" },
            { "az", "azerbajdžanšćina" },
            { "ba", "baškiršćina" },
            { "be", "běłorušćina" },
            { "bg", "bulgaršćina" },
            { "bi", "bislamšćina" },
            { "bm", "bambara" },
            { "bn", "bengalšćina" },
            { "bo", "tibetšćina" },
            { "br", "bretonšćina" },
            { "bs", "bosnišćina" },
            { "ca", "katanlanšćina" },
            { "ce", "čečenšćina" },
            { "ch", "čamoršćina" },
            { "co", "korsišćina" },
            { "cr", "kri" },
            { "cs", "češćina" },
            { "cu", "cerkwinosłowjańšćina" },
            { "cv", "chuvashišćina" },
            { "cy", "walizišćina" },
            { "da", "danšćina" },
            { "de", "nimšćina" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "grichišćina" },
            { "en", "engelšćina" },
            { "eo", "esperanto" },
            { "es", "špańšćina" },
            { "et", "estišćina" },
            { "eu", "baskišćina" },
            { "fa", "persišćina" },
            { "ff", "fulbšćina" },
            { "fi", "finšćina" },
            { "fj", "fidžišćina" },
            { "fo", "ferejšćina" },
            { "fr", "francojšćina" },
            { "fy", "frizišćina" },
            { "ga", "iršćina" },
            { "gd", "šotišćina" },
            { "gl", "galicišćina" },
            { "gn", "guarani" },
            { "gu", "gudžaratšćina" },
            { "gv", "manšćina" },
            { "ha", "hausa" },
            { "he", "hebrejšćina" },
            { "hi", "hindišćina" },
            { "hr", "chorwatšćina" },
            { "ht", "haitišćina" },
            { "hu", "hungoršćina" },
            { "hy", "armeńšćina" },
            { "hz", "hererošćina" },
            { "ia", "interlingua" },
            { "id", "indonešćina" },
            { "ie", "interlinguešćina" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "islandšćina" },
            { "it", "italšćina" },
            { "iu", "inuitšćina" },
            { "ja", "japańšćina" },
            { "jv", "javašćina" },
            { "ka", "georgišćina" },
            { "ki", "kikuyu" },
            { "kj", "kuanyamašćina" },
            { "kk", "kazachšćina" },
            { "kl", "grönlandšćina" },
            { "km", "kambodžanšćina" },
            { "kn", "kannadšćina" },
            { "ko", "korejańšćina" },
            { "kr", "kanurišćina" },
            { "ks", "kašmiršćina" },
            { "ku", "kurdišćina" },
            { "kv", "komišćina" },
            { "kw", "kornišćina" },
            { "ky", "kirgišćina" },
            { "la", "łatyńšćina" },
            { "lb", "luxemburgšćina" },
            { "lg", "gandšćina" },
            { "li", "limburšćina" },
            { "ln", "lingala" },
            { "lo", "laošćina" },
            { "lt", "litawšćina" },
            { "lu", "luba-katanga" },
            { "lv", "letišćina" },
            { "mg", "malgašćina" },
            { "mh", "marshallezišćina" },
            { "mi", "maorišćina" },
            { "mk", "makedońšćina" },
            { "ml", "malajamšćina" },
            { "mn", "mongolšćina" },
            { "mr", "maratišćina" },
            { "ms", "malajšćina" },
            { "mt", "maltašćina" },
            { "my", "burmašćina" },
            { "na", "naurušćina" },
            { "nb", "norwegske bokmål" },
            { "nd", "pódpołnocne ndebele" },
            { "ne", "nepalšćina" },
            { "ng", "ndongašćina" },
            { "nl", "nižozemšćina" },
            { "nn", "norwegske nynorsk" },
            { "no", "norwegšćina" },
            { "nr", "pódpołdnjowa ndebelšćina" },
            { "nv", "navaho" },
            { "ny", "nyanja" },
            { "oc", "okcitanšćina" },
            { "om", "oromo" },
            { "or", "orojišćina" },
            { "os", "osetšćina" },
            { "pa", "pandžabšćina" },
            { "pl", "pólšćina" },
            { "ps", "paštunšćina" },
            { "pt", "portugalšćina" },
            { "qu", "kečua" },
            { "rm", "retoromańšćina" },
            { "rn", "kirundišćina" },
            { "ro", "rumunšćina" },
            { "ru", "rušćina" },
            { "rw", "kinjarwanda" },
            { "sa", "sanskrit" },
            { "sc", "sardinšćina" },
            { "sd", "sindšćina" },
            { "se", "lapšćina" },
            { "sg", "sango" },
            { "sh", "serbochorwatšćina" },
            { "si", "singalšćina" },
            { "sk", "słowakšćina" },
            { "sl", "słowjeńšćina" },
            { "sm", "samošćina" },
            { "sn", "šonšćina" },
            { "so", "somališćina" },
            { "sq", "albanšćina" },
            { "sr", "serbišćina" },
            { "ss", "siswati" },
            { "st", "pódpołdnjowa sotšćina (Sesotho)" },
            { "su", "sundanšćina" },
            { "sv", "šwedšćina" },
            { "sw", "swahilišćina" },
            { "ta", "tamilšćina" },
            { "te", "telugšćina" },
            { "tg", "tadžikišćina" },
            { "th", "thailandšćina" },
            { "ti", "tigrinja" },
            { "tk", "turkmeńšćina" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tonganšćina" },
            { "tr", "turkojšćina" },
            { "ts", "tsonga" },
            { "tt", "tataršćina" },
            { "tw", "twi" },
            { "ty", "tahitišćina" },
            { "ug", "ujguršćina" },
            { "uk", "ukrainšćina" },
            { "ur", "urdušćina" },
            { "uz", "usbekšćina" },
            { "ve", "vendašćina" },
            { "vi", "vietnamšćina" },
            { "vo", "volapük" },
            { "wa", "walonšćina" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "jidišćina" },
            { "yo", "jorubšćina" },
            { "za", "zhuang" },
            { "zh", "chinšćina" },
            { "zu", "zulu" },
            { "ace", "achinezišćina" },
            { "ada", "adangmešćina" },
            { "ady", "adyghešćina" },
            { "agq", "aghem" },
            { "ain", "ainušćina" },
            { "ale", "aleutišćina" },
            { "alt", "pódpołdnjowa altaišćina" },
            { "ang", "anglosaksojšćina" },
            { "ann", "obološćina" },
            { "anp", "angikašćina" },
            { "arn", "arawkašćina" },
            { "arp", "arapahošćina" },
            { "ars", "najdi arabšćina" },
            { "asa", "pare" },
            { "ast", "asturšćina" },
            { "atj", "atikamekwišćina" },
            { "awa", "awandhišćina" },
            { "ban", "balinezišćina" },
            { "bas", "basaa" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgc", "haryanvišćina" },
            { "bho", "bhojpurišćina" },
            { "bin", "binišćina" },
            { "bla", "siksikášćina" },
            { "blo", "aniišćina" },
            { "brx", "bodo" },
            { "bug", "bugišćina" },
            { "byn", "blinšćina" },
            { "cay", "cayugašćina" },
            { "ccp", "čakma" },
            { "ceb", "cebuanšćina" },
            { "cgg", "chiga" },
            { "chk", "chuukezišćina" },
            { "chm", "marišćina" },
            { "cho", "choctawšćina" },
            { "chp", "chipewyanšćina" },
            { "chr", "cherokee" },
            { "chy", "cheyennešćina" },
            { "ckb", "sorani" },
            { "clc", "chilcotinšćina" },
            { "crg", "michifšćina" },
            { "crj", "krotkozajtšna creešćina" },
            { "crk", "plains creešćina" },
            { "crl", "dłujkozajtšna creešćina" },
            { "crm", "moode creešćina" },
            { "crr", "carolina algonquianšćina" },
            { "csw", "swampy creešćina" },
            { "dak", "dakotašćina" },
            { "dar", "dargwašćina" },
            { "dav", "taita" },
            { "dgr", "dogribšćina" },
            { "dje", "zarma" },
            { "doi", "dogrišćina" },
            { "dsb", "dolnoserbšćina" },
            { "dua", "duala" },
            { "dyo", "jola-fonyi" },
            { "dzg", "dazagašćina" },
            { "ebu", "embu" },
            { "efi", "efikšćina" },
            { "eka", "ekajukšćina" },
            { "ewo", "ewondo" },
            { "fil", "filipinšćina" },
            { "fon", "fonšćina" },
            { "frc", "cajun francojšćina" },
            { "frr", "pódpołnocna frizišćina" },
            { "fur", "friulšćina" },
            { "gaa", "gašćina" },
            { "gag", "gagauzšćina" },
            { "gez", "geezišćina" },
            { "gil", "gilbertezišćina" },
            { "gor", "gorontalošćina" },
            { "got", "gotišćina" },
            { "gsw", "šwicarska nimšćina" },
            { "guz", "gusii" },
            { "gwi", "gwichʼinšćina" },
            { "hai", "haidašćina" },
            { "haw", "hawaiišćina" },
            { "hax", "pódpołdnjowa haidašćina" },
            { "hil", "hiligaynonšćina" },
            { "hmn", "hmongšćina" },
            { "hsb", "górnoserbšćina" },
            { "hup", "hupašćina" },
            { "hur", "halkomelemšćina" },
            { "iba", "ibanšćina" },
            { "ibb", "ibibiošćina" },
            { "ikt", "pódwjacornokanadiska inuktitutšćina" },
            { "ilo", "ilokošćina" },
            { "inh", "ingushišćina" },
            { "jbo", "lojbanšćina" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kab", "kabylšćina" },
            { "kac", "kachinšćina" },
            { "kaj", "jjušćina" },
            { "kam", "kamba" },
            { "kbd", "kabardianšćina" },
            { "kcg", "tyapšćina" },
            { "kde", "makonde" },
            { "kea", "kapverdšćina" },
            { "kfo", "korošćina" },
            { "kgp", "kaingangšćina" },
            { "kha", "khasišćina" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundušćina" },
            { "koi", "komi-permyak" },
            { "kok", "konkani" },
            { "kpe", "kpellešćina" },
            { "krc", "karachay-balkaršćina" },
            { "krl", "karelianšćina" },
            { "kru", "kurukhšćina" },
            { "ksb", "šambala" },
            { "ksf", "bafia" },
            { "ksh", "kelnšćina" },
            { "kum", "kumykšćina" },
            { "kwk", "kwakʼwalašćina" },
            { "kxv", "kuvišćina" },
            { "lad", "ladinšćina" },
            { "lag", "langi" },
            { "lez", "lezgianšćina" },
            { "lij", "liguriańšćina" },
            { "lil", "lillooetšćina" },
            { "lkt", "lakotšćina" },
            { "lmo", "lombardišćina" },
            { "lou", "Louisiana kreolšćina" },
            { "loz", "lozišćina" },
            { "lrc", "pódpołnocna lurišćina" },
            { "lsm", "saamiašćina" },
            { "lua", "luba-luluašćina" },
            { "lun", "lundašćina" },
            { "lus", "mizošćina" },
            { "luy", "luhya" },
            { "mad", "madurezišćina" },
            { "mag", "magahišćina" },
            { "mai", "maithilšćina" },
            { "mak", "makasaršćina" },
            { "mas", "masaišćina" },
            { "mdf", "mokshašćina" },
            { "men", "mendišćina" },
            { "mer", "meru" },
            { "mfe", "mauriciska kreolšćina" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta’" },
            { "mic", "mi'kmaqšćina" },
            { "min", "minangkabaušćina" },
            { "mni", "manipuršćina" },
            { "moe", "innu-aimunšćina" },
            { "moh", "mohawkšćina" },
            { "mos", "mossišćina" },
            { "mua", "mundang" },
            { "mul", "wěcejrěcne" },
            { "mus", "krik" },
            { "mwl", "mirandezišćina" },
            { "myv", "erzyašćina" },
            { "mzn", "mazanderanšćina" },
            { "nap", "neapolitanšćina" },
            { "naq", "nama" },
            { "nds", "dolnonimšćina" },
            { "new", "newarišćina" },
            { "nia", "niazišćina" },
            { "niu", "niueanšćina" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogaišćina" },
            { "nqo", "n’ko" },
            { "nso", "połnocna sothošćina" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "ojb", "dłujkowjacorna ojibwašćina" },
            { "ojc", "centralna ojibwašćina" },
            { "ojs", "oji-creešćina" },
            { "ojw", "pódwjacorna ojibwašćina" },
            { "oka", "okanaganšćina" },
            { "pag", "pangasinanšćina" },
            { "pam", "pampangašćina" },
            { "pap", "papiamentošćina" },
            { "pau", "palauanšćina" },
            { "pcm", "nigerijanski pidgin" },
            { "pis", "pijinšćina" },
            { "pqm", "maliseet-passamaquoddyšćina" },
            { "prg", "prusčina" },
            { "quc", "kʼicheʼ" },
            { "raj", "rajasthanišćina" },
            { "rap", "rapanuišćina" },
            { "rar", "rarotonganšćina" },
            { "rhg", "rohingyašćina" },
            { "rof", "rombo" },
            { "rup", "armanianšćina" },
            { "rwk", "rwa" },
            { "sad", "sandawešćina" },
            { "sah", "jakutšćina" },
            { "saq", "samburu" },
            { "sat", "santalšćina" },
            { "sba", "ngambayšćina" },
            { "sbp", "sangu" },
            { "scn", "sicilianišćina" },
            { "sco", "scotšćina" },
            { "seh", "sena" },
            { "ses", "koyra senni" },
            { "shi", "tašelhit" },
            { "shn", "shanšćina" },
            { "slh", "pódpołdnjowa lushootseedšćina" },
            { "sma", "pódpołdnjowa samišćina" },
            { "smj", "lule-samišćina" },
            { "smn", "inari-samišćina" },
            { "sms", "skolt-samišćina" },
            { "snk", "soninkešćina" },
            { "srn", "sranan tongošćina" },
            { "stq", "saterfrizišćina" },
            { "str", "straits salishšćina" },
            { "suk", "sukumašćina" },
            { "swb", "comorianšćina" },
            { "syr", "syriacšćina" },
            { "szl", "šlazyńšćina" },
            { "tce", "pódpołdnjowa tutchonšćina" },
            { "tem", "timnešćina" },
            { "teo", "teso" },
            { "tet", "tetumšćina" },
            { "tgx", "tagishšćina" },
            { "tht", "tahltanšćina" },
            { "tig", "tigrešćina" },
            { "tlh", "klingonšćina" },
            { "tli", "tlingitšćina" },
            { "tok", "toki ponašćina" },
            { "tpi", "tok pisinšćina" },
            { "trv", "tarokošćina" },
            { "ttm", "połnocna tutchonšćina" },
            { "tum", "tumbukašćina" },
            { "tvl", "tuvalušćina" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinianšćina" },
            { "tzm", "centralnoatlaski tamazight" },
            { "udm", "udmurtšćina" },
            { "umb", "umbundušćina" },
            { "und", "njeznata rěc" },
            { "vec", "venetišćina" },
            { "vmw", "makhuwašćina" },
            { "vun", "vunjo" },
            { "wae", "walzeršćina" },
            { "wal", "wolayttašćina" },
            { "war", "warayšćina" },
            { "wuu", "wu chinšćina" },
            { "xal", "kalmykšćina" },
            { "xnr", "kangrišćina" },
            { "xog", "soga" },
            { "yav", "yangben" },
            { "ybb", "yembašćina" },
            { "yrl", "nheengatušćina" },
            { "yue", "kantonšćina" },
            { "zgh", "standardny marokkański tamazight" },
            { "zun", "zunišćina" },
            { "zxx", "žedno rěcne wopśimjeśe" },
            { "zza", "zazašćina" },
            { "Adlm", "adlamske pismo" },
            { "Arab", "arabski" },
            { "Aran", "nastaliqske pismo" },
            { "Armn", "armeński" },
            { "Beng", "bengalski" },
            { "Bopo", "bopomofo" },
            { "Brai", "braillowe pismo" },
            { "Cakm", "chakmaske pismo" },
            { "Cans", "zjadnotnjone kanadiske aboriginske złožkowe pismo" },
            { "Cher", "cherokeeske pismo" },
            { "Cyrl", "kyriliski" },
            { "Deva", "devanagari" },
            { "Ethi", "etiopiski" },
            { "Geor", "georgiski" },
            { "Grek", "grichiski" },
            { "Gujr", "gujarati" },
            { "Guru", "gurmukhi" },
            { "Hanb", "chinšćina z bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hans", "zjadnorjone" },
            { "Hant", "tradionalne" },
            { "Hebr", "hebrejski" },
            { "Hira", "hiragana" },
            { "Hrkt", "japańske złožkowe pismo" },
            { "Jamo", "jamo" },
            { "Jpan", "japański" },
            { "Kana", "katakana" },
            { "Khmr", "khmer" },
            { "Knda", "kannada" },
            { "Kore", "korejski" },
            { "Laoo", "laoski" },
            { "Latn", "łatyński" },
            { "Mlym", "malayalamski" },
            { "Mong", "mongolski" },
            { "Mtei", "meitei-mayekse pismo" },
            { "Mymr", "burmaski" },
            { "Nkoo", "n’Koske pismo" },
            { "Olck", "ol-chikiske pismo" },
            { "Orya", "oriya" },
            { "Rohg", "hanifiske pismo" },
            { "Sinh", "singhaleski" },
            { "Sund", "sundaneske pismo" },
            { "Syrc", "syriacske pismo" },
            { "Taml", "tamilski" },
            { "Telu", "telugu" },
            { "Tfng", "tifinanghske pismo" },
            { "Thaa", "thaana" },
            { "Thai", "thaiski" },
            { "Tibt", "tibetski" },
            { "Vaii", "vaiske pismo" },
            { "Yiii", "yiske pismo" },
            { "Zmth", "matematiski zapis" },
            { "Zsye", "emoji" },
            { "Zsym", "symbole" },
            { "Zxxx", "bźez pisma" },
            { "Zyyy", "powšykne" },
            { "Zzzz", "njeznate pismo" },
            { "de_AT", "awstriska nimšćina" },
            { "de_CH", "šwicarska wusokonimšćina" },
            { "en_AU", "awstralska engelšćina" },
            { "en_CA", "kanadiska engelšćina" },
            { "en_GB", "britiska engelšćina" },
            { "en_US", "ameriska engelšćina" },
            { "es_ES", "europejska špańšćina" },
            { "es_MX", "mexikańska špańšćina" },
            { "fa_AF", "dari" },
            { "fr_CA", "kanadiska francojšćina" },
            { "fr_CH", "šwicarska francojšćina" },
            { "nl_BE", "flamšćina" },
            { "pt_BR", "brazilska portugalšćina" },
            { "pt_PT", "europejska portugalšćina" },
            { "ro_MD", "moldawišćina" },
            { "sw_CD", "kongojska swahilišćina" },
            { "ar_001", "moderna wusokoarabšćina" },
            { "es_419", "łatyńskoamerikańska špańšćina" },
            { "key.ca", "kalender" },
            { "key.cf", "format płaśidła" },
            { "key.co", "sortěrowański slěd" },
            { "key.cu", "pjenjeze" },
            { "key.hc", "góźinowy cyklus (12 vs 24)" },
            { "key.lb", "system łamanja smužkow" },
            { "key.ms", "system měrow" },
            { "key.nu", "licby" },
            { "zh_Hans", "chinšćina (zjadnorjona)" },
            { "zh_Hant", "chinšćina (tradicionalna)" },
            { "type.ca.roc", "kalender republiki China" },
            { "type.hc.h11", "12-góźinowy cyklus (0-11)" },
            { "type.hc.h12", "12-góźinowy cyklus (1-12)" },
            { "type.hc.h23", "24-góźinowy cyklus (0-23)" },
            { "type.hc.h24", "24-góźinowy cyklus (1-24)" },
            { "type.nu.arab", "arabisko-indiske cyfry" },
            { "type.nu.armn", "armeńske cyfry" },
            { "type.nu.beng", "bengalske cyfry" },
            { "type.nu.cakm", "chakmaske cyfry" },
            { "type.nu.deva", "devanagari-cyfry" },
            { "type.nu.ethi", "etiopiske cyfry" },
            { "type.nu.geor", "georgiske cyfry" },
            { "type.nu.grek", "grichiske cyfry" },
            { "type.nu.gujr", "gujarati-cyfry" },
            { "type.nu.guru", "gurmukhi-cyfry" },
            { "type.nu.hans", "zjadnorjone chinske cyfry" },
            { "type.nu.hant", "tradicionalne chinske cyfry" },
            { "type.nu.hebr", "hebrejske cyfry" },
            { "type.nu.java", "javaske cyfry" },
            { "type.nu.jpan", "japańske cyfry" },
            { "type.nu.khmr", "khmerske cyfry" },
            { "type.nu.knda", "kannada-cyfry" },
            { "type.nu.laoo", "laotiske cyfry" },
            { "type.nu.latn", "arabiske cyfry" },
            { "type.nu.mlym", "malayalamske cyfry" },
            { "type.nu.mtei", "meetei-mayekske cyfry" },
            { "type.nu.mymr", "burmaske cyfry" },
            { "type.nu.olck", "ol-chikiske cyfry" },
            { "type.nu.orya", "oriya-cyfry" },
            { "type.nu.taml", "tradicionalne tamilske cyfry" },
            { "type.nu.telu", "telugu-cyfry" },
            { "type.nu.thai", "thaiske cyfry" },
            { "type.nu.tibt", "tibetske cyfry" },
            { "type.nu.vaii", "vaiske cyfry" },
            { "type.ca.dangi", "dangi kalender" },
            { "type.co.ducet", "sortěrowański slěd pó Unicoźe" },
            { "type.lb.loose", "lichy stil łamanja smužkow" },
            { "type.nu.roman", "romske cyfry" },
            { "type.ca.coptic", "koptiski kalendaŕ" },
            { "type.ca.hebrew", "žydojski kalender" },
            { "type.co.search", "powšykne pytanje" },
            { "type.lb.normal", "běžny stil łamanja smužkow" },
            { "type.lb.strict", "kšuty stil łamanja smužkow" },
            { "type.ms.metric", "metriski system" },
            { "type.ca.chinese", "chinski kalender" },
            { "type.ca.islamic", "islamski kalender" },
            { "type.ca.iso8601", "iso-8601-kalender" },
            { "type.ca.persian", "persiski kalender" },
            { "type.cf.account", "knigływjeźeński format płaśidła" },
            { "type.nu.arabext", "rozšyrjone arabisko-indiske cyfry" },
            { "type.nu.armnlow", "armeńske cyfry małopisane" },
            { "type.nu.greklow", "grichiske cyfry małopisane" },
            { "type.nu.hanidec", "chinske decimalne licby" },
            { "type.nu.hansfin", "zjadnorjone chinske financne cyfry" },
            { "type.nu.hantfin", "tradicionalne chinske financne cyfry" },
            { "type.nu.jpanfin", "japańske financne cyfry" },
            { "type.nu.tamldec", "tamilske cyfry" },
            { "type.ca.buddhist", "buddhistiski kalender" },
            { "type.ca.ethiopic", "etiopiski kalender" },
            { "type.ca.japanese", "japański kalender" },
            { "type.cf.standard", "standardny format płaśidła" },
            { "type.co.standard", "standardny sortěrowański slěd" },
            { "type.ms.uksystem", "britiski system měrow" },
            { "type.ms.ussystem", "amerikański system měrow" },
            { "type.nu.fullwide", "połnošyroke cyfry" },
            { "type.nu.romanlow", "romske cyfry małopisane" },
            { "type.ca.gregorian", "gregoriański kalender" },
            { "type.ca.islamic-civil", "islamski ciwilny kalendaŕ" },
            { "type.ca.islamic-umalqura", "islamski umalqui-kalendaŕ" },
            { "type.ca.ethiopic-amete-alem", "etiopiski amete-alem-kalendaŕ" },
        };
        return data;
    }
}
