/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.ToPlannedNodeConverter;
import org.gradle.initialization.DefaultPlannedTask;
import org.gradle.internal.taskgraph.CalculateTaskGraphBuildOperationType;
import org.gradle.internal.taskgraph.NodeIdentity;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ToPlannedTaskConverter
implements ToPlannedNodeConverter {
    @Override
    public Class<? extends Node> getSupportedNodeType() {
        return TaskNode.class;
    }

    @Override
    public NodeIdentity.NodeType getConvertedNodeType() {
        return NodeIdentity.NodeType.TASK;
    }

    public CalculateTaskGraphBuildOperationType.TaskIdentity getNodeIdentity(Node node) {
        TaskNode taskNode = (TaskNode)node;
        return new PlannedTaskIdentity(taskNode.getTask().getTaskIdentity());
    }

    @Override
    public boolean isInSamePlan(Node node) {
        return node instanceof LocalTaskNode;
    }

    @Override
    public DefaultPlannedTask convert(Node node, List<? extends NodeIdentity> nodeDependencies) {
        if (!this.isInSamePlan(node)) {
            throw new IllegalArgumentException("Cannot convert task from another plan: " + node);
        }
        LocalTaskNode taskNode = (LocalTaskNode)node;
        return new DefaultPlannedTask(this.getNodeIdentity(taskNode), nodeDependencies, this.getTaskIdentities(taskNode.getMustSuccessors()), this.getTaskIdentities(taskNode.getShouldSuccessors()), this.getTaskIdentities(taskNode.getFinalizers()));
    }

    private List<CalculateTaskGraphBuildOperationType.TaskIdentity> getTaskIdentities(Collection<Node> nodes) {
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        return nodes.stream().filter(TaskNode.class::isInstance).map(TaskNode.class::cast).map(this::getNodeIdentity).collect(Collectors.toList());
    }

    public String toString() {
        return "ToPlannedTaskConverter(" + this.getSupportedNodeType().getSimpleName() + ")";
    }

    private static class PlannedTaskIdentity
    implements CalculateTaskGraphBuildOperationType.TaskIdentity {
        private final TaskIdentity<?> delegate;

        public PlannedTaskIdentity(TaskIdentity<?> delegate) {
            this.delegate = delegate;
        }

        public NodeIdentity.NodeType getNodeType() {
            return NodeIdentity.NodeType.TASK;
        }

        public String getBuildPath() {
            return this.delegate.getBuildPath();
        }

        public String getTaskPath() {
            return this.delegate.getTaskPath();
        }

        public long getTaskId() {
            return this.delegate.getId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PlannedTaskIdentity)) {
                return false;
            }
            PlannedTaskIdentity that = (PlannedTaskIdentity)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }

        public String toString() {
            return "Task " + this.delegate.getIdentityPath();
        }
    }
}

