/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.dnd;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.swt.dnd.Transfer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.erd.DiagramCollectSettings;
import org.jkiss.dbeaver.model.erd.DiagramObjectCollector;
import org.jkiss.dbeaver.model.erd.ERDDiagram;
import org.jkiss.dbeaver.model.erd.ERDEntity;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dnd.DatabaseObjectTransfer;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ui.editors.erd.model.DiagramCollectSettingsDefault;
import org.jkiss.dbeaver.ui.editors.erd.part.DiagramPart;

public class NodeDropTargetListener
extends AbstractTransferDropTargetListener {
    public NodeDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)DatabaseObjectTransfer.getInstance());
    }

    protected void updateTargetRequest() {
    }

    protected Request createTargetRequest() {
        CreateRequest request = new CreateRequest();
        request.setFactory(new CreationFactory(){

            public Object getNewObject() {
                final Collection objects = (Collection)DatabaseObjectTransfer.getInstance().getObject();
                final ERDEditorPart editor = ((DiagramPart)NodeDropTargetListener.this.getViewer().getRootEditPart().getContents()).getEditor();
                if (objects == null) {
                    return null;
                }
                DBRRunnableWithResult<List<ERDEntity>> collector = new DBRRunnableWithResult<List<ERDEntity>>(){

                    public void run(DBRProgressMonitor monitor) {
                        this.result = DiagramObjectCollector.generateEntityList((DBRProgressMonitor)monitor, (ERDDiagram)editor.getDiagram(), (DBPProject)editor.getDiagramProject(), (Collection)objects, (DiagramCollectSettings)new DiagramCollectSettingsDefault(), (boolean)true, (boolean)editor.isERD());
                    }
                };
                try {
                    UIUtils.runInProgressService((DBRRunnableWithProgress)collector);
                }
                catch (InvocationTargetException e) {
                    DBWorkbench.getPlatformUI().showError("Entity collect error", "Error during diagram entities collect", (Throwable)e);
                }
                catch (InterruptedException interruptedException) {}
                List errorMessages = editor.getDiagram().getErrorMessages();
                if (!errorMessages.isEmpty()) {
                    ArrayList<Status> statuses = new ArrayList<Status>(errorMessages.size());
                    for (String error : errorMessages) {
                        statuses.add(new Status(4, "org.jkiss.dbeaver.ui.editors.erd", error));
                    }
                    DBWorkbench.getPlatformUI().showError("Diagram request error", "Error(s) occurred during diagram request. If these errors are recoverable then fix errors and then repeat request", (IStatus)new MultiStatus("org.jkiss.dbeaver.ui.editors.erd", 0, statuses.toArray(new IStatus[0]), null, null));
                    editor.getDiagram().clearErrorMessages();
                }
                return collector.getResult();
            }

            public Object getObjectType() {
                return "create child";
            }
        });
        request.setLocation(this.getDropLocation());
        return request;
    }
}

