/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class GenericMetaModelDescriptor
extends AbstractDescriptor {
    private IConfigurationElement contributorConfig;
    private AbstractDescriptor.ObjectType implType;
    private GenericMetaModel instance;
    private String id;
    private final Map<String, GenericMetaObject> objects = new HashMap<String, GenericMetaObject>();
    private String[] driverClass;
    private final String dialectId;
    private List<String> modelReplacements;

    public GenericMetaModelDescriptor() {
        super("org.jkiss.dbeaver.ext.generic");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, GenericMetaModel.class.getName());
        this.instance = new GenericMetaModel();
        this.instance.descriptor = this;
        this.dialectId = "generic";
    }

    public GenericMetaModelDescriptor(IConfigurationElement cfg) {
        super(cfg);
        IConfigurationElement[] replaceElements;
        String driverClassList;
        this.contributorConfig = cfg;
        this.id = cfg.getAttribute("id");
        Object[] objectList = cfg.getChildren("object");
        if (!ArrayUtils.isEmpty((Object[])objectList)) {
            Object[] objectArray = objectList;
            int n = objectList.length;
            int n2 = 0;
            while (n2 < n) {
                Object childConfig = objectArray[n2];
                GenericMetaObject metaObject = new GenericMetaObject((IConfigurationElement)childConfig);
                this.objects.put(metaObject.getType(), metaObject);
                ++n2;
            }
        }
        this.driverClass = CommonUtils.isEmpty((String)(driverClassList = cfg.getAttribute("driverClass"))) ? new String[0] : driverClassList.split(",");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, cfg.getAttribute("class"));
        this.dialectId = CommonUtils.toString((Object)cfg.getAttribute("dialect"), (String)"generic");
        IConfigurationElement[] iConfigurationElementArray = replaceElements = cfg.getChildren("replace");
        int n = replaceElements.length;
        int n3 = 0;
        while (n3 < n) {
            IConfigurationElement replace = iConfigurationElementArray[n3];
            String modelId = replace.getAttribute("model");
            if (this.modelReplacements == null) {
                this.modelReplacements = new ArrayList<String>();
            }
            this.modelReplacements.add(modelId);
            ++n3;
        }
    }

    public String getId() {
        return this.id;
    }

    @NotNull
    public String[] getDriverClass() {
        return this.driverClass;
    }

    public GenericMetaObject getObject(String id) {
        return this.objects.get(id);
    }

    public SQLDialectMetadata getDialect() {
        return DBWorkbench.getPlatform().getSQLDialectRegistry().getDialect(this.dialectId);
    }

    public List<String> getModelReplacements() {
        return CommonUtils.safeList(this.modelReplacements);
    }

    public void setModelReplacements(List<String> modelReplacements) {
        this.modelReplacements = modelReplacements;
    }

    public GenericMetaModel getInstance() throws DBException {
        if (this.instance != null) {
            return this.instance;
        }
        Class implClass = this.implType.getImplClass(GenericMetaModel.class);
        try {
            this.instance = (GenericMetaModel)implClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new DBException("Can't instantiate meta model", e);
        }
        this.instance.descriptor = this;
        return this.instance;
    }
}

