import { FieldValues, RegisterOptions, UseFormReturn } from "react-hook-form";
export type TFormControl<T> = {
    inputProps?: Partial<T>;
    validation?: RegisterOptions["validate"];
    name: string;
    onChange?: (val: string) => void;
    error?: string;
};
export type TFormValue = string | number | Date;
export type ThandleSubmit<TFormData extends FieldValues> = (values: TFormData, form: UseFormReturn<TFormData, any, TFormData>) => void;
export type THandleFormResponseError<TResponseErrorPayload, TTransformedFormFields, TFormFields> = (error: TFormResponseError<TResponseErrorPayload>, payloadTransformed: TTransformedFormFields, payload: TFormFields) => void;
export type TMutateFnReturn<TResponseData = unknown, TResponseErrorPayload = unknown> = TFormResponseError<TResponseErrorPayload> & {
    data: TResponseData;
};
export type TFormResponseError<TResponseErrorPayload = unknown> = {
    fieldErrors?: TErrors;
    mainError?: string;
    originalError?: TResponseErrorPayload;
};
export type TError = string;
export type TErrors = Record<string, TError>;
export type TErrorContext = {
    errors: TErrors;
};
export declare enum EActionRequestResultMessage {
    FIELD_ERRORS = "Field errors"
}
export declare enum EActionRequestResultStatus {
    BAD_REQUEST = "BAD_REQUEST"
}
//# sourceMappingURL=types.d.ts.map