import{jsx as _jsx,jsxs as _jsxs,Fragment as _Fragment}from"react/jsx-runtime";import React,{useCallback,useEffect,useMemo,useState}from"react";import{Filter,Trash2}from"lucide-react";import classes from"./RemotePersistentFilterDropdown.module.css";import{Combobox,Group,useCombobox}from"@mantine/core";import{useTranslation}from"react-i18next";import{Tooltip}from"../../Tooltip";import{ConfirmationDialog}from"../../ConfirmationDialog";import{EStatus}from"../../../genericTypes";import{Typo}from"../../Typo";import{Z_INDEX_LAYER}from"../../../theme";const RemotePersistentFilterDropdown=({remotePersistentFilters,onSelect,onDelete})=>{const{t}=useTranslation();const[selectedFilter,setSelectedFilter]=useState();const[modalData,setModalData]=useState(null);const combobox=useCombobox();const dropdownList=useMemo(()=>remotePersistentFilters.map(filter=>({value:filter.id,label:filter.filterName})),[remotePersistentFilters]);const handleClick=()=>combobox.toggleDropdown();useEffect(()=>{if(selectedFilter)onSelect(selectedFilter)},[selectedFilter,onSelect]);const handleSelect=useCallback(filter=>{if(filter){combobox.closeDropdown();setSelectedFilter(filter)}},[combobox]);const handleDelete=useCallback((e,filterId)=>{e.stopPropagation();setModalData(filterId)},[]);const handleConfirmDelete=useCallback(()=>{if(modalData){onDelete(modalData);setModalData(null)}},[modalData,onDelete]);const options=useMemo(()=>dropdownList.sort((a,b)=>a.label.localeCompare(b.label)).map(item=>_jsx(Combobox.Option,{"data-testid":"dropdown-option",value:item.value,children:_jsxs(Group,{className:classes.options,children:[item.label.length>35?_jsx(Tooltip,{label:item.label,children:_jsx("span",{className:classes["truncate-text"],children:item.label})}):_jsx("span",{children:item.label}),_jsx(Tooltip,{label:t("Delete filter"),children:_jsx(Trash2,{"data-testid":"delete-icon",color:"red",size:16,className:classes["options-label"],onClick:e=>handleDelete(e,item.value)})})]})},item.value)),[dropdownList,handleDelete,t]);const emptyOption=_jsx(Combobox.Option,{value:"",children:_jsx(Group,{className:classes.options,children:_jsx("span",{children:t("No saved filters available")})})},"");return _jsxs(_Fragment,{children:[_jsxs(Combobox,{store:combobox,width:300,position:"bottom-start",withArrow:true,onOptionSubmit:handleSelect,styles:{dropdown:{zIndex:Z_INDEX_LAYER.GROUND.HIGHEST,maxHeight:"238px",overflow:"auto"}},children:[_jsx(Combobox.Target,{children:_jsx("div",{"data-testid":"filter-icon",className:classes.actions,onClick:handleClick,children:_jsx(Tooltip,{offset:15,label:t("Saved filters"),children:_jsx(Filter,{"data-testid":"filter-chevron-image",color:"var(--filter-chevron-color)",size:16})})})}),_jsx(Combobox.Dropdown,{children:_jsx(Combobox.Options,{children:options.length>0?options:emptyOption})})]}),_jsx(ConfirmationDialog,{alertStatus:EStatus.ERROR,title:t("Delete filter"),content:_jsx(Typo,{type:"body",children:t("Do you really want to delete this filter?")}),opened:!!modalData,onClose:()=>setModalData(null),confirmationButtonText:t("Confirm"),confirmationButtonVariant:"danger",cancelButtonText:t("Cancel"),onSubmit:handleConfirmDelete})]})};export{RemotePersistentFilterDropdown};
//# sourceMappingURL=RemotePersistentFilterDropdown.js.map