/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.impl.ChangesBrowserToolWindowTreeEditorDiffPreview;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/vcs/impl/ChangesBrowserToolWindow;", "", "<init>", "()V", "TOOLWINDOW_ID", "", "showTab", "", "project", "Lcom/intellij/openapi/project/Project;", "content", "Lcom/intellij/ui/content/Content;", "createDiffPreview", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "changesBrowser", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserBase;", "disposable", "Lcom/intellij/openapi/Disposable;", "registerRepositoriesToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "getIcon", "Ljavax/swing/Icon;", "intellij.platform.vcs.impl"})
public final class ChangesBrowserToolWindow {
    @NotNull
    public static final ChangesBrowserToolWindow INSTANCE = new ChangesBrowserToolWindow();
    @NotNull
    public static final String TOOLWINDOW_ID = "VcsChanges";

    private ChangesBrowserToolWindow() {
    }

    @JvmStatic
    public static final void showTab(@NotNull Project project, @NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            toolWindow = INSTANCE.registerRepositoriesToolWindow(toolWindowManager);
        }
        ToolWindow repoToolWindow = toolWindow;
        content.putUserData(Content.SIMPLIFIED_TAB_RENDERING_KEY, (Object)true);
        repoToolWindow.getContentManager().removeAllContents(true);
        repoToolWindow.getContentManager().addContent(content);
        repoToolWindow.activate(null);
    }

    @JvmStatic
    @NotNull
    public static final DiffPreview createDiffPreview(@NotNull Project project, @NotNull ChangesBrowserBase changesBrowser, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)changesBrowser, (String)"changesBrowser");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ChangesTree changesTree = changesBrowser.getViewer();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)changesTree), (String)"getViewer(...)");
        ChangesBrowserToolWindowTreeEditorDiffPreview preview = new ChangesBrowserToolWindowTreeEditorDiffPreview(changesTree);
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)preview));
        return (DiffPreview)preview;
    }

    private final ToolWindow registerRepositoriesToolWindow(ToolWindowManager toolWindowManager) {
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"LEFT");
        ToolWindowAnchor toolWindowAnchor2 = toolWindowAnchor;
        Supplier supplier = VcsBundle.messagePointer((String)"ChangesBrowserToolWindow.toolwindow.name", (Object[])new Object[0]);
        Icon icon = this.getIcon();
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(new RegisterToolWindowTask(TOOLWINDOW_ID, toolWindowAnchor2, null, false, true, false, false, null, icon, supplier, 236, null));
        toolWindow.getComponent().putClientProperty("HideIdLabel", "true");
        ContentManagerWatcher.watchContentManager((ToolWindow)toolWindow, (ContentManager)toolWindow.getContentManager());
        return toolWindow;
    }

    private final Icon getIcon() {
        return ExperimentalUI.Companion.isNewUI() ? AllIcons.Toolwindows.Changes : null;
    }
}

