/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.go;

import com.goide.sdk.GoSdkService;
import com.goide.util.GoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.mod.psi.VgoRequireDirective;
import com.goide.vgo.project.VgoDependency;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.PackageType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0003\n\u0000\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0006\u001a\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0018\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0000\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "toPackage", "Lorg/jetbrains/security/package/Package;", "Lcom/goide/vgo/project/VgoDependency;", "Lcom/goide/vgo/mod/psi/VgoModuleSpec;", "getDependencies", "", "modFile", "Lcom/intellij/psi/PsiFile;", "getModuleRoot", "project", "Lcom/intellij/openapi/project/Project;", "dependency", "isEnabled", "", "file", "module", "Lcom/intellij/openapi/module/Module;", "ifClassesLoaded", "condition", "Lkotlin/Function0;", "report", "", "", "intellij.packageChecker.go"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\ncom/intellij/packageChecker/go/UtilsKt\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n436#2:65\n436#2:69\n1368#3:66\n1454#3,2:67\n1456#3,3:70\n1#4:73\n*S KotlinDebug\n*F\n+ 1 utils.kt\ncom/intellij/packageChecker/go/UtilsKt\n*L\n34#1:65\n35#1:69\n35#1:66\n35#1:67,2\n35#1:70,3\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final Package toPackage(@NotNull VgoDependency $this$toPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$toPackage, (String)"<this>");
        String string = $this$toPackage.getVersion();
        if (string == null) {
            return null;
        }
        String version = string;
        String string2 = $this$toPackage.getImportPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getImportPath(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return new Package(PackageType.go, null, string3, version, null, null, null, 112, null);
    }

    @Nullable
    public static final Package toPackage(@NotNull VgoModuleSpec $this$toPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$toPackage, (String)"<this>");
        PsiElement psiElement = $this$toPackage.getModuleVersion();
        if (psiElement == null) {
            return null;
        }
        PsiElement version = psiElement;
        String string = $this$toPackage.getIdentifier().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = version.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        return new Package(PackageType.go, null, string2, string3, null, null, null, 112, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VgoModuleSpec> getDependencies(@NotNull PsiFile modFile) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)modFile, (String)"modFile");
        PsiElement $this$childrenOfType$iv = (PsiElement)modFile;
        boolean $i$f$childrenOfType = false;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, VgoRequireDirective.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            VgoRequireDirective it = (VgoRequireDirective)element$iv$iv;
            boolean bl = false;
            PsiElement $this$childrenOfType$iv2 = (PsiElement)it;
            boolean $i$f$childrenOfType2 = false;
            List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv2, VgoModuleSpec.class);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final PsiFile getModuleRoot(@NotNull Project project, @NotNull VgoDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        VirtualFile virtualFile = dependency.getRoot();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        VirtualFile virtualFile2 = root.findChild("go.mod");
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile modFile = virtualFile2;
        return PsiManager.getInstance((Project)project).findFile(modFile);
    }

    public static final boolean isEnabled(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilsKt.ifClassesLoaded((Function0<Boolean>)((Function0)() -> UtilsKt.isEnabled$lambda$2(file)));
    }

    public static final boolean isEnabled(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return UtilsKt.ifClassesLoaded((Function0<Boolean>)((Function0)() -> UtilsKt.isEnabled$lambda$3(module)));
    }

    public static final boolean ifClassesLoaded(@NotNull Function0<Boolean> condition) {
        boolean bl;
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        try {
            bl = (Boolean)condition.invoke();
        }
        catch (NoClassDefFoundError e) {
            UtilsKt.report(e);
            bl = false;
        }
        catch (ClassNotFoundException e) {
            UtilsKt.report(e);
            bl = false;
        }
        return bl;
    }

    private static final void report(Throwable $this$report) {
        LOG.warn("Unable to load classes, probably due to dynamically loaded Go plugin, please restart IDE: " + $this$report.getMessage(), $this$report);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isEnabled$lambda$2(PsiFile $file) {
        if (!($file instanceof VgoFile)) return false;
        if (!Intrinsics.areEqual((Object)((VgoFile)$file).getName(), (Object)"go.mod")) return false;
        Module module = GoUtil.module((PsiElement)((PsiElement)$file));
        if (module == null) return false;
        Module it = module;
        boolean bl = false;
        if (!UtilsKt.isEnabled(it)) return false;
        return true;
    }

    private static final boolean isEnabled$lambda$3(Module $module) {
        return GoSdkService.getInstance((Project)$module.getProject()).isGoModule($module) && VgoProjectSettings.getInstance((Project)$module.getProject()).isIntegrationEnabled();
    }

    static {
        Logger logger = Logger.getInstance((String)"#org.jetbrains.security.extension.go");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

