/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.images.editor;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlTokenType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.images.MarkdownImagesBundle;
import org.intellij.plugins.markdown.images.editor.ConfigureImageDialog;
import org.intellij.plugins.markdown.images.editor.ConfigureImageLineMarkerProviderBase;
import org.intellij.plugins.markdown.images.editor.ImageUtils;
import org.intellij.plugins.markdown.images.editor.MarkdownImageData;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\bH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0015\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/images/editor/ConfigureHtmlImageLineMarkerProvider;", "Lorg/intellij/plugins/markdown/images/editor/ConfigureImageLineMarkerProviderBase;", "Lcom/intellij/psi/html/HtmlTag;", "<init>", "()V", "getName", "", "obtainLeafElement", "Lcom/intellij/psi/PsiElement;", "element", "obtainOuterElement", "obtainPathText", "createDialog", "Lorg/intellij/plugins/markdown/images/editor/ConfigureImageDialog;", "applyChanges", "", "imageData", "Lorg/intellij/plugins/markdown/images/editor/MarkdownImageData;", "updateAttributes", "image", "convertToMarkdown", "setAttributeIfNotEmpty", "attributeName", "value", "Companion", "intellij.markdown.images"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nConfigureHtmlImageLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureHtmlImageLineMarkerProvider.kt\norg/intellij/plugins/markdown/images/editor/ConfigureHtmlImageLineMarkerProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class ConfigureHtmlImageLineMarkerProvider
extends ConfigureImageLineMarkerProviderBase<HtmlTag> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getName() {
        return MarkdownImagesBundle.INSTANCE.message("markdown.configure.html.image.line.marker.provider.name", new Object[0]);
    }

    @Override
    @Nullable
    public PsiElement obtainLeafElement(@NotNull PsiElement element2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiFile psiFile = element2.getContainingFile();
        if (!Intrinsics.areEqual((Object)(psiFile != null && (psiFile = psiFile.getViewProvider()) != null ? psiFile.getBaseLanguage() : null), (Object)((Object)MarkdownLanguage.INSTANCE))) {
            return null;
        }
        PsiElement it = psiElement = element2;
        boolean bl = false;
        return Companion.getImageByNameElement(element2) != null ? psiElement : null;
    }

    @Override
    @Nullable
    public HtmlTag obtainOuterElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof HtmlTag && Intrinsics.areEqual((Object)((HtmlTag)element2).getName(), (Object)"img")) {
            return (HtmlTag)element2;
        }
        return Companion.getImageByNameElement(element2);
    }

    @Override
    @Nullable
    public String obtainPathText(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        HtmlTag htmlTag = this.obtainOuterElement(element2);
        return htmlTag != null ? htmlTag.getAttributeValue("src") : null;
    }

    @Override
    @NotNull
    public ConfigureImageDialog createDialog(@NotNull HtmlTag element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return new ConfigureImageDialog(element2.getProject(), MarkdownImagesBundle.INSTANCE.message("markdown.configure.image.title.text", new Object[0]), this.obtainPathText((PsiElement)element2), element2.getAttributeValue("width"), element2.getAttributeValue("height"), element2.getAttributeValue("title"), element2.getAttributeValue("alt"), true);
    }

    @Override
    public void applyChanges(@NotNull PsiElement element2, @NotNull MarkdownImageData imageData) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        HtmlTag htmlTag = this.obtainOuterElement(element2);
        if (htmlTag == null) {
            return;
        }
        HtmlTag image = htmlTag;
        if (imageData.getShouldConvertToHtml()) {
            this.updateAttributes(image, imageData);
        } else {
            this.convertToMarkdown(image, imageData);
        }
    }

    private final void updateAttributes(HtmlTag image, MarkdownImageData imageData) {
        Runnable action = () -> ConfigureHtmlImageLineMarkerProvider.updateAttributes$lambda$1(this, image, imageData);
        WriteCommandAction.runWriteCommandAction((Project)image.getProject(), (String)MarkdownImagesBundle.INSTANCE.message("markdown.configure.image.line.marker.update.html.image.attributes.command.name", new Object[0]), null, (Runnable)action, (PsiFile[])new PsiFile[0]);
    }

    private final void convertToMarkdown(HtmlTag image, MarkdownImageData imageData) {
        Runnable action = () -> ConfigureHtmlImageLineMarkerProvider.convertToMarkdown$lambda$2(imageData, image);
        WriteCommandAction.runWriteCommandAction((Project)image.getProject(), (String)MarkdownImagesBundle.INSTANCE.message("markdown.configure.image.line.marker.convert.html.to.markdown.command.name", new Object[0]), null, (Runnable)action, (PsiFile[])new PsiFile[0]);
    }

    private final void setAttributeIfNotEmpty(HtmlTag $this$setAttributeIfNotEmpty, String attributeName, String value) {
        if (((CharSequence)value).length() == 0 && $this$setAttributeIfNotEmpty.getAttribute(attributeName) == null) {
            return;
        }
        $this$setAttributeIfNotEmpty.setAttribute(attributeName, value);
    }

    private static final void updateAttributes$lambda$1(ConfigureHtmlImageLineMarkerProvider this$0, HtmlTag $image, MarkdownImageData $imageData) {
        this$0.setAttributeIfNotEmpty($image, "src", $imageData.getPath());
        this$0.setAttributeIfNotEmpty($image, "width", $imageData.getWidth());
        this$0.setAttributeIfNotEmpty($image, "height", $imageData.getHeight());
        this$0.setAttributeIfNotEmpty($image, "title", $imageData.getTitle());
        this$0.setAttributeIfNotEmpty($image, "alt", $imageData.getDescription());
    }

    private static final void convertToMarkdown$lambda$2(MarkdownImageData $imageData, HtmlTag $image) {
        String text2 = ImageUtils.createMarkdownImageText($imageData.getDescription(), $imageData.getPath(), $imageData.getTitle());
        XmlElementFactory.getInstance((Project)$image.getProject()).createDisplayText(text2);
        $image.replace((PsiElement)XmlElementFactory.getInstance((Project)$image.getProject()).createDisplayText(text2));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/images/editor/ConfigureHtmlImageLineMarkerProvider$Companion;", "", "<init>", "()V", "isImgTagName", "", "element", "Lcom/intellij/psi/PsiElement;", "getImageByNameElement", "Lcom/intellij/psi/html/HtmlTag;", "intellij.markdown.images"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isImgTagName(PsiElement element2) {
            return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element2), (Object)XmlTokenType.XML_NAME) && Intrinsics.areEqual((Object)element2.getText(), (Object)"img");
        }

        @Nullable
        public final HtmlTag getImageByNameElement(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            if (!this.isImgTagName(element2)) {
                return null;
            }
            PsiElement psiElement = element2.getParent();
            return psiElement instanceof HtmlTag ? (HtmlTag)psiElement : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

