/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.sqlite.AlreadyClosedException;
import org.jetbrains.sqlite.Binder;
import org.jetbrains.sqlite.NativeDB;
import org.jetbrains.sqlite.SQLiteConfig;
import org.jetbrains.sqlite.SQLiteOpenMode;
import org.jetbrains.sqlite.SqlStatementPool;
import org.jetbrains.sqlite.SqliteConnectionKt;
import org.jetbrains.sqlite.SqliteDbKt;
import org.jetbrains.sqlite.SqliteLibLoaderKt;
import org.jetbrains.sqlite.SqlitePreparedStatement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001b\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ.\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0012\"\b\b\u0000\u0010\u0014*\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0019J<\u0010\u001a\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142!\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u0002H\u00140\u001cH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b \u0010!J\b\u0010\"\u001a\u00020\u000bH\u0002J\u001f\u0010#\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0019\u00a2\u0006\u0002\u0010$J-\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00140&\"\b\b\u0000\u0010\u0014*\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010'\u001a\u0002H\u0014\u00a2\u0006\u0002\u0010(J+\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00140&\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u0002H\u0014\u00a2\u0006\u0002\u0010+J\u001c\u0010,\u001a\u00020\u00062\b\b\u0001\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.J\u001e\u0010/\u001a\u0004\u0018\u00010\u00172\b\b\u0001\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.J#\u00100\u001a\u0004\u0018\u0001012\b\b\u0001\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.\u00a2\u0006\u0002\u00102Ju\u00103\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0016\u001a\u00020*2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.2K\u00104\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u001106\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(7\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(8\u0012\u0004\u0012\u0002H\u001405H\u0082\b\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u00020;2\b\b\u0001\u0010\u0016\u001a\u00020\u0017J\u0018\u0010:\u001a\u00020;2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.J\u0006\u0010<\u001a\u000201J\u0006\u0010=\u001a\u00020;J\b\u0010>\u001a\u00020;H\u0016J\u0010\u0010?\u001a\u00020;2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u0006\u0010@\u001a\u00020;J\u0006\u0010A\u001a\u00020;J\u0006\u0010B\u001a\u00020;R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006C"}, d2={"Lorg/jetbrains/sqlite/SqliteConnection;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "file", "Ljava/nio/file/Path;", "readOnly", "", "<init>", "(Ljava/nio/file/Path;Z)V", "dbRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/sqlite/NativeDB;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "isClosed", "()Z", "statementPoolList", "", "Lorg/jetbrains/sqlite/SqlStatementPool;", "statementPool", "T", "Lorg/jetbrains/sqlite/Binder;", "sql", "", "binderProducer", "Lkotlin/Function0;", "useDb", "task", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "db", "useDb$intellij_platform_sqlite", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getDb", "withSavePoint", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "prepareStatement", "Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "binder", "(Ljava/lang/String;Lorg/jetbrains/sqlite/Binder;)Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "sqlUtf8", "", "([BLorg/jetbrains/sqlite/Binder;)Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "selectBoolean", "values", "", "selectString", "selectInt", "", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Integer;", "executeLifecycle", "executor", "Lkotlin/Function3;", "", "statementPointer", "empty", "([BLjava/lang/Object;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "execute", "", "affectedRows", "interruptAndClose", "close", "doClose", "beginTransaction", "commit", "rollback", "intellij.platform.sqlite"})
@SourceDebugExtension(value={"SMAP\nSqliteConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteConnection.kt\norg/jetbrains/sqlite/SqliteConnection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,300:1\n67#1,6:302\n67#1,6:308\n67#1,6:314\n67#1,6:320\n67#1,6:326\n67#1,6:332\n67#1,6:338\n139#1:344\n67#1,6:345\n140#1,8:351\n139#1:359\n67#1,6:360\n140#1,8:366\n139#1:374\n67#1,6:375\n140#1,8:381\n67#1,6:389\n67#1,6:395\n139#1:401\n67#1,6:402\n140#1,8:408\n67#1,6:416\n67#1,6:422\n67#1,6:428\n1#2:301\n*S KotlinDebug\n*F\n+ 1 SqliteConnection.kt\norg/jetbrains/sqlite/SqliteConnection\n*L\n87#1:302,6\n96#1:308,6\n99#1:314,6\n96#1:320,6\n99#1:326,6\n96#1:332,6\n99#1:338,6\n113#1:344\n113#1:345,6\n113#1:351,8\n125#1:359\n125#1:360,6\n125#1:366,8\n131#1:374\n131#1:375,6\n131#1:381,8\n139#1:389,6\n153#1:395,6\n157#1:401\n157#1:402,6\n157#1:408,8\n215#1:416,6\n219#1:422,6\n223#1:428,6\n*E\n"})
public final class SqliteConnection
implements AutoCloseable {
    @NotNull
    private final AtomicReference<NativeDB> dbRef;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final List<SqlStatementPool<?>> statementPoolList;

    public SqliteConnection(@Nullable Path file, boolean readOnly) {
        int status;
        this.dbRef = new AtomicReference();
        this.lock = new ReentrantLock();
        this.statementPoolList = new ArrayList();
        Path path = file;
        if (path != null && (path = path.getParent()) != null) {
            Path it = path;
            boolean bl = false;
            Files.createDirectories(it, new FileAttribute[0]);
        }
        SqliteLibLoaderKt.loadNativeDb();
        NativeDB db = new NativeDB();
        Path path2 = file;
        String filePath = path2 != null && (path2 = path2.toAbsolutePath()) != null && (path2 = path2.normalize()) != null ? ((Object)path2).toString() : null;
        String string = filePath;
        if (string == null) {
            string = ":memory:";
        }
        if ((status = db.open(string, readOnly ? SQLiteOpenMode.READONLY.flag : SQLiteOpenMode.READWRITE.flag | SQLiteOpenMode.CREATE.flag) & 0xFF) != 0) {
            String string2 = filePath;
            if (string2 == null) {
                string2 = "";
            }
            throw SqliteDbKt.newException(status, string2, null);
        }
        try {
            new SQLiteConfig().apply$intellij_platform_sqlite(db);
        }
        catch (Throwable e) {
            try {
                db.close();
            }
            catch (Throwable closeException) {
                ExceptionsKt.addSuppressed((Throwable)e, (Throwable)closeException);
            }
            throw e;
        }
        this.dbRef.set(db);
    }

    public /* synthetic */ SqliteConnection(Path path, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(path, bl);
    }

    public final boolean isClosed() {
        return this.dbRef.get() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T extends Binder> SqlStatementPool<T> statementPool(@Language(value="SQLite") @NotNull String sql2, @NotNull Function0<? extends T> binderProducer) {
        SqlStatementPool<? extends T> sqlStatementPool;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Intrinsics.checkNotNullParameter(binderProducer, (String)"binderProducer");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            SqlStatementPool<? extends T> pool = new SqlStatementPool<T>(sql2, this, binderProducer);
            this.statementPoolList.add(pool);
            sqlStatementPool = pool;
        }
        finally {
            lock.unlock();
        }
        return sqlStatementPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T useDb$intellij_platform_sqlite(@NotNull Function1<? super NativeDB, ? extends T> task) {
        Object object;
        Intrinsics.checkNotNullParameter(task, (String)"task");
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            object = task.invoke((Object)this.getDb());
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart((int)1);
            lock.unlock();
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)2);
        lock.unlock();
        InlineMarker.finallyEnd((int)2);
        return (T)object;
    }

    private final NativeDB getDb() {
        NativeDB nativeDB = this.dbRef.get();
        if (nativeDB == null) {
            throw new AlreadyClosedException();
        }
        return nativeDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withSavePoint(@NotNull Function0<? extends T> task) {
        NativeDB it;
        Intrinsics.checkNotNullParameter(task, (String)"task");
        String name = "p" + SqliteConnectionKt.access$getSavepointNameGenerator$p().getAndIncrement() + "_" + Long.toUnsignedString(System.currentTimeMillis(), 36);
        SqliteConnection this_$iv = this;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this_$iv.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Object object = this_$iv.lock;
        object.lock();
        try {
            boolean bl = false;
            NativeDB it2 = this_$iv.getDb();
            boolean bl2 = false;
            byte[] byArray = ("savepoint " + name).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            it2.exec(byArray);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            object.unlock();
        }
        boolean ok = false;
        try {
            Object result2 = task.invoke();
            ok = true;
            object = result2;
        }
        catch (Throwable throwable) {
            if (ok) {
                SqliteConnection this_$iv2 = this;
                boolean $i$f$useDb$intellij_platform_sqlite2 = false;
                if (this_$iv2.dbRef.get() == null) {
                    throw new AlreadyClosedException();
                }
                Lock lock = this_$iv2.lock;
                lock.lock();
                try {
                    boolean bl = false;
                    it = this_$iv2.getDb();
                    boolean bl3 = false;
                    byte[] byArray = ("release savepoint " + name).getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    it.exec(byArray);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
            SqliteConnection this_$iv3 = this;
            boolean $i$f$useDb$intellij_platform_sqlite3 = false;
            if (this_$iv3.dbRef.get() == null) {
                throw new AlreadyClosedException();
            }
            Lock lock = this_$iv3.lock;
            lock.lock();
            try {
                boolean bl = false;
                it = this_$iv3.getDb();
                boolean bl4 = false;
                byte[] byArray = ("rollback transaction to savepoint " + name).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                it.exec(byArray);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            throw throwable;
        }
        SqliteConnection this_$iv4 = this;
        boolean $i$f$useDb$intellij_platform_sqlite4 = false;
        if (this_$iv4.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this_$iv4.lock;
        lock.lock();
        try {
            boolean bl = false;
            it = this_$iv4.getDb();
            boolean bl5 = false;
            byte[] byArray = ("release savepoint " + name).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            it.exec(byArray);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    @NotNull
    public final <T extends Binder> SqlitePreparedStatement<T> prepareStatement(@Language(value="SQLite") @NotNull String sql2, @NotNull T binder) {
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Intrinsics.checkNotNullParameter(binder, (String)"binder");
        return this.prepareStatement(StringsKt.encodeToByteArray((String)sql2), binder);
    }

    @NotNull
    public final <T extends Binder> SqlitePreparedStatement<T> prepareStatement(@NotNull byte[] sqlUtf8, @NotNull T binder) {
        Intrinsics.checkNotNullParameter((Object)sqlUtf8, (String)"sqlUtf8");
        Intrinsics.checkNotNullParameter(binder, (String)"binder");
        return new SqlitePreparedStatement<T>(this, sqlUtf8, binder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean selectBoolean(@Language(value="SQLite") @NotNull String sql2, @Nullable Object values) {
        boolean bl;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        SqliteConnection sqliteConnection = this;
        byte[] sql$iv = StringsKt.encodeToByteArray((String)sql2);
        boolean $i$f$executeLifecycle = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (((SqliteConnection)this_$iv$iv).dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = ((SqliteConnection)this_$iv$iv).lock;
        lock.lock();
        try {
            boolean bl2;
            boolean bl3 = false;
            NativeDB db$iv = ((SqliteConnection)this_$iv$iv).getDb();
            boolean bl4 = false;
            long statementPointer$iv = db$iv.prepare_utf8(sql$iv);
            try {
                void statementPointer;
                int value;
                void isEmpty;
                boolean isEmpty$iv;
                SqliteConnectionKt.access$bind(statementPointer$iv, values, db$iv);
                boolean bl5 = isEmpty$iv = SqliteConnectionKt.step(statementPointer$iv, sql$iv, db$iv);
                long l = statementPointer$iv;
                NativeDB db = db$iv;
                boolean bl6 = false;
                boolean bl7 = isEmpty != false ? false : (value = db.column_int((long)statementPointer, 0)) != 0;
                bl2 = bl7;
                db$iv.finalize(statementPointer$iv);
            }
            catch (Throwable throwable) {
                db$iv.finalize(statementPointer$iv);
                throw throwable;
            }
            bl = bl2;
        }
        finally {
            lock.unlock();
        }
        return bl;
    }

    public static /* synthetic */ boolean selectBoolean$default(SqliteConnection sqliteConnection, String string, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return sqliteConnection.selectBoolean(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final String selectString(@Language(value="SQLite") @NotNull String sql2, @Nullable Object values) {
        String string;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        SqliteConnection sqliteConnection = this;
        byte[] sql$iv = StringsKt.encodeToByteArray((String)sql2);
        boolean $i$f$executeLifecycle = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (((SqliteConnection)this_$iv$iv).dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = ((SqliteConnection)this_$iv$iv).lock;
        lock.lock();
        try {
            String string2;
            boolean bl = false;
            NativeDB db$iv = ((SqliteConnection)this_$iv$iv).getDb();
            boolean bl2 = false;
            long statementPointer$iv = db$iv.prepare_utf8(sql$iv);
            try {
                void statementPointer;
                void empty2;
                boolean isEmpty$iv;
                SqliteConnectionKt.access$bind(statementPointer$iv, values, db$iv);
                boolean bl3 = isEmpty$iv = SqliteConnectionKt.step(statementPointer$iv, sql$iv, db$iv);
                long l = statementPointer$iv;
                NativeDB db = db$iv;
                boolean bl4 = false;
                string2 = empty2 != false ? null : db.column_text((long)statementPointer, 0);
                db$iv.finalize(statementPointer$iv);
            }
            catch (Throwable throwable) {
                db$iv.finalize(statementPointer$iv);
                throw throwable;
            }
            string = string2;
        }
        finally {
            lock.unlock();
        }
        return string;
    }

    public static /* synthetic */ String selectString$default(SqliteConnection sqliteConnection, String string, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return sqliteConnection.selectString(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final Integer selectInt(@Language(value="SQLite") @NotNull String sql2, @Nullable Object values) {
        Integer n;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        SqliteConnection sqliteConnection = this;
        byte[] sql$iv = StringsKt.encodeToByteArray((String)sql2);
        boolean $i$f$executeLifecycle = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (((SqliteConnection)this_$iv$iv).dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = ((SqliteConnection)this_$iv$iv).lock;
        lock.lock();
        try {
            Integer n2;
            boolean bl = false;
            NativeDB db$iv = ((SqliteConnection)this_$iv$iv).getDb();
            boolean bl2 = false;
            long statementPointer$iv = db$iv.prepare_utf8(sql$iv);
            try {
                void statementPointer;
                void empty2;
                boolean isEmpty$iv;
                SqliteConnectionKt.access$bind(statementPointer$iv, values, db$iv);
                boolean bl3 = isEmpty$iv = SqliteConnectionKt.step(statementPointer$iv, sql$iv, db$iv);
                long l = statementPointer$iv;
                NativeDB db = db$iv;
                boolean bl4 = false;
                n2 = empty2 != false ? null : Integer.valueOf(db.column_int((long)statementPointer, 0));
                db$iv.finalize(statementPointer$iv);
            }
            catch (Throwable throwable) {
                db$iv.finalize(statementPointer$iv);
                throw throwable;
            }
            n = n2;
        }
        finally {
            lock.unlock();
        }
        return n;
    }

    public static /* synthetic */ Integer selectInt$default(SqliteConnection sqliteConnection, String string, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return sqliteConnection.selectInt(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final <T> T executeLifecycle(byte[] sql2, Object values, Function3<? super NativeDB, ? super Long, ? super Boolean, ? extends T> executor) {
        boolean $i$f$executeLifecycle = false;
        SqliteConnection this_$iv = this;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this_$iv.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this_$iv.lock;
        lock.lock();
        boolean bl = false;
        NativeDB db = this_$iv.getDb();
        boolean bl2 = false;
        long statementPointer = db.prepare_utf8(sql2);
        SqliteConnectionKt.access$bind(statementPointer, values, db);
        boolean isEmpty = SqliteConnectionKt.step(statementPointer, sql2, db);
        Object object = executor.invoke((Object)db, (Object)statementPointer, (Object)isEmpty);
        InlineMarker.finallyStart((int)1);
        db.finalize(statementPointer);
        InlineMarker.finallyEnd((int)1);
        Object object2 = object;
        InlineMarker.finallyStart((int)3);
        lock.unlock();
        InlineMarker.finallyEnd((int)3);
        return (T)object2;
        {
            catch (Throwable throwable) {
                try {
                    InlineMarker.finallyStart((int)1);
                    db.finalize(statementPointer);
                    InlineMarker.finallyEnd((int)1);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    InlineMarker.finallyStart((int)1);
                    lock.unlock();
                    InlineMarker.finallyEnd((int)1);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static /* synthetic */ Object executeLifecycle$default(SqliteConnection $this, byte[] sql2, Object values, Function3 executor, int n, Object object) {
        if ((n & 2) != 0) {
            values = null;
        }
        boolean $i$f$executeLifecycle = false;
        SqliteConnection this_$iv = $this;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this_$iv.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this_$iv.lock;
        lock.lock();
        boolean bl = false;
        NativeDB db = this_$iv.getDb();
        boolean bl2 = false;
        long statementPointer = db.prepare_utf8(sql2);
        SqliteConnectionKt.access$bind(statementPointer, values, db);
        boolean isEmpty = SqliteConnectionKt.step(statementPointer, sql2, db);
        Object object2 = executor.invoke((Object)db, (Object)statementPointer, (Object)isEmpty);
        InlineMarker.finallyStart((int)1);
        db.finalize(statementPointer);
        InlineMarker.finallyEnd((int)1);
        Object object3 = object2;
        InlineMarker.finallyStart((int)3);
        lock.unlock();
        InlineMarker.finallyEnd((int)3);
        return object3;
        {
            catch (Throwable throwable) {
                try {
                    InlineMarker.finallyStart((int)1);
                    db.finalize(statementPointer);
                    InlineMarker.finallyEnd((int)1);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    InlineMarker.finallyStart((int)1);
                    lock.unlock();
                    InlineMarker.finallyEnd((int)1);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(@Language(value="SQLite") @NotNull String sql2) {
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        SqliteConnection this_$iv = this;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this_$iv.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this_$iv.lock;
        lock.lock();
        try {
            boolean bl = false;
            NativeDB it = this_$iv.getDb();
            boolean bl2 = false;
            it.exec(StringsKt.encodeToByteArray((String)sql2));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void execute(@Language(value="SQLite") @NotNull String sql2, @NotNull Object values) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        SqliteConnection sqliteConnection = this;
        byte[] sql$iv = StringsKt.encodeToByteArray((String)sql2);
        boolean $i$f$executeLifecycle = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (((SqliteConnection)this_$iv$iv).dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = ((SqliteConnection)this_$iv$iv).lock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            NativeDB db$iv = ((SqliteConnection)this_$iv$iv).getDb();
            boolean bl2 = false;
            long statementPointer$iv = db$iv.prepare_utf8(sql$iv);
            try {
                SqliteConnectionKt.access$bind(statementPointer$iv, values, db$iv);
                boolean isEmpty$iv = SqliteConnectionKt.step(statementPointer$iv, sql$iv, db$iv);
                boolean bl3 = false;
                unit = Unit.INSTANCE;
                db$iv.finalize(statementPointer$iv);
            }
            catch (Throwable throwable) {
                db$iv.finalize(statementPointer$iv);
                throw throwable;
            }
            Unit unit2 = unit;
        }
        finally {
            lock.unlock();
        }
    }

    public final int affectedRows() {
        Integer n = SqliteConnection.selectInt$default(this, "select changes()", null, 2, null);
        return n != null ? n : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interruptAndClose() {
        NativeDB nativeDB = this.dbRef.getAndSet(null);
        if (nativeDB == null) {
            return;
        }
        NativeDB db = nativeDB;
        db.interrupt();
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.doClose(db);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        NativeDB nativeDB = this.dbRef.getAndSet(null);
        if (nativeDB == null) {
            return;
        }
        NativeDB db = nativeDB;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.doClose(db);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void doClose(NativeDB db) {
        List pool = CollectionsKt.toList((Iterable)this.statementPoolList);
        this.statementPoolList.clear();
        Throwable error = null;
        for (SqlStatementPool item : pool) {
            try {
                item.close$intellij_platform_sqlite(db);
            }
            catch (Throwable e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                ExceptionsKt.addSuppressed((Throwable)error, (Throwable)e);
            }
        }
        try {
            db.close();
        }
        catch (Throwable e) {
            if (error == null) {
                error = e;
            }
            ExceptionsKt.addSuppressed((Throwable)error, (Throwable)e);
        }
        Iterator iterator = error;
        if (iterator != null) {
            Iterator it = iterator;
            boolean bl = false;
            throw it;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beginTransaction() {
        SqliteConnection this_$iv = this;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this_$iv.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this_$iv.lock;
        lock.lock();
        try {
            boolean bl = false;
            NativeDB it = this_$iv.getDb();
            boolean bl2 = false;
            it.exec(SqliteConnectionKt.access$getBEGIN_TRANSACTION$p());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit() {
        SqliteConnection this_$iv = this;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this_$iv.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this_$iv.lock;
        lock.lock();
        try {
            boolean bl = false;
            NativeDB it = this_$iv.getDb();
            boolean bl2 = false;
            it.exec(SqliteConnectionKt.access$getCOMMIT$p());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollback() {
        SqliteConnection this_$iv = this;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this_$iv.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this_$iv.lock;
        lock.lock();
        try {
            boolean bl = false;
            NativeDB it = this_$iv.getDb();
            boolean bl2 = false;
            it.exec(SqliteConnectionKt.access$getROLLBACK$p());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }
}

