/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XsdNamespaceBuilder
implements Comparable<XsdNamespaceBuilder> {
    private String myCurrentTag;
    private int myCurrentDepth;
    private String myNamespace;
    private String myVersion;
    private final List<String> myTags;
    private final Set<String> myReferencedTags = new HashSet<String>();
    private final List<String> myRootTags;
    private final List<String> myAttributes = new ArrayList<String>();

    public static String computeNamespace(@NotNull InputStream is) {
        if (is == null) {
            XsdNamespaceBuilder.$$$reportNull$$$0(0);
        }
        return XsdNamespaceBuilder.computeNamespace(new InputStreamReader(is, StandardCharsets.UTF_8)).getNamespace();
    }

    public static XsdNamespaceBuilder computeNamespace(@NotNull Reader reader) {
        XsdNamespaceBuilder xsdNamespaceBuilder;
        block9: {
            if (reader == null) {
                XsdNamespaceBuilder.$$$reportNull$$$0(1);
            }
            Reader reader2 = reader;
            try {
                XsdNamespaceBuilder xsdBuilder = new XsdNamespaceBuilder();
                NanoBuilder builder2 = xsdBuilder.new NanoBuilder();
                NanoXmlUtil.parse((Reader)reader, (IXMLBuilder)builder2);
                HashSet<String> tags = new HashSet<String>(xsdBuilder.getTags());
                tags.removeAll(xsdBuilder.myReferencedTags);
                xsdBuilder.getRootTags().addAll(tags);
                xsdNamespaceBuilder = xsdBuilder;
                if (reader2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader2 != null) {
                        try {
                            reader2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            reader2.close();
        }
        return xsdNamespaceBuilder;
    }

    @Override
    public int compareTo(@NotNull XsdNamespaceBuilder o) {
        if (o == null) {
            XsdNamespaceBuilder.$$$reportNull$$$0(2);
        }
        return Comparing.compare((Comparable)((Object)this.myNamespace), (Comparable)((Object)o.myNamespace));
    }

    public boolean hasTag(@NotNull String tagName) {
        if (tagName == null) {
            XsdNamespaceBuilder.$$$reportNull$$$0(3);
        }
        return this.myTags.contains(tagName);
    }

    public int getRating(@Nullable String tagName, @Nullable String version) {
        int rate = 0;
        if (tagName != null && this.myTags.contains(tagName)) {
            rate |= 2;
        }
        if (version != null && version.equals(this.myVersion)) {
            rate |= 1;
        }
        return rate;
    }

    private XsdNamespaceBuilder() {
        this.myTags = new ArrayList<String>();
        this.myRootTags = new ArrayList<String>();
    }

    XsdNamespaceBuilder(String namespace, String version, List<String> tags, List<String> rootTags) {
        this.myNamespace = namespace;
        this.myVersion = version;
        this.myTags = tags;
        this.myRootTags = rootTags;
    }

    public String getNamespace() {
        return this.myNamespace;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public List<String> getTags() {
        return this.myTags;
    }

    public List<String> getRootTags() {
        return this.myRootTags;
    }

    public List<String> getAttributes() {
        return this.myAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XsdNamespaceBuilder builder2 = (XsdNamespaceBuilder)o;
        if (!Objects.equals(this.myNamespace, builder2.myNamespace)) {
            return false;
        }
        if (!Objects.equals(this.myVersion, builder2.myVersion)) {
            return false;
        }
        return Objects.equals(this.myTags, builder2.myTags);
    }

    public int hashCode() {
        int result2 = this.myNamespace != null ? this.myNamespace.hashCode() : 0;
        result2 = 31 * result2 + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result2 = 31 * result2 + (this.myTags != null ? this.myTags.hashCode() : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/index/XsdNamespaceBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeNamespace";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class NanoBuilder
    implements NanoXmlBuilder {
        private NanoBuilder() {
        }

        public void startElement(@NonNls String name, @NonNls String nsPrefix, @NonNls String nsURI, String systemID, int lineNr) throws Exception {
            if ("http://www.w3.org/2001/XMLSchema".equals(nsURI)) {
                XsdNamespaceBuilder.this.myCurrentTag = name;
            }
            ++XsdNamespaceBuilder.this.myCurrentDepth;
        }

        public void endElement(String name, String nsPrefix, String nsURI) {
            --XsdNamespaceBuilder.this.myCurrentDepth;
            XsdNamespaceBuilder.this.myCurrentTag = null;
        }

        public void addAttribute(@NonNls String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
            if (XsdNamespaceBuilder.this.myCurrentDepth == 1 && "schema".equals(XsdNamespaceBuilder.this.myCurrentTag)) {
                if ("targetNamespace".equals(key)) {
                    XsdNamespaceBuilder.this.myNamespace = value;
                } else if ("version".equals(key)) {
                    XsdNamespaceBuilder.this.myVersion = value;
                }
            } else if ("element".equals(XsdNamespaceBuilder.this.myCurrentTag)) {
                if (XsdNamespaceBuilder.this.myCurrentDepth < 3 && "name".equals(key)) {
                    XsdNamespaceBuilder.this.myTags.add(value);
                } else if ("ref".equals(key)) {
                    XsdNamespaceBuilder.this.myReferencedTags.add(XmlUtil.getLocalName(value).toString());
                }
            }
        }
    }
}

