'use client';
import dayjs from 'dayjs';
import timezonePlugin from 'dayjs/plugin/timezone.js';
import utcPlugin from 'dayjs/plugin/utc.js';

dayjs.extend(utcPlugin);
dayjs.extend(timezonePlugin);
function getTimezoneOffset(date, timezone) {
  if (timezone) {
    return dayjs(date).tz(timezone).utcOffset() + date.getTimezoneOffset();
  }
  return 0;
}

export { getTimezoneOffset };
//# sourceMappingURL=get-timezone-offset.mjs.map
