import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["analyticsContext"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
import React, { forwardRef, useMemo } from 'react';
import AnalyticsContext from '../components/AnalyticsContext';
var withAnalyticsContext = function withAnalyticsContext(defaultData) {
  return function (WrappedComponent) {
    var WithAnalyticsContext = /*#__PURE__*/forwardRef(function (_ref, ref) {
      var analyticsContext = _ref.analyticsContext,
        rest = _objectWithoutProperties(_ref, _excluded);
      var analyticsData = useMemo(function () {
        return _objectSpread(_objectSpread({}, defaultData), analyticsContext);
      }, [analyticsContext]);
      return /*#__PURE__*/React.createElement(AnalyticsContext, {
        data: analyticsData
      }, /*#__PURE__*/React.createElement(WrappedComponent, _extends({}, rest, {
        ref: ref
      })));
    });
    WithAnalyticsContext.displayName = "WithAnalyticsContext(".concat(WrappedComponent.displayName || WrappedComponent.name, ")");
    return WithAnalyticsContext;
  };
};
export default withAnalyticsContext;