import type {Connection, LanguageServerPlugin} from "@volar/language-server"
import {handleCustomTsServerCommand} from "./handle-custom-ts-server-command"
import type {LspIdeTypeScriptCommandRequest} from "tsc-ide-plugin/protocol"

export function createIjServerPlugin(connection: Connection): LanguageServerPlugin {
  return (_initOptions, modules) => {
    if (!modules.typescript) {
      console.warn('No typescript found, vue-language-server-ij will not work.');
      return {};
    }

    const ts = modules.typescript;

    return {
      onInitialized(getService, env) {
        connection.onRequest('$/ij/handleCustomTsServerCommand', async (params: LspIdeTypeScriptCommandRequest) => {
          const requestArgs = params.args
          return handleCustomTsServerCommand(ts, getService, params.ideCommand, requestArgs, env.getCancellationToken());
        });
      },
    }
  }

}