"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Extensions = void 0;
var react_1 = __importStar(require("react"));
var Schema_1 = require("./Schema");
var helpers_1 = require("../helpers");
var contexts_1 = require("../contexts");
var CollapseButton_1 = require("./CollapseButton");
var Extensions = function (_a) {
    var _b = _a.name, name = _b === void 0 ? 'Extensions' : _b, item = _a.item;
    var _c = (0, react_1.useState)(false), expanded = _c[0], setExpanded = _c[1];
    var config = (0, contexts_1.useConfig)();
    var document = (0, contexts_1.useSpec)();
    var extensions = helpers_1.SchemaHelpers.getCustomExtensions(item);
    if (!extensions || !Object.keys(extensions).length) {
        return null;
    }
    if (!config.extensions || !Object.keys(config.extensions).length) {
        var schema = helpers_1.SchemaHelpers.jsonToSchema(extensions);
        return (schema && (react_1.default.createElement("div", { className: "mt-2" },
            react_1.default.createElement(Schema_1.Schema, { schemaName: name, schema: schema, onlyTitle: true }))));
    }
    return (react_1.default.createElement("div", null,
        react_1.default.createElement("div", { className: "flex py-2" },
            react_1.default.createElement("div", { className: "min-w-1/4" },
                react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement(CollapseButton_1.CollapseButton, { onClick: function () { return setExpanded(function (prev) { return !prev; }); }, expanded: expanded },
                        react_1.default.createElement("span", { className: "break-anywhere text-sm ".concat(name) }, name))))),
        react_1.default.createElement("div", { className: "rounded p-4 py-2 border bg-gray-100 ".concat(expanded ? 'block' : 'hidden') }, Object.keys(extensions)
            .sort(function (extension1, extension2) {
            return extension1.localeCompare(extension2);
        })
            .map(function (extensionKey) {
            var _a;
            if ((_a = config.extensions) === null || _a === void 0 ? void 0 : _a[extensionKey]) {
                var CustomExtensionComponent = config.extensions[extensionKey];
                return (react_1.default.createElement(CustomExtensionComponent, { key: extensionKey, propertyName: extensionKey, propertyValue: extensions[extensionKey], document: document, parent: item }));
            }
            else {
                var extensionSchema = helpers_1.SchemaHelpers.jsonToSchema(extensions[extensionKey]);
                return (react_1.default.createElement("div", { key: extensionKey, className: "mt-2" },
                    react_1.default.createElement(Schema_1.Schema, { schemaName: extensionKey, schema: extensionSchema })));
            }
        }))));
};
exports.Extensions = Extensions;
//# sourceMappingURL=Extensions.js.map