/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.CreateDataFrameDsl;
import org.jetbrains.kotlinx.dataframe.api.TraversePropertiesDsl;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.api.ToDataFrameKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001,B3\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0002\b\u00030\u0010j\u0002`\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0016J*\u0010\u001a\u001a\u00020\u00172\u001a\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u001c\"\u0006\u0012\u0002\b\u00030\u0007H\u0096\u0001\u00a2\u0006\u0002\u0010\u001dJ*\u0010\u001a\u001a\u00020\u00172\u001a\u0010\u001e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001c\"\u0006\u0012\u0002\b\u00030\u001fH\u0096\u0001\u00a2\u0006\u0002\u0010 J*\u0010!\u001a\u00020\u00172\u001a\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u001c\"\u0006\u0012\u0002\b\u00030\u0007H\u0096\u0001\u00a2\u0006\u0002\u0010\u001dJ*\u0010!\u001a\u00020\u00172\u001a\u0010\u001e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001c\"\u0006\u0012\u0002\b\u00030\u001fH\u0096\u0001\u00a2\u0006\u0002\u0010 JL\u0010\u001e\u001a\u00020\u00172\u001a\u0010\"\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001c\"\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010#\u001a\u00020$2\u0019\u0010%\u001a\u0015\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0017\u0018\u00010&\u00a2\u0006\u0002\b'H\u0016\u00a2\u0006\u0002\u0010(J,\u0010)\u001a\u00020\u0017*\u00020*2\u001d\u0010+\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0004\u0012\u00020\u00170&\u00a2\u0006\u0002\b'H\u0096\u0002R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\r\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0002\b\u00030\u0010j\u0002`\u00110\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/api/CreateDataFrameDslImpl;", "T", "Lorg/jetbrains/kotlinx/dataframe/api/CreateDataFrameDsl;", "Lorg/jetbrains/kotlinx/dataframe/api/TraversePropertiesDsl;", "source", "", "clazz", "Lkotlin/reflect/KClass;", "prefix", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "configuration", "Lorg/jetbrains/kotlinx/dataframe/impl/api/CreateDataFrameDslImpl$TraverseConfiguration;", "(Ljava/lang/Iterable;Lkotlin/reflect/KClass;Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;Lorg/jetbrains/kotlinx/dataframe/impl/api/CreateDataFrameDslImpl$TraverseConfiguration;)V", "columns", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlinx/dataframe/columns/BaseColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyBaseCol;", "getColumns$core", "()Ljava/util/List;", "getSource", "()Ljava/lang/Iterable;", "add", "", "column", "path", "exclude", "classes", "", "([Lkotlin/reflect/KClass;)V", "properties", "Lkotlin/reflect/KProperty;", "([Lkotlin/reflect/KProperty;)V", "preserve", "roots", "maxDepth", "", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "([Lkotlin/reflect/KProperty;ILkotlin/jvm/functions/Function1;)V", "invoke", "", "builder", "TraverseConfiguration", "core"})
@SourceDebugExtension(value={"SMAP\ntoDataFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 toDataFrame.kt\norg/jetbrains/kotlinx/dataframe/impl/api/CreateDataFrameDslImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n1855#2,2:265\n*S KotlinDebug\n*F\n+ 1 toDataFrame.kt\norg/jetbrains/kotlinx/dataframe/impl/api/CreateDataFrameDslImpl\n*L\n113#1:265,2\n*E\n"})
public final class CreateDataFrameDslImpl<T>
extends CreateDataFrameDsl<T>
implements TraversePropertiesDsl {
    @NotNull
    private final Iterable<T> source;
    @NotNull
    private final KClass<?> clazz;
    @NotNull
    private final ColumnPath prefix;
    @NotNull
    private final TraverseConfiguration configuration;
    @NotNull
    private final List<Pair<ColumnPath, BaseColumn<?>>> columns;

    public CreateDataFrameDslImpl(@NotNull Iterable<? extends T> source, @NotNull KClass<?> clazz, @NotNull ColumnPath prefix, @NotNull TraverseConfiguration configuration) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.source = source;
        this.clazz = clazz;
        this.prefix = prefix;
        this.configuration = configuration;
        this.columns = new ArrayList();
    }

    public /* synthetic */ CreateDataFrameDslImpl(Iterable iterable, KClass kClass, ColumnPath columnPath, TraverseConfiguration traverseConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            columnPath = UtilsKt.emptyPath();
        }
        if ((n & 8) != 0) {
            traverseConfiguration = new TraverseConfiguration();
        }
        this(iterable, kClass, columnPath, traverseConfiguration);
    }

    @Override
    @NotNull
    public Iterable<T> getSource() {
        return this.source;
    }

    @Override
    public void exclude(KClass<?> ... classes) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        this.configuration.exclude(classes);
    }

    @Override
    public void exclude(KProperty<?> ... properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.configuration.exclude(properties);
    }

    @Override
    public void preserve(KClass<?> ... classes) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        this.configuration.preserve(classes);
    }

    @Override
    public void preserve(KProperty<?> ... properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.configuration.preserve(properties);
    }

    @NotNull
    public final List<Pair<ColumnPath, BaseColumn<?>>> getColumns$core() {
        return this.columns;
    }

    @Override
    public void add(@NotNull BaseColumn<?> column2, @Nullable ColumnPath path) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        ColumnPath columnPath = path;
        BaseColumn<?> col2 = columnPath != null ? column2.rename((String)CollectionsKt.last((List)columnPath)) : column2;
        ColumnPath targetPath = path != null ? this.prefix.plus(path) : this.prefix.plus(column2.name());
        this.columns.add(TuplesKt.to((Object)targetPath, col2));
    }

    @Override
    public void invoke(@NotNull String $this$invoke, @NotNull Function1<? super CreateDataFrameDsl<T>, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"<this>");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        CreateDataFrameDslImpl<T> child = new CreateDataFrameDslImpl<T>(this.getSource(), this.clazz, this.prefix.plus($this$invoke), null, 8, null);
        builder.invoke(child);
        this.columns.addAll((Collection)child.columns);
    }

    @Override
    public void properties(@NotNull KProperty<?>[] roots, int maxDepth, @Nullable Function1<? super TraversePropertiesDsl, Unit> body) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        TraverseConfiguration dsl = this.configuration.clone();
        if (body != null) {
            body.invoke((Object)dsl);
        }
        DataFrame<?> df2 = ToDataFrameKt.convertToDataFrame(this.getSource(), this.clazz, ArraysKt.toList((Object[])roots), dsl.getExcludeProperties(), dsl.getPreserveClasses(), dsl.getPreserveProperties(), maxDepth);
        Iterable $this$forEach$iv = df2.columns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataColumn it = (DataColumn)element$iv;
            boolean bl = false;
            CreateDataFrameDsl.add$default(this, it, null, 2, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0000J)\u0010\u0010\u001a\u00020\u00112\u001a\u0010\u0012\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00050\u0013\"\u0006\u0012\u0002\b\u00030\u0005H\u0016\u00a2\u0006\u0002\u0010\u0014J)\u0010\u0010\u001a\u00020\u00112\u001a\u0010\u0015\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\t0\u0013\"\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0002\u0010\u0016J)\u0010\u0017\u001a\u00020\u00112\u001a\u0010\u0012\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00050\u0013\"\u0006\u0012\u0002\b\u00030\u0005H\u0016\u00a2\u0006\u0002\u0010\u0014J)\u0010\u0017\u001a\u00020\u00112\u001a\u0010\u0015\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\t0\u0013\"\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0002\u0010\u0016R\u001b\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u001b\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u001b\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/api/CreateDataFrameDslImpl$TraverseConfiguration;", "Lorg/jetbrains/kotlinx/dataframe/api/TraversePropertiesDsl;", "()V", "excludeClasses", "", "Lkotlin/reflect/KClass;", "getExcludeClasses", "()Ljava/util/Set;", "excludeProperties", "Lkotlin/reflect/KProperty;", "getExcludeProperties", "preserveClasses", "getPreserveClasses", "preserveProperties", "getPreserveProperties", "clone", "exclude", "", "classes", "", "([Lkotlin/reflect/KClass;)V", "properties", "([Lkotlin/reflect/KProperty;)V", "preserve", "core"})
    public static final class TraverseConfiguration
    implements TraversePropertiesDsl {
        @NotNull
        private final Set<KProperty<?>> excludeProperties = new LinkedHashSet();
        @NotNull
        private final Set<KClass<?>> excludeClasses = new LinkedHashSet();
        @NotNull
        private final Set<KClass<?>> preserveClasses = new LinkedHashSet();
        @NotNull
        private final Set<KProperty<?>> preserveProperties = new LinkedHashSet();

        @NotNull
        public final Set<KProperty<?>> getExcludeProperties() {
            return this.excludeProperties;
        }

        @NotNull
        public final Set<KClass<?>> getExcludeClasses() {
            return this.excludeClasses;
        }

        @NotNull
        public final Set<KClass<?>> getPreserveClasses() {
            return this.preserveClasses;
        }

        @NotNull
        public final Set<KProperty<?>> getPreserveProperties() {
            return this.preserveProperties;
        }

        @NotNull
        public final TraverseConfiguration clone() {
            TraverseConfiguration traverseConfiguration;
            TraverseConfiguration it = traverseConfiguration = new TraverseConfiguration();
            boolean bl = false;
            it.excludeClasses.addAll((Collection)this.excludeClasses);
            it.excludeProperties.addAll((Collection)this.excludeProperties);
            it.preserveProperties.addAll((Collection)this.preserveProperties);
            it.preserveClasses.addAll((Collection)this.preserveClasses);
            return traverseConfiguration;
        }

        @Override
        public void exclude(KProperty<?> ... properties) {
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            CollectionsKt.addAll((Collection)this.excludeProperties, (Object[])properties);
        }

        @Override
        public void exclude(KClass<?> ... classes) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            CollectionsKt.addAll((Collection)this.excludeClasses, (Object[])classes);
        }

        @Override
        public void preserve(KClass<?> ... classes) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            CollectionsKt.addAll((Collection)this.preserveClasses, (Object[])classes);
        }

        @Override
        public void preserve(KProperty<?> ... properties) {
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            CollectionsKt.addAll((Collection)this.preserveProperties, (Object[])properties);
        }
    }
}

