/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.huggingFace.cacheManager.ui.core;

import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J:\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fH\u0016J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/python/huggingFace/cacheManager/ui/core/HfCacheMaterialTableCellRenderer;", "Ljavax/swing/JComponent;", "Ljavax/swing/table/TableCellRenderer;", "<init>", "()V", "text", "", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "horizontalAlignment", "", "getHorizontalAlignment", "()I", "setHorizontalAlignment", "(I)V", "lastColumn", "", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "hasFocus", "row", "column", "setValue", "", "getPreferredSize", "Ljava/awt/Dimension;", "paintComponent", "g", "Ljava/awt/Graphics;", "Companion", "intellij.python.huggingFace"})
public class HfCacheMaterialTableCellRenderer
extends JComponent
implements TableCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String text = "";
    private int horizontalAlignment = 10;
    private boolean lastColumn;
    @NotNull
    private static final JLabel label = new JLabel();
    private static final int textLeftOffset = JBUIScale.scale((int)5);
    private static final int textVerticalOffset = JBUIScale.scale((int)8);

    public HfCacheMaterialTableCellRenderer() {
        this.setOpaque(true);
    }

    @NotNull
    protected final String getText() {
        return this.text;
    }

    protected final void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.text = string;
    }

    protected final int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    protected final void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.setFont(table.getFont());
        this.setValue(value2);
        return this;
    }

    public void setValue(@Nullable Object value2) {
        Object object = value2;
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        this.text = object;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Intrinsics.checkNotNull((Object)fontMetrics);
        return new Dimension(Companion.geStringWidthLimited(fontMetrics, this.text) + textLeftOffset * 2, fontMetrics.getAscent() - fontMetrics.getDescent() + textVerticalOffset * 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            Object aaHint = label.getClientProperty(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (aaHint != null) {
                RenderingHints.Key key = RenderingHints.KEY_TEXT_ANTIALIASING;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"KEY_TEXT_ANTIALIASING");
                HfCacheMaterialTableCellRenderer.Companion.configureHint(key, g2, aaHint);
                RenderingHints.Key key2 = RenderingHints.KEY_FRACTIONALMETRICS;
                Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"KEY_FRACTIONALMETRICS");
                HfCacheMaterialTableCellRenderer.Companion.configureHint(key2, g2, HfCacheMaterialTableCellRenderer.label.getClientProperty(RenderingHints.KEY_FRACTIONALMETRICS));
                RenderingHints.Key key3 = RenderingHints.KEY_TEXT_LCD_CONTRAST;
                Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"KEY_TEXT_LCD_CONTRAST");
                HfCacheMaterialTableCellRenderer.Companion.configureHint(key3, g2, HfCacheMaterialTableCellRenderer.label.getClientProperty(RenderingHints.KEY_TEXT_LCD_CONTRAST));
            }
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setFont(this.getFont());
            g2.setColor(this.getForeground());
            FontMetrics fontMetrics = g2.getFontMetrics();
            if (this.horizontalAlignment == 4 && !this.lastColumn) {
                Intrinsics.checkNotNull((Object)fontMetrics);
                g2.drawString(HfCacheMaterialTableCellRenderer.Companion.getTrimmedToWidthText(fontMetrics, this.text, this.getWidth() - HfCacheMaterialTableCellRenderer.textLeftOffset), this.getWidth() - textLeftOffset - Companion.geStringWidthLimited(fontMetrics, this.text), (this.getHeight() + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2);
            } else {
                Intrinsics.checkNotNull((Object)fontMetrics);
                g2.drawString(HfCacheMaterialTableCellRenderer.Companion.getTrimmedToWidthText(fontMetrics, this.text, this.getWidth() - HfCacheMaterialTableCellRenderer.textLeftOffset), textLeftOffset, (this.getHeight() + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2);
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/intellij/python/huggingFace/cacheManager/ui/core/HfCacheMaterialTableCellRenderer$Companion;", "", "<init>", "()V", "label", "Ljavax/swing/JLabel;", "textLeftOffset", "", "getTextLeftOffset", "()I", "textVerticalOffset", "getTextVerticalOffset", "geStringWidthLimited", "fontMetrics", "Ljava/awt/FontMetrics;", "str", "", "getTrimmedToWidthText", "text", "width", "configureHint", "", "key", "Ljava/awt/RenderingHints$Key;", "g", "Ljava/awt/Graphics2D;", "newValue", "intellij.python.huggingFace"})
    public static final class Companion {
        private Companion() {
        }

        public final int getTextLeftOffset() {
            return textLeftOffset;
        }

        public final int getTextVerticalOffset() {
            return textVerticalOffset;
        }

        public final int geStringWidthLimited(@NotNull FontMetrics fontMetrics, @NotNull String str) {
            int n;
            Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            int len = str.length();
            if (len < 128) {
                char[] data = new char[len];
                String string = str;
                int n2 = 0;
                int n3 = 0;
                string.getChars(n3, len, data, n2);
                n = fontMetrics.charsWidth(data, 0, len);
            } else {
                int strWidth = 0;
                int pos = 0;
                while ((strWidth += fontMetrics.charWidth(str.charAt(++pos))) < 1024 && pos < len) {
                }
                n = strWidth;
            }
            return n;
        }

        private final String getTrimmedToWidthText(FontMetrics fontMetrics, String text, int width) {
            Object object;
            int len = text.length();
            if (len < 128) {
                return text;
            }
            int strWidth = 0;
            int pos = 0;
            while ((strWidth += fontMetrics.charWidth(text.charAt(++pos))) < width) {
                if (pos < len) continue;
                break;
            }
            if (pos == len) {
                object = text;
            } else if (pos - 3 <= 0) {
                object = "...";
            } else {
                String string = text.substring(0, pos - 3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String substring = string;
                object = substring + "...";
            }
            return object;
        }

        private final void configureHint(RenderingHints.Key key, Graphics2D g, Object newValue) {
            if (newValue == null) {
                return;
            }
            if (Intrinsics.areEqual((Object)newValue, (Object)g.getRenderingHint(key))) {
                return;
            }
            g.setRenderingHint(key, newValue);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

