/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.gherkin.parametersInspection;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.python.gherkin.PyBDDBundle;
import com.intellij.python.gherkin.parametersInspection.GetParamNamesFilter;
import com.jetbrains.python.ast.PyAstDocStringOwner;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AddParameterQuickFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final List<Pair<String, String>> myParamNamesAndTypeInfo;

    AddParameterQuickFix(@NotNull List<Pair<String, String>> paramNameAndTypeInfos) {
        if (paramNameAndTypeInfos == null) {
            AddParameterQuickFix.$$$reportNull$$$0(0);
        }
        this.myParamNamesAndTypeInfo = new ArrayList<Pair<String, String>>();
        this.myParamNamesAndTypeInfo.addAll(paramNameAndTypeInfos);
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBDDBundle.message("com.intellij.python.gherkin.inspections.parameters.quick_fix.add_param", Lists.transform(this.myParamNamesAndTypeInfo, (Function)GetParamNamesFilter.INSTANCE));
        if (string == null) {
            AddParameterQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PyParameterList paramList;
        if (project == null) {
            AddParameterQuickFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            AddParameterQuickFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            AddParameterQuickFix.$$$reportNull$$$0(4);
        }
        if ((paramList = (PyParameterList)PyUtil.as((Object)element, PyParameterList.class)) == null) {
            return;
        }
        PyFunction function = (PyFunction)paramList.getParent();
        PyDocstringGenerator docstringGenerator = PyDocstringGenerator.forDocStringOwner((PyAstDocStringOwner)function);
        for (Pair<String, String> pair : this.myParamNamesAndTypeInfo) {
            paramList.addParameter(PyElementGenerator.getInstance((Project)project).createParameter((String)pair.first));
            docstringGenerator.withParamTypedByName((String)pair.first, StringUtil.notNullize((String)((String)pair.second)));
        }
        if (!docstringGenerator.isNewMode() && docstringGenerator.hasParametersToAdd()) {
            docstringGenerator.buildAndInsert();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramNameAndTypeInfos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/gherkin/parametersInspection/AddParameterQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/gherkin/parametersInspection/AddParameterQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

