/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.prep;

import java.util.List;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.locationtech.jts.geom.util.ComponentCoordinateExtracter;

abstract class PreparedPolygonPredicate {
    protected PreparedPolygon prepPoly;
    private PointOnGeometryLocator targetPointLocator;

    public PreparedPolygonPredicate(PreparedPolygon prepPoly) {
        this.prepPoly = prepPoly;
        this.targetPointLocator = prepPoly.getPointLocator();
    }

    protected boolean isAllTestComponentsInTarget(Geometry testGeom) {
        List coords = ComponentCoordinateExtracter.getCoordinates(testGeom);
        for (Coordinate p2 : coords) {
            int loc = this.targetPointLocator.locate(p2);
            if (loc != 2) continue;
            return false;
        }
        return true;
    }

    protected boolean isAllTestComponentsInTargetInterior(Geometry testGeom) {
        List coords = ComponentCoordinateExtracter.getCoordinates(testGeom);
        for (Coordinate p2 : coords) {
            int loc = this.targetPointLocator.locate(p2);
            if (loc == 0) continue;
            return false;
        }
        return true;
    }

    protected boolean isAnyTestComponentInTarget(Geometry testGeom) {
        List coords = ComponentCoordinateExtracter.getCoordinates(testGeom);
        for (Coordinate p2 : coords) {
            int loc = this.targetPointLocator.locate(p2);
            if (loc == 2) continue;
            return true;
        }
        return false;
    }

    protected boolean isAllTestPointsInTarget(Geometry testGeom) {
        for (int i2 = 0; i2 < testGeom.getNumGeometries(); ++i2) {
            Point pt = (Point)testGeom.getGeometryN(i2);
            Coordinate p2 = pt.getCoordinate();
            int loc = this.targetPointLocator.locate(p2);
            if (loc != 2) continue;
            return false;
        }
        return true;
    }

    protected boolean isAnyTestPointInTargetInterior(Geometry testGeom) {
        for (int i2 = 0; i2 < testGeom.getNumGeometries(); ++i2) {
            Point pt = (Point)testGeom.getGeometryN(i2);
            Coordinate p2 = pt.getCoordinate();
            int loc = this.targetPointLocator.locate(p2);
            if (loc != 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isAnyTargetComponentInAreaTest(Geometry testGeom, List targetRepPts) {
        SimplePointInAreaLocator piaLoc = new SimplePointInAreaLocator(testGeom);
        for (Coordinate p2 : targetRepPts) {
            int loc = piaLoc.locate(p2);
            if (loc == 2) continue;
            return true;
        }
        return false;
    }
}

