/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.refactoring.SqlSubqueryUtils;
import com.intellij.sql.refactoring.SqlSubqueryUtilsCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlExtractNamedQueryAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SqlExtractNamedQueryAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SqlExtractNamedQueryAction.$$$reportNull$$$0(1);
        }
        this.invoke(SqlExtractNamedQueryAction.getEditor(e), SqlExtractNamedQueryAction.getPsiFile(e));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SqlExtractNamedQueryAction.$$$reportNull$$$0(2);
        }
        Presentation presentation = e.getPresentation();
        Editor editor2 = SqlExtractNamedQueryAction.getEditor(e);
        PsiFile file = SqlExtractNamedQueryAction.getPsiFile(e);
        boolean visible = editor2 != null && file != null && file.getLanguage() instanceof SqlLanguageDialect;
        boolean enabled = visible;
        if (enabled) {
            SqlExpression subquery = SqlSubqueryUtils.smartFindQuery(editor2, file);
            SqlExpression query = SqlSubqueryUtilsCore.findEnclosingQueryWithContext((PsiElement)subquery);
            enabled = SqlSubqueryUtils.isSubquery(query, subquery) && SqlSubqueryUtils.isCTESupported(file);
        }
        presentation.setVisible(visible);
        presentation.setEnabled(enabled);
    }

    public void invoke(Editor editor2, PsiFile file) {
        if (!SqlSubqueryUtils.isCTESupported(file)) {
            return;
        }
        SqlExpression subquery = SqlSubqueryUtils.smartFindQuery(editor2, file);
        SqlExpression query = SqlSubqueryUtilsCore.findEnclosingQueryWithContext((PsiElement)subquery);
        if (!SqlSubqueryUtils.isSubquery(query, subquery)) {
            return;
        }
        if (!SqlSubqueryUtils.canExtractWithoutContextLoss(subquery)) {
            return;
        }
        SqlSubqueryUtils.extractCte(editor2.getProject(), editor2, file, subquery, query, false);
    }

    @Nullable
    private static Editor getEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            SqlExtractNamedQueryAction.$$$reportNull$$$0(3);
        }
        return (Editor)e.getData(CommonDataKeys.EDITOR);
    }

    @Nullable
    private static PsiFile getPsiFile(@NotNull AnActionEvent e) {
        if (e == null) {
            SqlExtractNamedQueryAction.$$$reportNull$$$0(4);
        }
        return (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/refactoring/SqlExtractNamedQueryAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/refactoring/SqlExtractNamedQueryAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

