/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.symbols.virtual.DasVirtualSymbol;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlResolveResultImpl
extends PsiElementResolveResult
implements SqlResolveResult {
    private final PsiElement myQualifier;
    private final PsiElement myImmediateTarget;
    private final PsiElement myImmediateQualifier;
    private final boolean myIsHidden;
    private final DasSymbol mySymbol;

    public SqlResolveResultImpl(@Nullable PsiElement qualifier, @Nullable PsiElement immediateTarget, @Nullable PsiElement immediateQualifier, @NotNull PsiElement element, DasSymbol symbol) {
        if (element == null) {
            SqlResolveResultImpl.$$$reportNull$$$0(0);
        }
        this(qualifier, immediateTarget, immediateQualifier, element, symbol, false);
    }

    public SqlResolveResultImpl(@Nullable PsiElement qualifier, @Nullable PsiElement immediateTarget, @Nullable PsiElement immediateQualifier, @NotNull PsiElement element, @NotNull DasSymbol symbol, boolean isHidden) {
        if (element == null) {
            SqlResolveResultImpl.$$$reportNull$$$0(1);
        }
        if (symbol == null) {
            SqlResolveResultImpl.$$$reportNull$$$0(2);
        }
        super(element);
        this.myQualifier = qualifier;
        this.myImmediateTarget = immediateTarget;
        this.myImmediateQualifier = immediateQualifier;
        this.myIsHidden = isHidden;
        this.mySymbol = symbol;
    }

    public boolean isHidden() {
        return this.myIsHidden;
    }

    @Nullable
    public PsiElement getQualifier() {
        return this.myQualifier;
    }

    @Nullable
    public PsiElement getImmediateTarget() {
        return this.myImmediateTarget;
    }

    @Nullable
    public PsiElement getImmediateQualifier() {
        return this.myImmediateQualifier;
    }

    @NotNull
    public DasSymbol getTargetSymbol() {
        DasSymbol dasSymbol = this.mySymbol;
        if (dasSymbol == null) {
            SqlResolveResultImpl.$$$reportNull$$$0(3);
        }
        return dasSymbol;
    }

    @NotNull
    public SqlResolveResult hide() {
        return this.myIsHidden ? this : new SqlResolveResultImpl(this.myQualifier, this.myImmediateTarget, this.myImmediateQualifier, this.getElement(), this.mySymbol, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SqlResolveResultImpl result2 = (SqlResolveResultImpl)((Object)o);
        return Comparing.equal((Object)this.mySymbol, (Object)result2.mySymbol) && Comparing.equal((Object)this.myQualifier, (Object)result2.myQualifier);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + Comparing.hashcode((Object)this.mySymbol);
        result2 = 31 * result2 + Comparing.hashcode((Object)this.myQualifier);
        return result2;
    }

    public static SqlResolveResult[] createSingleSqlResults(@Nullable PsiElement qualifier, @Nullable PsiElement immediateTarget, @NotNull PsiElement element, @NotNull DasSymbol symbol) {
        if (element == null) {
            SqlResolveResultImpl.$$$reportNull$$$0(4);
        }
        if (symbol == null) {
            SqlResolveResultImpl.$$$reportNull$$$0(5);
        }
        return new SqlResolveResult[]{new SqlResolveResultImpl(qualifier, immediateTarget, null, element, symbol)};
    }

    private static boolean isFake(SqlResolveResult result2) {
        DasSymbol symbol = result2.getTargetSymbol();
        if (result2.getElement() instanceof SqlFileImpl.FakeDefinition || symbol instanceof DasVirtualSymbol) {
            return true;
        }
        BasicElement element = (BasicElement)ObjectUtils.tryCast((Object)symbol.getDasObject(), BasicElement.class);
        BasicModel model = element == null ? null : element.getModel();
        ModelTextStorage storage = model == null ? null : ((BasicModModel)model).getTextStorage();
        return storage == DataSourceSnapshotManager.MINICAT_STORAGE;
    }

    public static SqlResolveResult[] createSqlResults(@NotNull Collection<SqlResolveResult> qualified) {
        if (qualified == null) {
            SqlResolveResultImpl.$$$reportNull$$$0(6);
        }
        SqlResolveResult[] res2 = new SqlResolveResult[qualified.size()];
        int i2 = 0;
        for (SqlResolveResult item : qualified) {
            if (SqlResolveResultImpl.isFake(item)) continue;
            res2[i2++] = item;
        }
        for (SqlResolveResult item : qualified) {
            if (!SqlResolveResultImpl.isFake(item)) continue;
            res2[i2++] = item;
        }
        return res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlResolveResultImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlResolveResultImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSingleSqlResults";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSqlResults";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

