/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inlays;

import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.codeInsight.hints.declarative.InlayPosition;
import com.intellij.codeInsight.hints.declarative.InlayTreeSink;
import com.intellij.codeInsight.hints.declarative.InlineInlayPosition;
import com.intellij.codeInsight.hints.declarative.PresentationTreeBuilder;
import com.intellij.codeInsight.hints.declarative.SharedBypassCollector;
import com.intellij.database.model.DasArgument;
import com.intellij.database.types.DasType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlValuesToColumnMapper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.inlays.InlayUtilsKt;
import com.intellij.sql.inlays.SqlColumnNamesInlayHintsProvider;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlOperatorExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSetOperatorExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.slicer.SqlPsiUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016JH\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e26\u0010\u000f\u001a2\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\f0\u0010H\u0002JP\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b26\u0010\u000f\u001a2\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\f0\u0010H\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\""}, d2={"Lcom/intellij/sql/inlays/SqlColumnNamesInlayHintsProvider;", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "createCollector", "Lcom/intellij/codeInsight/hints/declarative/SharedBypassCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "processCallHints", "", "callExpression", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "action", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "offset", "", "text", "processResultSetHints", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "guessExpressionName", "selectClause", "Lcom/intellij/sql/psi/SqlSelectClause;", "index", "shouldShowHintsForExpression", "", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlColumnNamesInlayHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlColumnNamesInlayHintsProvider.kt\ncom/intellij/sql/inlays/SqlColumnNamesInlayHintsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
public final class SqlColumnNamesInlayHintsProvider
implements InlayHintsProvider,
DumbAware {
    @NotNull
    public SharedBypassCollector createCollector(@NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return new SharedBypassCollector(this){
            final /* synthetic */ SqlColumnNamesInlayHintsProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public void collectFromElement(PsiElement element, InlayTreeSink sink) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                if (element instanceof SqlFunctionCallExpression) {
                    SqlColumnNamesInlayHintsProvider.access$processCallHints(this.this$0, (SqlFunctionCallExpression)element, (Function2)new Function2<Integer, String, Unit>(sink){
                        final /* synthetic */ InlayTreeSink $sink;
                        {
                            this.$sink = $sink;
                            super(2, Intrinsics.Kotlin.class, "addHint", "collectFromElement$addHint(Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;ILjava/lang/String;)V", 0);
                        }

                        public final void invoke(int p0, String p1) {
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            createCollector.1.access$collectFromElement$addHint(this.$sink, p0, p1);
                        }
                    });
                } else {
                    SqlColumnNamesInlayHintsProvider.access$processResultSetHints(this.this$0, element, sink, (Function2)new Function2<Integer, String, Unit>(sink){
                        final /* synthetic */ InlayTreeSink $sink;
                        {
                            this.$sink = $sink;
                            super(2, Intrinsics.Kotlin.class, "addHint", "collectFromElement$addHint(Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;ILjava/lang/String;)V", 0);
                        }

                        public final void invoke(int p0, String p1) {
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            createCollector.1.access$collectFromElement$addHint(this.$sink, p0, p1);
                        }
                    });
                }
            }

            private static final Unit collectFromElement$addHint$lambda$0(String $text, PresentationTreeBuilder $this$addPresentation) {
                Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
                PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)$text, null, (int)2, null);
                return Unit.INSTANCE;
            }

            private static final void collectFromElement$addHint(InlayTreeSink $sink, int offset, String text2) {
                if (((CharSequence)text2).length() == 0) {
                    return;
                }
                InlayTreeSink.addPresentation$default((InlayTreeSink)$sink, (InlayPosition)((InlayPosition)new InlineInlayPosition(offset, true, 0, 4, null)), null, null, (boolean)true, arg_0 -> createCollector.1.collectFromElement$addHint$lambda$0(text2, arg_0), (int)6, null);
            }

            public static final /* synthetic */ void access$collectFromElement$addHint(InlayTreeSink $sink, int offset, String text2) {
                createCollector.1.collectFromElement$addHint($sink, offset, text2);
            }
        };
    }

    private final void processCallHints(SqlFunctionCallExpression callExpression, Function2<? super Integer, ? super String, Unit> action) {
        SqlReferenceExpression sqlReferenceExpression = callExpression.getNameElement();
        if (sqlReferenceExpression == null) {
            return;
        }
        SqlReferenceExpression calleeExpression = sqlReferenceExpression;
        if (SqlImplUtil.resolveVisible(calleeExpression).filter(arg_0 -> SqlColumnNamesInlayHintsProvider.processCallHints$lambda$1(SqlColumnNamesInlayHintsProvider::processCallHints$lambda$0, arg_0)).isEmpty()) {
            return;
        }
        SqlExpressionList sqlExpressionList = callExpression.getParameterList();
        if (sqlExpressionList == null) {
            return;
        }
        SqlExpressionList expressionList = sqlExpressionList;
        for (SqlExpression expression : expressionList.getExpressionList()) {
            String name2;
            DasArgument dasArgument;
            if (expression instanceof SqlNamedParameterValueExpression) continue;
            Intrinsics.checkNotNull((Object)expression);
            if (SqlPsiUtilKt.findParameterDefinition(expression, false) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)dasArgument.getName(), (String)"getName(...)");
            if (StringUtil.isEmpty((String)name2)) continue;
            action.invoke((Object)expression.getTextRange().getStartOffset(), (Object)name2);
        }
    }

    private final void processResultSetHints(PsiElement element, InlayTreeSink sink, Function2<? super Integer, ? super String, Unit> action) {
        List expressions = null;
        String optionId = null;
        PsiElement psiElement = element;
        if (psiElement instanceof SqlExpressionList) {
            if (!(SqlImplUtil.sqlParent(element) instanceof SqlValuesExpression)) {
                return;
            }
            optionId = "sql.show.column.names.in.insert.values";
            expressions = ((SqlExpressionList)element).getExpressionList();
        } else if (psiElement instanceof SqlSelectClause) {
            optionId = "sql.show.column.names.in.select";
            expressions = ((SqlSelectClause)element).getExpressions();
        } else {
            return;
        }
        sink.whenOptionEnabled(optionId, () -> SqlColumnNamesInlayHintsProvider.processResultSetHints$lambda$6(expressions, sink, element, this, action));
    }

    private final String guessExpressionName(SqlSelectClause selectClause, int index) {
        PsiElement pp;
        PsiElement p2 = selectClause.getParent();
        while (p2 instanceof SqlQueryExpression) {
            p2 = ((SqlQueryExpression)p2).getParent();
        }
        while ((pp = p2.getParent()) instanceof SqlSetOperatorExpression) {
            p2 = pp;
        }
        if (p2 instanceof SqlSetOperatorExpression) {
            SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)PsiTreeUtil.findChildOfType((PsiElement)p2, SqlQueryExpression.class);
            if (sqlQueryExpression == null) {
                return null;
            }
            SqlQueryExpression firstQuery = sqlQueryExpression;
            if (Intrinsics.areEqual((Object)firstQuery.getSelectClause(), (Object)selectClause)) {
                return null;
            }
            DasType dasType = firstQuery.getDasType();
            SqlTableType sqlTableType = dasType instanceof SqlTableType ? (SqlTableType)dasType : null;
            if (sqlTableType == null) {
                return null;
            }
            SqlTableType type = sqlTableType;
            if (index >= type.getColumnCount()) {
                return null;
            }
            return StringUtil.trimMiddle((String)type.getColumnName(index), (int)20);
        }
        return null;
    }

    private final boolean shouldShowHintsForExpression(PsiElement element) {
        return element instanceof SqlLiteralExpression || element instanceof SqlOperatorExpression || element instanceof SqlFunctionCallExpression || element instanceof SqlReferenceExpression;
    }

    private static final boolean processCallHints$lambda$0(ResolveResult it) {
        return it instanceof SqlResolveResult && SqlFunctionsUtil.getRoutineOrConstructor(((SqlResolveResult)it).getTargetSymbol()) != null;
    }

    private static final boolean processCallHints$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit processResultSetHints$lambda$6$lambda$5$lambda$3(List $names, PsiElement psiElement, String name2) {
        if (name2 != null) {
            ((ArrayList)$names).add(name2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit processResultSetHints$lambda$6$lambda$5$lambda$4(SqlColumnNamesInlayHintsProvider this$0, PsiElement $element, int $i, Function2 $action, int $inlayOffset) {
        String name2 = this$0.guessExpressionName((SqlSelectClause)$element, $i);
        if (name2 != null) {
            $action.invoke((Object)$inlayOffset, (Object)name2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit processResultSetHints$lambda$6$lambda$5(SqlColumnNamesInlayHintsProvider this$0, SqlExpression $expression, PsiElement $element, InlayTreeSink $sink, Function2 $action, int $i) {
        Intrinsics.checkNotNull((Object)$expression);
        if (!this$0.shouldShowHintsForExpression((PsiElement)$expression)) {
            return Unit.INSTANCE;
        }
        List names = null;
        SqlValuesToColumnMapper mapper = SqlValuesToColumnMapper.Companion.getInstance$default(SqlValuesToColumnMapper.Companion, (PsiElement)$expression, false, 2, null);
        if (mapper != null) {
            IntRange indexRange = mapper.getIndexRange();
            names = new ArrayList(indexRange.getLast() - indexRange.getFirst() + 1);
            mapper.processColumnElements((Function2<? super PsiElement, ? super String, Unit>)((Function2)(arg_0, arg_1) -> SqlColumnNamesInlayHintsProvider.processResultSetHints$lambda$6$lambda$5$lambda$3(names, arg_0, arg_1)));
        } else {
            names = CollectionsKt.emptyList();
        }
        if ($expression instanceof SqlReferenceExpression && Intrinsics.areEqual((Object)((SqlReferenceExpression)$expression).getName(), (Object)CollectionsKt.singleOrNull((List)names))) {
            return Unit.INSTANCE;
        }
        int inlayOffset = $expression.getTextRange().getStartOffset();
        if (names.isEmpty() && $element instanceof SqlSelectClause) {
            $sink.whenOptionEnabled("sql.show.column.names.for.set.operations", () -> SqlColumnNamesInlayHintsProvider.processResultSetHints$lambda$6$lambda$5$lambda$4(this$0, $element, $i, $action, inlayOffset));
        } else {
            Integer n = inlayOffset;
            String string = StringUtil.join((Collection)names, (String)", ");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
            $action.invoke((Object)n, (Object)string);
        }
        return Unit.INSTANCE;
    }

    private static final Unit processResultSetHints$lambda$6(List $expressions, InlayTreeSink $sink, PsiElement $element, SqlColumnNamesInlayHintsProvider this$0, Function2 $action) {
        Iterator iterator = ((Iterable)$expressions).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string;
            int i2 = n++;
            SqlExpression expression = (SqlExpression)iterator.next();
            String string2 = string = "sql.show.column.names.for.asterisk";
            InlayTreeSink inlayTreeSink = $sink;
            boolean bl = false;
            boolean bl2 = SqlImplUtil.isAsteriskRef($element);
            InlayUtilsKt.whenOptionEnabledOrNull(inlayTreeSink, bl2 ? string : null, (Function0<Unit>)((Function0)() -> SqlColumnNamesInlayHintsProvider.processResultSetHints$lambda$6$lambda$5(this$0, expression, $element, $sink, $action, i2)));
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$processCallHints(SqlColumnNamesInlayHintsProvider $this, SqlFunctionCallExpression callExpression, Function2 action) {
        $this.processCallHints(callExpression, (Function2<? super Integer, ? super String, Unit>)action);
    }

    public static final /* synthetic */ void access$processResultSetHints(SqlColumnNamesInlayHintsProvider $this, PsiElement element, InlayTreeSink sink, Function2 action) {
        $this.processResultSetHints(element, sink, (Function2<? super Integer, ? super String, Unit>)action);
    }
}

