/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import java.time.ZoneId;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeZoneTextField
extends TextFieldWithAutoCompletion<String> {
    private TimeZoneTextField(@Nullable Project project, @NotNull TextFieldWithAutoCompletionListProvider<String> provider, boolean showCompletionHint, @Nullable String text2) {
        if (provider == null) {
            TimeZoneTextField.$$$reportNull$$$0(0);
        }
        super(project, provider, showCompletionHint, text2);
        this.adjustPreferredWidth();
    }

    private void adjustPreferredWidth() {
        int maxLength = Integer.MIN_VALUE;
        String maxZone = null;
        for (String zone : ZoneId.getAvailableZoneIds()) {
            if (zone.length() <= maxLength) continue;
            maxLength = zone.length();
            maxZone = zone;
        }
        this.setText(maxZone);
        this.ensureWillComputePreferredSize();
        this.setPreferredWidth(this.getPreferredSize().width);
    }

    public static TimeZoneTextField create(@Nullable Project project) {
        return TimeZoneTextField.create(project, ZoneId.getAvailableZoneIds());
    }

    public static TimeZoneTextField create(@Nullable Project project, @NotNull Collection<String> zones) {
        if (zones == null) {
            TimeZoneTextField.$$$reportNull$$$0(1);
        }
        return new TimeZoneTextField(project, (TextFieldWithAutoCompletionListProvider<String>)new TimeZoneCompletionProvider(zones), !zones.isEmpty(), "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zones";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/util/TimeZoneTextField";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TimeZoneCompletionProvider
    extends TextFieldWithAutoCompletion.StringsCompletionProvider {
        TimeZoneCompletionProvider(@NotNull Collection<String> variants) {
            if (variants == null) {
                TimeZoneCompletionProvider.$$$reportNull$$$0(0);
            }
            super(variants, null);
        }

        @Nullable
        public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                TimeZoneCompletionProvider.$$$reportNull$$$0(1);
            }
            return new TimeZonePrefixMatcher(prefix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variants";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/TimeZoneTextField$TimeZoneCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPrefixMatcher";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TimeZonePrefixMatcher
    extends PlainPrefixMatcher {
        private final MinusculeMatcher myMatcher;

        TimeZonePrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                TimeZonePrefixMatcher.$$$reportNull$$$0(0);
            }
            super(prefix);
            this.myMatcher = NameUtil.buildMatcher((String)prefix).build();
        }

        public boolean prefixMatches(@NotNull String name2) {
            if (name2 == null) {
                TimeZonePrefixMatcher.$$$reportNull$$$0(1);
            }
            return super.prefixMatches(name2) || this.myMatcher.matches(name2);
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                TimeZonePrefixMatcher.$$$reportNull$$$0(2);
            }
            return new TimeZonePrefixMatcher(prefix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/TimeZoneTextField$TimeZonePrefixMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prefixMatches";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cloneWithPrefix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

