/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.DatabasePluginId;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.extensions.Binding;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.script.generator.FileScriptConsumer;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.util.ObjectPath;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.CollectionFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScriptedScriptConsumer
implements FileScriptConsumer<String> {
    private final Path myRoot;
    private final Layout myLayout;
    private final PairConsumer<Path, ScriptingResult> fileWriter;
    private int myCount;
    private Map<String, String> myPathCache = new HashMap<String, String>();
    private static final Map<Path, Layout> myLayoutCache = CollectionFactory.createConcurrentSoftValueMap();
    private static final Binding<Layout> LAYOUT = new Binding("LAYOUT");

    public ScriptedScriptConsumer(Path root, Layout layout, PairConsumer<Path, ScriptingResult> writer) {
        this.myRoot = root.toAbsolutePath();
        this.myLayout = layout;
        this.fileWriter = writer;
    }

    @Override
    public boolean ignoreDependencies() {
        return this.myLayout.ignoreDependencies;
    }

    @Override
    @Nullable
    public String distribute(@NotNull BasicElement element) {
        if (element == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(0);
        }
        return this.myLayout.getBaseName(element);
    }

    @Override
    @Nullable
    public ObjectPath getScope(@NotNull Path p2) {
        Path abs;
        if (p2 == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(1);
        }
        if (!(abs = p2.toAbsolutePath()).startsWith(this.myRoot)) {
            return null;
        }
        Path relPath = this.myRoot.relativize(abs);
        return this.myLayout.getFileScope(relPath);
    }

    @Override
    public void consume(@NotNull ScriptingResult result2, String tag) {
        if (result2 == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(2);
        }
        Path file = this.getFile(tag);
        this.fileWriter.consume((Object)file, (Object)result2);
    }

    @Override
    @NotNull
    public Path getFile(String tag) {
        String subPath = this.myPathCache.computeIfAbsent(tag, t -> this.myLayout.getFileName((String)t, this.myCount++));
        Path path = this.myRoot.resolve(FileUtil.toSystemDependentName((String)ScriptedScriptConsumer.sanitize(subPath)));
        if (path == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(3);
        }
        return path;
    }

    private static String sanitize(String subPath) {
        return subPath.replace(':', '_').replace('|', '_').replace('<', '_').replace('>', '_');
    }

    @Nullable
    public static ScriptedScriptConsumer createScriptedConsumer(@NotNull Project project, @NotNull Path scriptFile, @NotNull Path root, @NotNull PairConsumer<Path, ScriptingResult> writer) throws IdeScriptException {
        Layout layout;
        if (project == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(4);
        }
        if (scriptFile == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(5);
        }
        if (root == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(6);
        }
        if (writer == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(7);
        }
        if ((layout = ScriptedScriptConsumer.getLayout(project, scriptFile)) == null) {
            return null;
        }
        return new ScriptedScriptConsumer(root, layout, writer);
    }

    @Nullable
    private static Layout getLayout(@NotNull Project project, @NotNull Path scriptFile) throws IdeScriptException {
        if (project == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(8);
        }
        if (scriptFile == null) {
            ScriptedScriptConsumer.$$$reportNull$$$0(9);
        }
        ProgressManager.checkCanceled();
        long stamp = 0L;
        try {
            stamp = Files.getLastModifiedTime(scriptFile, new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Layout layout = myLayoutCache.get(scriptFile);
        if (layout != null && layout.stamp == stamp) {
            layout.throwIfFailed();
            return layout;
        }
        IdeScriptEngine engine = ExtensionScriptsUtil.getEngineFor((Project)project, (PluginId)DatabasePluginId.get(), (Path)scriptFile, GridUtil::suggestPlugin);
        if (engine == null) {
            return null;
        }
        layout = new Layout();
        layout.stamp = stamp;
        ExtensionScriptsUtil.setBindings((IdeScriptEngine)engine).bind(LAYOUT, (Object)layout);
        myLayoutCache.put(scriptFile, layout);
        try {
            ExtensionScriptsUtil.evalScript((Project)project, (IdeScriptEngine)engine, (Path)scriptFile, (boolean)false);
        }
        catch (ProcessCanceledException pce) {
            myLayoutCache.remove(scriptFile, layout);
            throw pce;
        }
        catch (Throwable th) {
            layout.failed = th;
            layout.throwIfFailed();
        }
        return layout;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/script/generator/ScriptedScriptConsumer";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/script/generator/ScriptedScriptConsumer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "distribute";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createScriptedConsumer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLayout";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static final class Layout {
        private long stamp;
        public boolean ignoreDependencies;
        private Function<BaseNameContext, @Nullable String> myBaseName = ctx -> null;
        private Function<FileNameContext, @NotNull String> myFileName = ctx -> ctx.baseName + ".sql";
        private Function<Path, @Nullable ObjectPath> myFileScope = ctx -> null;
        private final BaseNameContext myBaseNameContext = new BaseNameContext();
        private final FileNameContext myFileNameContext = new FileNameContext();
        private Throwable failed;

        private Layout() {
        }

        public void baseName(Function<BaseNameContext, String> bn) {
            this.myBaseName = bn;
        }

        public void fileName(Function<FileNameContext, String> fn) {
            this.myFileName = fn;
        }

        public void fileScope(Function<Path, ObjectPath> fn) {
            this.myFileScope = fn;
        }

        @Nullable
        private String getBaseName(@NotNull DasObject obj2) {
            if (obj2 == null) {
                Layout.$$$reportNull$$$0(0);
            }
            this.myBaseNameContext.object = obj2;
            String res2 = (String)this.myBaseName.fun((Object)this.myBaseNameContext);
            this.myBaseNameContext.object = null;
            return res2;
        }

        @NotNull
        private String getFileName(@NotNull String baseName, int count) {
            if (baseName == null) {
                Layout.$$$reportNull$$$0(1);
            }
            this.myFileNameContext.baseName = baseName;
            this.myFileNameContext.count = count;
            String string = (String)this.myFileName.fun((Object)this.myFileNameContext);
            if (string == null) {
                Layout.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        private ObjectPath getFileScope(@NotNull Path path) {
            if (path == null) {
                Layout.$$$reportNull$$$0(3);
            }
            return (ObjectPath)this.myFileScope.fun((Object)path);
        }

        public void throwIfFailed() throws IdeScriptException {
            if (this.failed == null) {
                return;
            }
            if (this.failed instanceof IdeScriptException) {
                throw (IdeScriptException)this.failed;
            }
            ExceptionUtil.rethrow((Throwable)this.failed);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/script/generator/ScriptedScriptConsumer$Layout";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/script/generator/ScriptedScriptConsumer$Layout";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getBaseName";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileName";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileScope";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }

        public static class BaseNameContext {
            public DasObject object;
        }

        public static class FileNameContext {
            public String baseName;
            public int count;
        }
    }
}

