/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.QNameUtil;
import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlPsiFacade;
import org.jetbrains.annotations.NotNull;

public final class DbQualifiedNameProvider
implements QualifiedNameProvider {
    public PsiElement adjustElementToCopy(@NotNull PsiElement element) {
        if (element == null) {
            DbQualifiedNameProvider.$$$reportNull$$$0(0);
        }
        return element instanceof DbElement ? element : null;
    }

    public String getQualifiedName(@NotNull PsiElement element) {
        if (element == null) {
            DbQualifiedNameProvider.$$$reportNull$$$0(1);
        }
        if (!element.isValid()) {
            return null;
        }
        Project project = element.getProject();
        DbElement o = (DbElement)SqlPsiFacade.getInstance((Project)project).findRelatedDbElements(element, true).first();
        return o == null ? null : QNameUtil.getQualifiedName(o);
    }

    public PsiElement qualifiedNameToElement(@NotNull String fqn, @NotNull Project project) {
        if (fqn == null) {
            DbQualifiedNameProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            DbQualifiedNameProvider.$$$reportNull$$$0(3);
        }
        for (DbDataSource dataSource : DbPsiFacade.getInstance(project).getDataSources()) {
            DasObject result2 = (DasObject)QNameUtil.findByQName(dataSource.getModel(), fqn, DasUtil.TO_NAME).first();
            if (result2 == null) continue;
            return DbImplUtilCore.findElement(dataSource, result2);
        }
        return null;
    }

    public void insertQualifiedName(@NotNull String fqn, @NotNull PsiElement element, @NotNull Editor editor2, @NotNull Project project) {
        if (fqn == null) {
            DbQualifiedNameProvider.$$$reportNull$$$0(4);
        }
        if (element == null) {
            DbQualifiedNameProvider.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            DbQualifiedNameProvider.$$$reportNull$$$0(6);
        }
        if (project == null) {
            DbQualifiedNameProvider.$$$reportNull$$$0(7);
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)fqn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/psi/DbQualifiedNameProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustElementToCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifiedName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "qualifiedNameToElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "insertQualifiedName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

