/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.color;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.color.ColorLayer;
import com.intellij.database.datagrid.color.SelectionColorLayer;
import com.intellij.database.run.ui.DataAccessType;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HierarchicalAwareSelectionColorLayer
implements ColorLayer {
    private final SelectionColorLayer myDelegate;

    public HierarchicalAwareSelectionColorLayer(@NotNull SelectionColorLayer delegate) {
        if (delegate == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(0);
        }
        this.myDelegate = delegate;
    }

    @Override
    @Nullable
    public Color getCellBackground(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @NotNull DataGrid grid, @Nullable Color color) {
        boolean isRowSelected;
        if (row == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(1);
        }
        if (column == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(2);
        }
        if (grid == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(3);
        }
        if (SelectionColorLayer.isRowBgPaintedByTable(row, column, grid, isRowSelected = grid.getSelectionModel().isSelectedRow(row))) {
            return color;
        }
        GridColumn c = (GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column);
        if (!(c instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn)) {
            return this.myDelegate.getCellBackground(row, column, grid, color);
        }
        HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalGridColumn = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)c;
        if (GridUtil.getClosestAncestorWithSelectedDirectLeaf(grid, hierarchicalGridColumn) == null) {
            return color;
        }
        return SelectionColorLayer.getSelectedRowColor(grid, color);
    }

    @Override
    @Nullable
    public Color getRowHeaderBackground(@NotNull ModelIndex<GridRow> row, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(4);
        }
        if (grid == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(5);
        }
        return this.myDelegate.getRowHeaderBackground(row, grid, color);
    }

    @Override
    @Nullable
    public Color getColumnHeaderBackground(@NotNull ModelIndex<GridColumn> column, @NotNull DataGrid grid, @Nullable Color color) {
        if (column == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(6);
        }
        if (grid == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(7);
        }
        return this.myDelegate.getColumnHeaderBackground(column, grid, color);
    }

    @Override
    @NotNull
    public Color getRowHeaderForeground(@NotNull ModelIndex<GridRow> row, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(8);
        }
        if (grid == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(9);
        }
        Color color2 = this.myDelegate.getRowHeaderForeground(row, grid, color);
        if (color2 == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(10);
        }
        return color2;
    }

    @Override
    @NotNull
    public Color getColumnHeaderForeground(@NotNull ModelIndex<GridColumn> column, @NotNull DataGrid grid, @Nullable Color color) {
        if (column == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(11);
        }
        if (grid == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(12);
        }
        Color color2 = this.myDelegate.getColumnHeaderForeground(column, grid, color);
        if (color2 == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(13);
        }
        return color2;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    @Nullable
    public Color getColumnHeaderBackground(@NotNull ModelIndex<GridColumn> column, int headerLine, @NotNull DataGrid grid, @Nullable Color color) {
        int endLine;
        GridColumn c;
        if (column == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(14);
        }
        if (grid == null) {
            HierarchicalAwareSelectionColorLayer.$$$reportNull$$$0(15);
        }
        if (!((c = (GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column)) instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn)) {
            return this.myDelegate.getColumnHeaderBackground(column, headerLine, grid, color);
        }
        HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalColumn = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)c;
        boolean isSelected = grid.getSelectionModel().isSelectedColumn(column);
        if (hierarchicalColumn.isTopLevelColumn() && hierarchicalColumn.isLeaf() && isSelected) {
            return SelectionColorLayer.getSelectedColumnColor(grid, color);
        }
        HierarchicalColumnsDataGridModel.HierarchicalGridColumn closestAncestor = GridUtil.getClosestAncestorWithSelectedDirectLeaf(grid, hierarchicalColumn);
        if (closestAncestor == null) {
            return this.myDelegate.getColumnHeaderBackground(column, grid, color);
        }
        HierarchicalColumnsDataGridModel.HierarchicalGridColumn highestAncestor = GridUtil.getLastAncestorWithSelectedDirectLeaf(grid, closestAncestor);
        assert (highestAncestor != null);
        int startLine = Integer.max(highestAncestor.getPathFromRoot().length - 1, 0);
        if (HierarchicalAwareSelectionColorLayer.shouldHighlight(isSelected, headerLine, startLine, endLine = Integer.max(closestAncestor.getPathFromRoot().length - 1, 0))) {
            return SelectionColorLayer.getSelectedColumnColor(grid, color);
        }
        return this.myDelegate.getHeaderColor(color);
    }

    private static boolean shouldHighlight(boolean isSelected, int headerLine, int startLine, int endLine) {
        return isSelected && headerLine >= startLine || !isSelected && headerLine >= startLine && headerLine <= endLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/color/HierarchicalAwareSelectionColorLayer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/color/HierarchicalAwareSelectionColorLayer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowHeaderForeground";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnHeaderForeground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCellBackground";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRowHeaderBackground";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getColumnHeaderBackground";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRowHeaderForeground";
                break;
            }
            case 10: 
            case 13: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColumnHeaderForeground";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 13 -> new IllegalStateException(string);
        };
    }
}

