/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.completion.PyFunctionInsertHandler;
import com.jetbrains.python.codeInsight.completion.PyParameterizedTypeInsertHandler;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH$J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006 "}, d2={"Lcom/jetbrains/python/codeInsight/completion/PyImportableNameCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "importingInsertHandler", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getImportingInsertHandler", "()Lcom/intellij/codeInsight/completion/InsertHandler;", "functionInsertHandler", "getFunctionInsertHandler", "genericTypeInsertHandler", "getGenericTypeInsertHandler", "stringLiteralInsertHandler", "getStringLiteralInsertHandler", "insertStringLiteralPrefix", "", "qualifiedName", "", "name", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "fillCompletionVariants", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "doFillCompletionVariants", "shouldDoCompletion", "", "Companion", "intellij.python.psi.impl"})
public abstract class PyImportableNameCompletionContributor
extends CompletionContributor
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InsertHandler<LookupElement> importingInsertHandler = PyImportableNameCompletionContributor::importingInsertHandler$lambda$0;
    @NotNull
    private final InsertHandler<LookupElement> functionInsertHandler = (InsertHandler)new PyFunctionInsertHandler(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            int tailOffset = context.getTailOffset() - 1;
            super.handleInsert(context, item);
            context.commitDocument();
            PyImportableNameCompletionContributor.Companion.addImportForLookupElement(context, item, tailOffset);
        }
    };
    @NotNull
    private final InsertHandler<LookupElement> genericTypeInsertHandler = PyImportableNameCompletionContributor::genericTypeInsertHandler$lambda$1;
    @NotNull
    private final InsertHandler<LookupElement> stringLiteralInsertHandler = (arg_0, arg_1) -> PyImportableNameCompletionContributor.stringLiteralInsertHandler$lambda$2(this, arg_0, arg_1);

    @NotNull
    protected final InsertHandler<LookupElement> getImportingInsertHandler() {
        return this.importingInsertHandler;
    }

    @NotNull
    protected final InsertHandler<LookupElement> getFunctionInsertHandler() {
        return this.functionInsertHandler;
    }

    @NotNull
    protected final InsertHandler<LookupElement> getGenericTypeInsertHandler() {
        return this.genericTypeInsertHandler;
    }

    @NotNull
    protected final InsertHandler<LookupElement> getStringLiteralInsertHandler() {
        return this.stringLiteralInsertHandler;
    }

    private final void insertStringLiteralPrefix(String qualifiedName, String name2, InsertionContext context) {
        if (qualifiedName != null && name2 != null) {
            String string = qualifiedName.substring(0, qualifiedName.length() - name2.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String qualifiedNamePrefix = string;
            context.getDocument().insertString(context.getStartOffset(), (CharSequence)qualifiedNamePrefix);
        }
    }

    public final void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (!this.shouldDoCompletion(parameters, result2)) {
            return;
        }
        this.doFillCompletionVariants(parameters, result2);
    }

    protected abstract void doFillCompletionVariants(@NotNull CompletionParameters var1, @NotNull CompletionResultSet var2);

    private final boolean shouldDoCompletion(CompletionParameters parameters, CompletionResultSet result2) {
        String string = result2.getPrefixMatcher().getPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
        if (((CharSequence)string).length() == 0) {
            result2.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().longerThan(0));
            return false;
        }
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement element = psiElement;
        PsiElement parent = element.getParent();
        if (parent instanceof PyReferenceExpression && ((PyReferenceExpression)parent).isQualified()) {
            return false;
        }
        if (parent instanceof PyStringLiteralExpression) {
            String string2 = ((PyStringLiteralExpression)parent).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String string3 = string2;
            int n = 0;
            int n2 = parameters.getOffset() - ((PyStringLiteralExpression)parent).getTextRange().getStartOffset();
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String prefix = string4;
            if (StringsKt.contains$default((CharSequence)prefix, (CharSequence)".", (boolean)false, (int)2, null)) {
                return false;
            }
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class) == null;
    }

    private static final void importingInsertHandler$lambda$0(InsertionContext context, LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Companion.addImportForLookupElement(context, item, context.getTailOffset() - 1);
    }

    private static final void genericTypeInsertHandler$lambda$1(InsertionContext context, LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int tailOffset = context.getTailOffset() - 1;
        PyParameterizedTypeInsertHandler.INSTANCE.handleInsert(context, item);
        context.commitDocument();
        Companion.addImportForLookupElement(context, item, tailOffset);
    }

    private static final void stringLiteralInsertHandler$lambda$2(PyImportableNameCompletionContributor this$0, InsertionContext context, LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PsiElement element = item.getPsiElement();
        if (element == null) {
            return;
        }
        if (element instanceof PyQualifiedNameOwner) {
            this$0.insertStringLiteralPrefix(((PyQualifiedNameOwner)element).getQualifiedName(), ((PyQualifiedNameOwner)element).getName(), context);
        } else {
            QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath(element, null);
            if (importPath != null) {
                this$0.insertStringLiteralPrefix(importPath.toString(), String.valueOf(importPath.getLastComponent()), context);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/codeInsight/completion/PyImportableNameCompletionContributor$Companion;", "", "<init>", "()V", "addImportForLookupElement", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "tailOffset", "", "intellij.python.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void addImportForLookupElement(@NotNull InsertionContext context, @NotNull LookupElement item, int tailOffset) {
            PsiReference ref;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)context.getProject());
            Document document = manager.getDocument(context.getFile());
            if (document != null) {
                manager.commitDocument(document);
            }
            if ((ref = context.getFile().findReferenceAt(tailOffset)) == null || ref.resolve() == item.getPsiElement()) {
                return;
            }
            PsiFile[] psiFileArray = new PsiFile[]{context.getFile()};
            WriteCommandAction.writeCommandAction((Project)context.getProject(), (PsiFile[])psiFileArray).run(() -> Companion.addImportForLookupElement$lambda$0(item, context, ref));
        }

        private static final void addImportForLookupElement$lambda$0(LookupElement $item, InsertionContext $context, PsiReference $ref) {
            PsiElement psiElement = $item.getPsiElement();
            if (psiElement instanceof PsiNamedElement) {
                PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement;
                PsiFile psiFile = $context.getFile();
                PsiElement psiElement2 = $ref.getElement();
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyElement");
                AddImportHelper.addImport(psiNamedElement, psiFile, (PyElement)psiElement2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

