/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.EditorUtilKt;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.actions.styling.SelectionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH$J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0014J\b\u0010\u000e\u001a\u00020\u000fH$J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J(\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J \u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020#H\u0002R\u0012\u0010\u0010\u001a\u00020\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006+"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/BaseToggleStateAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getBoundString", "", "text", "", "selectionStart", "", "selectionEnd", "getExistingBoundString", "startOffset", "shouldMoveToWordBounds", "", "targetNodeType", "Lcom/intellij/psi/tree/IElementType;", "getTargetNodeType", "()Lcom/intellij/psi/tree/IElementType;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "setSelected", "state", "processCaret", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "removeEmphasisFromSelection", "document", "Lcom/intellij/openapi/editor/Document;", "nodeRange", "Lcom/intellij/openapi/util/TextRange;", "addEmphasisToSelection", "Companion", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nBaseToggleStateAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseToggleStateAction.kt\norg/intellij/plugins/markdown/ui/actions/styling/BaseToggleStateAction\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,166:1\n1251#2,2:167\n1251#2,2:169\n25#3:171\n25#3:172\n7#4,6:173\n*S KotlinDebug\n*F\n+ 1 BaseToggleStateAction.kt\norg/intellij/plugins/markdown/ui/actions/styling/BaseToggleStateAction\n*L\n55#1:167,2\n56#1:169,2\n82#1:171\n98#1:172\n69#1:173,6\n*E\n"})
public abstract class BaseToggleStateAction
extends ToggleAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<IElementType> elementsToIgnore;

    @NotNull
    protected abstract String getBoundString(@NotNull CharSequence var1, int var2, int var3);

    @Nullable
    protected String getExistingBoundString(@NotNull CharSequence text2, int startOffset) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return String.valueOf(text2.charAt(startOffset));
    }

    protected abstract boolean shouldMoveToWordBounds();

    @NotNull
    protected abstract IElementType getTargetNodeType();

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = MarkdownActionUtil.findMarkdownEditor$default(event, false, 2, null);
        event.getPresentation().setEnabled(editor2 != null);
        super.update(event);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isSelected(@NotNull AnActionEvent event) {
        boolean hasValidParents;
        boolean hasMissingParents;
        block7: {
            boolean bl;
            boolean bl2;
            Sequence commonParents;
            block6: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (MarkdownActionUtil.findMarkdownEditor$default(event, false, 2, null) == null) {
                    return false;
                }
                PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
                if (psiFile == null) {
                    return false;
                }
                PsiFile file = psiFile;
                Sequence sequence = SelectionUtil.obtainCaretSnapshots((AnAction)this, event);
                if (sequence == null || (sequence = CollectionsKt.asSequence((Iterable)((Iterable)sequence))) == null) {
                    return false;
                }
                Sequence caretSnapshots = sequence;
                Sequence selectionElements = SequencesKt.map((Sequence)caretSnapshots, arg_0 -> BaseToggleStateAction.isSelected$lambda$0(file, arg_0));
                Sequence $this$any$iv = commonParents = SequencesKt.map((Sequence)selectionElements, arg_0 -> BaseToggleStateAction.isSelected$lambda$1(this, arg_0));
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl3 = false;
                    if (!(it == null)) continue;
                    bl2 = true;
                    break block6;
                }
                bl2 = false;
            }
            hasMissingParents = bl2;
            Sequence $this$any$iv = commonParents;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl4 = false;
                if (!(it != null)) continue;
                bl = true;
                break block7;
            }
            bl = hasValidParents = false;
        }
        if (hasMissingParents && hasValidParents) {
            event.getPresentation().setEnabled(false);
            return false;
        }
        event.getPresentation().setEnabled(true);
        return !hasMissingParents;
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = MarkdownActionUtil.findMarkdownEditor$default(event, false, 2, null);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        ActionsKt.runWriteAction(() -> BaseToggleStateAction.setSelected$lambda$5(file, this, editor3, state));
    }

    private final void processCaret(PsiFile file, Editor editor2, Caret caret, boolean state) {
        Pair<PsiElement, PsiElement> pair = MarkdownActionUtil.getElementsUnderCaretOrSelection(file, caret);
        PsiElement first = (PsiElement)pair.component1();
        PsiElement second = (PsiElement)pair.component2();
        if (!state) {
            PsiElement parent = MarkdownActionUtil.getCommonParentOfType(first, second, this.getTargetNodeType());
            if (parent == null) {
                BaseToggleStateAction $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(BaseToggleStateAction.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Could not find enclosing element on its destruction");
                return;
            }
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            TextRange textRange = parent.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            this.removeEmphasisFromSelection(document, caret, textRange);
            return;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)first, (PsiElement)second);
        if (!elementsToIgnore.contains(PsiTreeUtilKt.getElementType((PsiElement)parent))) {
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            this.addEmphasisToSelection(document, caret);
        }
    }

    private final void removeEmphasisFromSelection(Document document, Caret caret, TextRange nodeRange) {
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence text2 = charSequence;
        String boundString = this.getExistingBoundString(text2, nodeRange.getStartOffset());
        if (boundString == null) {
            BaseToggleStateAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BaseToggleStateAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Could not fetch bound string from found node");
            return;
        }
        int boundLength = boundString.length();
        if (nodeRange.getStartOffset() + boundLength == caret.getSelectionStart() && nodeRange.getEndOffset() - boundLength == caret.getSelectionEnd()) {
            document.deleteString(nodeRange.getEndOffset() - boundLength, nodeRange.getEndOffset());
            document.deleteString(nodeRange.getStartOffset(), nodeRange.getStartOffset() + boundLength);
            return;
        }
        int from = caret.getSelectionStart();
        int to = caret.getSelectionEnd();
        if (this.shouldMoveToWordBounds()) {
            while (from - boundLength > nodeRange.getStartOffset() && Character.isWhitespace(text2.charAt(from - 1))) {
                --from;
            }
            while (to + boundLength < nodeRange.getEndOffset() && Character.isWhitespace(text2.charAt(to))) {
                ++to;
            }
        }
        if (to + boundLength == nodeRange.getEndOffset()) {
            document.deleteString(nodeRange.getEndOffset() - boundLength, nodeRange.getEndOffset());
        } else {
            document.insertString(to, (CharSequence)boundString);
        }
        if (from - boundLength == nodeRange.getStartOffset()) {
            document.deleteString(nodeRange.getStartOffset(), nodeRange.getStartOffset() + boundLength);
        } else {
            document.insertString(from, (CharSequence)boundString);
        }
    }

    private final void addEmphasisToSelection(Document document, Caret caret) {
        int from;
        int to = caret.getSelectionEnd();
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence text2 = charSequence;
        if (this.shouldMoveToWordBounds()) {
            for (from = caret.getSelectionStart(); from < to && Character.isWhitespace(text2.charAt(from)); ++from) {
            }
            while (to > from && Character.isWhitespace(text2.charAt(to - 1))) {
                --to;
            }
            if (from == to) {
                from = caret.getSelectionStart();
                to = caret.getSelectionEnd();
            }
        }
        String boundString = this.getBoundString(text2, from, to);
        document.insertString(to, (CharSequence)boundString);
        document.insertString(from, (CharSequence)boundString);
        if (caret.getSelectionStart() == caret.getSelectionEnd()) {
            caret.moveCaretRelatively(boundString.length(), 0, false, false);
        }
    }

    private static final Pair isSelected$lambda$0(PsiFile $file, SelectionUtil.CaretSnapshot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MarkdownActionUtil.getElementsUnderCaretOrSelection($file, it.getSelectionStart(), it.getSelectionEnd());
    }

    private static final PsiElement isSelected$lambda$1(BaseToggleStateAction this$0, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        PsiElement left = (PsiElement)pair.component1();
        PsiElement right = (PsiElement)pair.component2();
        return MarkdownActionUtil.getCommonParentOfType(left, right, this$0.getTargetNodeType());
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit setSelected$lambda$5(PsiFile $file, BaseToggleStateAction this$0, Editor $editor, boolean $state) {
        void project$iv;
        Project project = $file.getProject();
        String name$iv = this$0.getTemplatePresentation().getText();
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand((Project)project$iv, new Runnable($editor, this$0, $file, $state){
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ BaseToggleStateAction this$0;
            final /* synthetic */ PsiFile $file$inlined;
            final /* synthetic */ boolean $state$inlined;
            {
                this.$editor$inlined = editor2;
                this.this$0 = baseToggleStateAction;
                this.$file$inlined = psiFile;
                this.$state$inlined = bl;
            }

            public final void run() {
                boolean bl = false;
                CaretModel caretModel = this.$editor$inlined.getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
                EditorUtilKt.runForEachCaret(caretModel, true, (Function1<? super Caret, Unit>)((Function1)new Function1<Caret, Unit>(this.this$0, this.$file$inlined, this.$editor$inlined, this.$state$inlined){
                    final /* synthetic */ BaseToggleStateAction this$0;
                    final /* synthetic */ PsiFile $file;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ boolean $state;
                    {
                        this.this$0 = $receiver;
                        this.$file = $file;
                        this.$editor = $editor;
                        this.$state = $state;
                    }

                    public final void invoke(Caret caret) {
                        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                        BaseToggleStateAction.access$processCaret(this.this$0, this.$file, this.$editor, caret, this.$state);
                    }
                }));
            }
        }, name$iv, groupId$iv);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$processCaret(BaseToggleStateAction $this, PsiFile file, Editor editor2, Caret caret, boolean state) {
        $this.processCaret(file, editor2, caret, state);
    }

    static {
        Object[] objectArray = new IElementType[]{MarkdownElementTypes.LINK_DESTINATION, MarkdownElementTypes.AUTOLINK, MarkdownTokenTypes.GFM_AUTOLINK};
        elementsToIgnore = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/BaseToggleStateAction$Companion;", "", "<init>", "()V", "elementsToIgnore", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

