/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.flavours.commonmark.CommonMarkMarkerProcessor;
import org.intellij.markdown.flavours.gfm.GFMConstraints;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.table.GitHubTableMarkerProvider;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.providers.AtxHeaderProvider;
import org.intellij.markdown.parser.markerblocks.providers.BlockQuoteProvider;
import org.intellij.markdown.parser.markerblocks.providers.CodeBlockProvider;
import org.intellij.markdown.parser.markerblocks.providers.HorizontalRuleProvider;
import org.intellij.markdown.parser.markerblocks.providers.HtmlBlockProvider;
import org.intellij.markdown.parser.markerblocks.providers.ListMarkerProvider;
import org.intellij.markdown.parser.markerblocks.providers.SetextHeaderProvider;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.plugins.markdown.lang.parser.blocks.CodeFenceMarkerProvider;
import org.intellij.plugins.markdown.lang.parser.blocks.CommentAwareLinkReferenceDefinitionProvider;
import org.intellij.plugins.markdown.lang.parser.blocks.DefinitionListMarkerProvider;
import org.intellij.plugins.markdown.lang.parser.blocks.frontmatter.FrontMatterHeaderMarkerProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bR\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fH\u0014\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/MarkdownDefaultMarkerProcessor;", "Lorg/intellij/markdown/flavours/commonmark/CommonMarkMarkerProcessor;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "constraintsBase", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "<init>", "(Lorg/intellij/markdown/parser/ProductionHolder;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;)V", "populateConstraintsTokens", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "getMarkerBlockProviders", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "Factory", "intellij.markdown"})
public class MarkdownDefaultMarkerProcessor
extends CommonMarkMarkerProcessor {
    public MarkdownDefaultMarkerProcessor(@NotNull ProductionHolder productionHolder, @NotNull MarkdownConstraints constraintsBase) {
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)constraintsBase, (String)"constraintsBase");
        super(productionHolder, constraintsBase);
    }

    protected void populateConstraintsTokens(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints, @NotNull ProductionHolder productionHolder) {
        int offset;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        if (!(constraints instanceof GFMConstraints) || !((GFMConstraints)constraints).hasCheckbox()) {
            super.populateConstraintsTokens(pos, constraints, productionHolder);
            return;
        }
        String line = pos.getCurrentLine();
        for (offset = pos.getOffsetInCurrentLine(); offset < line.length() && line.charAt(offset) != '['; ++offset) {
        }
        if (offset == line.length()) {
            super.populateConstraintsTokens(pos, constraints, productionHolder);
            return;
        }
        if (!(!(((GFMConstraints)constraints).getTypes().length == 0))) {
            throw new IllegalStateException("Check failed.");
        }
        IElementType type = switch (ArraysKt.last((char[])((GFMConstraints)constraints).getTypes())) {
            case '>' -> MarkdownTokenTypes.BLOCK_QUOTE;
            case ')', '.' -> MarkdownTokenTypes.LIST_NUMBER;
            default -> MarkdownTokenTypes.LIST_BULLET;
        };
        int middleOffset = pos.getOffset() - pos.getOffsetInCurrentLine() + offset;
        int endOffset = Math.min(pos.getOffset() - pos.getOffsetInCurrentLine() + MarkdownConstraintsKt.getCharsEaten((MarkdownConstraints)constraints, (CharSequence)pos.getCurrentLine()), pos.getNextLineOrEofOffset());
        Object[] objectArray = new SequentialParser.Node[]{new SequentialParser.Node(new IntRange(pos.getOffset(), middleOffset), type), new SequentialParser.Node(new IntRange(middleOffset, endOffset), GFMTokenTypes.CHECK_BOX)};
        productionHolder.addProduction((Collection)CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    protected List<MarkerBlockProvider<MarkerProcessor.StateInfo>> getMarkerBlockProviders() {
        List list2;
        List $this$getMarkerBlockProviders_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getMarkerBlockProviders_u24lambda_u240.add(new CodeBlockProvider());
        $this$getMarkerBlockProviders_u24lambda_u240.add(new CodeFenceMarkerProvider());
        $this$getMarkerBlockProviders_u24lambda_u240.add(new SetextHeaderProvider());
        $this$getMarkerBlockProviders_u24lambda_u240.add(new BlockQuoteProvider());
        $this$getMarkerBlockProviders_u24lambda_u240.add(new ListMarkerProvider());
        $this$getMarkerBlockProviders_u24lambda_u240.add(new HtmlBlockProvider());
        $this$getMarkerBlockProviders_u24lambda_u240.add(new DefinitionListMarkerProvider());
        $this$getMarkerBlockProviders_u24lambda_u240.add(new FrontMatterHeaderMarkerProvider());
        $this$getMarkerBlockProviders_u24lambda_u240.add(new HorizontalRuleProvider());
        $this$getMarkerBlockProviders_u24lambda_u240.add(new GitHubTableMarkerProvider());
        $this$getMarkerBlockProviders_u24lambda_u240.add(new AtxHeaderProvider());
        $this$getMarkerBlockProviders_u24lambda_u240.add(new CommentAwareLinkReferenceDefinitionProvider());
        return CollectionsKt.build((List)list2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/MarkdownDefaultMarkerProcessor$Factory;", "Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "<init>", "()V", "createMarkerProcessor", "Lorg/intellij/markdown/parser/MarkerProcessor;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "intellij.markdown"})
    public static final class Factory
    implements MarkerProcessorFactory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @NotNull
        public MarkerProcessor<?> createMarkerProcessor(@NotNull ProductionHolder productionHolder) {
            Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
            return (MarkerProcessor)new MarkdownDefaultMarkerProcessor(productionHolder, (MarkdownConstraints)GFMConstraints.Companion.getBASE());
        }
    }
}

