/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.scripts.SourceContentFile;
import com.intellij.javascript.debugger.scripts.VmScriptFileSystemKt;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;
import org.jetbrains.wip.ScriptUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b\"-\u0010\u0000\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \u0004*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"SOURCE_CONTENT_KEY", "Lcom/intellij/openapi/util/Key;", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "createVmFile", "url", "Lcom/intellij/util/Url;", "script", "Lcom/intellij/openapi/util/UserDataHolder;", "normalizedSource", "", "sourceIndex", "", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "findRemoteFile", "Lorg/jetbrains/debugger/Script;", "intellij.javascript.debugger"})
public final class ScriptsKt {
    @NotNull
    private static final Key<Int2ObjectMap<VirtualFile>> SOURCE_CONTENT_KEY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final VirtualFile createVmFile(@NotNull Url url, @NotNull UserDataHolder script, @NotNull String normalizedSource, int sourceIndex) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)normalizedSource, (String)"normalizedSource");
        Object map = null;
        map = SOURCE_CONTENT_KEY.get(script);
        if (map == null) {
            map = new Int2ObjectOpenHashMap();
            SOURCE_CONTENT_KEY.set(script, map);
        }
        Object object = map;
        synchronized (object) {
            boolean bl = false;
            VirtualFile file = (VirtualFile)((Int2ObjectMap)map).get(sourceIndex);
            if (file == null) {
                file = (VirtualFile)new SourceContentFile(url, normalizedSource);
                ((SourceContentFile)file).putUserData(JavaScriptIndex.SKIP_STUB_CREATION, true);
                ((Int2ObjectMap)map).put(sourceIndex, (Object)file);
            }
            VirtualFile virtualFile = file;
            return virtualFile;
        }
    }

    @NotNull
    public static final FileType getFileType(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(url.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
        FileType type = fileType;
        if (type != FileTypes.UNKNOWN) {
            return type;
        }
        for (FileUrlMapper fileUrlMapper : (FileUrlMapper[])FileUrlMapper.EP_NAME.getExtensions()) {
            FileType it;
            if (fileUrlMapper.getFileType(url) == null) continue;
            boolean bl = false;
            if (it == FileTypes.UNKNOWN) continue;
            return it;
        }
        return (FileType)JavaScriptFileType.INSTANCE;
    }

    @Nullable
    public static final VirtualFile findRemoteFile(@NotNull Script script, @NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        VirtualFile file = null;
        if (url.isInLocalFileSystem()) {
            file = LocalFileSystem.getInstance().findFileByPath(url.getPath());
        }
        if (file != null) {
            return file;
        }
        if (Intrinsics.areEqual((Object)url.getScheme(), (Object)"http") || Intrinsics.areEqual((Object)url.getScheme(), (Object)"https")) {
            file = VirtualFileManager.getInstance().findFileByUrl(url.toExternalForm());
        } else if (url == script.getUrl()) {
            file = (VirtualFile)VmScriptFileSystemKt.getVmFile(script);
        } else if (!ScriptUtilsKt.isSpecialUrl((Url)url)) {
            file = VirtualFileManager.getInstance().findFileByUrl(url.toExternalForm());
        }
        return file;
    }

    static {
        Key key = Key.create((String)"actual source content");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SOURCE_CONTENT_KEY = key;
    }
}

