/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.breakpoints.JavaScriptBreakpointType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public final class JavaScriptBreakpointListener
implements XBreakpointListener<XBreakpoint<?>> {
    @NotNull
    private final Project myProject;

    public JavaScriptBreakpointListener(@NotNull Project project) {
        if (project == null) {
            JavaScriptBreakpointListener.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void breakpointAdded(@NotNull XBreakpoint breakpoint) {
        if (breakpoint == null) {
            JavaScriptBreakpointListener.$$$reportNull$$$0(1);
        }
        this.checkBreakpoint(breakpoint);
    }

    public void breakpointChanged(@NotNull XBreakpoint breakpoint) {
        if (breakpoint == null) {
            JavaScriptBreakpointListener.$$$reportNull$$$0(2);
        }
        this.checkBreakpoint(breakpoint);
    }

    private void checkBreakpoint(@NotNull XBreakpoint<?> xBreakpoint) {
        XLineBreakpoint breakpoint;
        block6: {
            block5: {
                if (xBreakpoint == null) {
                    JavaScriptBreakpointListener.$$$reportNull$$$0(3);
                }
                if (!(xBreakpoint instanceof XLineBreakpoint)) break block5;
                breakpoint = (XLineBreakpoint)xBreakpoint;
                if (xBreakpoint.getType() instanceof JavaScriptBreakpointType) break block6;
            }
            return;
        }
        XSourcePosition sourcePosition2 = breakpoint.getSourcePosition();
        if (sourcePosition2 == null) {
            return;
        }
        DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            PsiFile psiFile;
            XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
            VirtualFile file = sourcePosition2.getFile();
            FileType fileType = file.getFileType();
            String errorMessage = null;
            if (JsFileUtil.isTemplateFileType(fileType)) {
                errorMessage = JSDebuggerBundle.message("error.message.breakpoint.in.0.files.are.not.supported", fileType.getName());
                breakpointManager.updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, errorMessage);
            } else if (HtmlUtil.isHtmlFile((VirtualFile)file) && (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file)) != null && psiFile.getLanguage() instanceof TemplateLanguage) {
                errorMessage = JSDebuggerBundle.message("error.message.breakpoint.in.0.files.are.not.supported", "generated HTML");
            }
            if (errorMessage != null) {
                breakpointManager.updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, errorMessage);
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xBreakpoint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "breakpointAdded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "breakpointChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBreakpoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

