/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.backend.split;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChangeAssigner;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.platform.vcs.backend.split.BackendActiveChangeListTrackerKt;
import com.intellij.platform.vcs.backend.split.BackendChangeListManager;
import com.intellij.platform.vcs.backend.split.HostVcsAppSettings;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002$%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0012H\u0002J\b\u0010\"\u001a\u00020#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR/\u0010\u000f\u001a#\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00120\u00120\u0010\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0013\u001a#\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00120\u00120\u0010\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/platform/vcs/backend/split/BackendChangeListChangeAssigner;", "Lcom/intellij/openapi/vcs/changes/ChangeListChangeAssigner;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "Lorg/jetbrains/annotations/NotNull;", "vcsManager", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "pendingFilesToMove", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/codeWithMe/ClientId;", "Lcom/intellij/openapi/vcs/FilePath;", "activeFilesToMove", "beforeChangesProcessing", "", "dirtyScope", "Lcom/intellij/openapi/vcs/changes/VcsDirtyScope;", "markChangesProcessed", "getChangeListIdFor", "", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "gate", "Lcom/intellij/openapi/vcs/changes/ChangeListManagerGate;", "getClientIdFor", "prepareFileToMoveIntoChangelist", "filePath", "shouldMoveChangeIntoGuestChangelist", "", "MyDocumentListener", "MyVirtualFileListener", "intellij.platform.vcs.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendActiveChangeListTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendActiveChangeListTracker.kt\ncom/intellij/platform/vcs/backend/split/BackendChangeListChangeAssigner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n827#2:245\n855#2,2:246\n*S KotlinDebug\n*F\n+ 1 BackendActiveChangeListTracker.kt\ncom/intellij/platform/vcs/backend/split/BackendChangeListChangeAssigner\n*L\n112#1:245\n112#1:246,2\n*E\n"})
public final class BackendChangeListChangeAssigner
implements ChangeListChangeAssigner {
    @NotNull
    private final Project project;
    @NotNull
    private final ChangeListManager changeListManager;
    private final ProjectLevelVcsManager vcsManager;
    @NotNull
    private final MultiMap<ClientId, FilePath> pendingFilesToMove;
    @NotNull
    private final MultiMap<ClientId, FilePath> activeFilesToMove;

    public BackendChangeListChangeAssigner(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        this.changeListManager = changeListManager;
        this.vcsManager = ProjectLevelVcsManager.getInstance((Project)this.project);
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createSet(...)");
        this.pendingFilesToMove = multiMap;
        MultiMap multiMap2 = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"createSet(...)");
        this.activeFilesToMove = multiMap2;
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)this.project);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.project);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new MyVirtualFileListener());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeChangesProcessing(@Nullable VcsDirtyScope dirtyScope) {
        MultiMap<ClientId, FilePath> multiMap = this.pendingFilesToMove;
        synchronized (multiMap) {
            boolean bl = false;
            boolean bl2 = this.activeFilesToMove.isEmpty();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.activeFilesToMove.putAllValues(this.pendingFilesToMove);
            this.pendingFilesToMove.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void markChangesProcessed(@Nullable VcsDirtyScope dirtyScope) {
        MultiMap<ClientId, FilePath> multiMap3;
        if (dirtyScope == null) {
            this.activeFilesToMove.clear();
            return;
        }
        MultiMap multiMap2 = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"createSet(...)");
        MultiMap toKeep = multiMap2;
        for (MultiMap<ClientId, FilePath> multiMap3 : this.activeFilesToMove.entrySet()) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            Intrinsics.checkNotNull((Object)multiMap3);
            ClientId clientId = (ClientId)multiMap3.getKey();
            Collection filePaths = (Collection)multiMap3.getValue();
            Intrinsics.checkNotNull((Object)filePaths);
            Iterable iterable = filePaths;
            ClientId clientId2 = clientId;
            MultiMap multiMap4 = toKeep;
            boolean $i$f$filterNot = false;
            void var9_12 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                FilePath it = (FilePath)element$iv$iv;
                boolean bl = false;
                if (dirtyScope.belongsTo(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            multiMap4.putValues((Object)clientId2, (Collection)list);
        }
        this.activeFilesToMove.clear();
        multiMap3 = this.pendingFilesToMove;
        synchronized (multiMap3) {
            boolean bl = false;
            this.pendingFilesToMove.putAllValues(toKeep);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public String getChangeListIdFor(@NotNull Change change, @NotNull ChangeListManagerGate gate) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter((Object)gate, (String)"gate");
        if (!HostVcsAppSettings.Companion.getInstance().getCreateChangeListsForGuestChanges()) {
            return null;
        }
        ClientId clientId = this.getClientIdFor(change);
        if (clientId == null) {
            return null;
        }
        ClientId clientId2 = clientId;
        ClientAppSession clientAppSession = ClientSessionsManager.Companion.getAppSession(clientId2);
        boolean bl = clientAppSession != null ? clientAppSession.isOwner() : false;
        if (bl) {
            return null;
        }
        LocalChangeList localChangeList = BackendChangeListManager.Companion.getInstance(this.project).createChangeListFor(clientId2, gate);
        return localChangeList != null ? localChangeList.getId() : null;
    }

    private final ClientId getClientIdFor(Change change) {
        for (Map.Entry entry : this.activeFilesToMove.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            ClientId clientId = (ClientId)entry.getKey();
            Collection filePaths = (Collection)entry.getValue();
            FilePath bPath = ChangesUtil.getBeforePath((Change)change);
            FilePath aPath = ChangesUtil.getAfterPath((Change)change);
            if ((bPath == null || !filePaths.contains(bPath)) && (aPath == null || !filePaths.contains(aPath))) continue;
            return clientId;
        }
        if (change.getType() == Change.Type.NEW) {
            ClientId clientId;
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = virtualFile = change.getVirtualFile();
            Object object = clientId = virtualFile2 != null ? BackendActiveChangeListTrackerKt.access$getVcsClientId(virtualFile2) : null;
            if (clientId != null) {
                BackendActiveChangeListTrackerKt.access$setVcsClientId(virtualFile, null);
                return clientId;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void prepareFileToMoveIntoChangelist(FilePath filePath) {
        if (this.vcsManager.getVcsFor(filePath) != null) {
            MultiMap<ClientId, FilePath> multiMap = this.pendingFilesToMove;
            synchronized (multiMap) {
                boolean bl = false;
                this.pendingFilesToMove.putValue((Object)ClientId.Companion.getCurrent(), (Object)filePath);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private final boolean shouldMoveChangeIntoGuestChangelist() {
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            return false;
        }
        if (!HostVcsAppSettings.Companion.getInstance().getCreateChangeListsForGuestChanges()) {
            return false;
        }
        return this.changeListManager.areChangeListsEnabled();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/vcs/backend/split/BackendChangeListChangeAssigner$MyDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "<init>", "(Lcom/intellij/platform/vcs/backend/split/BackendChangeListChangeAssigner;)V", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.platform.vcs.backend.split"})
    private final class MyDocumentListener
    implements DocumentListener {
        public void documentChanged(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            if (!BackendChangeListChangeAssigner.this.shouldMoveChangeIntoGuestChangelist()) {
                return;
            }
            Document document = event.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            LocalChangeList changeList = BackendChangeListChangeAssigner.this.changeListManager.getChangeList(virtualFile2);
            if (changeList == null) {
                FilePath filePath = VcsUtil.getFilePath((VirtualFile)virtualFile2);
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
                BackendChangeListChangeAssigner.this.prepareFileToMoveIntoChangelist(filePath);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\t\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/vcs/backend/split/BackendChangeListChangeAssigner$MyVirtualFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "<init>", "(Lcom/intellij/platform/vcs/backend/split/BackendChangeListChangeAssigner;)V", "before", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "after", "handleModifiedFile", "path", "", "handleNewFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.backend.split"})
    private final class MyVirtualFileListener
    implements BulkFileListener {
        public void before(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            if (!BackendChangeListChangeAssigner.this.shouldMoveChangeIntoGuestChangelist()) {
                return;
            }
            for (VFileEvent vFileEvent : events) {
                VirtualFile virtualFile = vFileEvent.getFile();
                if (virtualFile != null ? !virtualFile.isInLocalFileSystem() : false) continue;
                if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).isRename()) {
                    String string = ((VFilePropertyChangeEvent)vFileEvent).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    this.handleModifiedFile(string);
                    continue;
                }
                if (vFileEvent instanceof VFileDeleteEvent) {
                    String string = ((VFileDeleteEvent)vFileEvent).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    this.handleModifiedFile(string);
                    continue;
                }
                if (vFileEvent instanceof VFileMoveEvent) {
                    String string = ((VFileMoveEvent)vFileEvent).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    this.handleModifiedFile(string);
                    continue;
                }
                if (!(vFileEvent instanceof VFileContentChangeEvent)) continue;
                String string = ((VFileContentChangeEvent)vFileEvent).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                this.handleModifiedFile(string);
            }
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            if (!BackendChangeListChangeAssigner.this.shouldMoveChangeIntoGuestChangelist()) {
                return;
            }
            for (VFileEvent vFileEvent : events) {
                VirtualFile virtualFile = vFileEvent.getFile();
                if (virtualFile != null ? !virtualFile.isInLocalFileSystem() : false) continue;
                if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).isRename()) {
                    VirtualFile virtualFile2 = ((VFilePropertyChangeEvent)vFileEvent).getFile();
                    String string = ((VFilePropertyChangeEvent)vFileEvent).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    this.handleNewFile(virtualFile2, string);
                    continue;
                }
                if (vFileEvent instanceof VFileCreateEvent) {
                    VirtualFile virtualFile3 = ((VFileCreateEvent)vFileEvent).getFile();
                    String string = ((VFileCreateEvent)vFileEvent).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    this.handleNewFile(virtualFile3, string);
                    continue;
                }
                if (vFileEvent instanceof VFileMoveEvent) {
                    VirtualFile virtualFile4 = ((VFileMoveEvent)vFileEvent).getFile();
                    String string = ((VFileMoveEvent)vFileEvent).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    this.handleNewFile(virtualFile4, string);
                    continue;
                }
                if (!(vFileEvent instanceof VFileCopyEvent)) continue;
                VirtualFile virtualFile5 = ((VFileCopyEvent)vFileEvent).findCreatedFile();
                String string = ((VFileCopyEvent)vFileEvent).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                this.handleNewFile(virtualFile5, string);
            }
        }

        private final void handleModifiedFile(String path) {
            FilePath filePath = VcsUtil.getFilePath((String)path);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
            BackendChangeListChangeAssigner.this.prepareFileToMoveIntoChangelist(filePath);
        }

        private final void handleNewFile(VirtualFile file, String path) {
            FilePath filePath = VcsUtil.getFilePath((String)path);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
            BackendChangeListChangeAssigner.this.prepareFileToMoveIntoChangelist(filePath);
            if (file != null) {
                BackendActiveChangeListTrackerKt.access$setVcsClientId(file, ClientId.Companion.getCurrent());
            }
        }
    }
}

