/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.presentation;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.FontFace;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.base.theme.ThemeTextStyle;
import org.jetbrains.letsPlot.core.plot.builder.presentation.Defaults;
import org.jetbrains.letsPlot.datamodel.svg.style.StyleSheet;
import org.jetbrains.letsPlot.datamodel.svg.style.TextStyle;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/presentation/Style;", "", "()V", "AXIS_TEXT", "", "AXIS_TITLE", "AXIS_TOOLTIP_TEXT", "CSS", "FACET_STRIP_TEXT", "LEGEND_ITEM", "LEGEND_TITLE", "PLOT_CAPTION", "PLOT_CONTAINER", "PLOT_SUBTITLE", "PLOT_TITLE", "TOOLTIP_LABEL", "TOOLTIP_TEXT", "TOOLTIP_TITLE", "default", "Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;", "fromTheme", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "flippedAxis", "", "generateCSS", "styleSheet", "plotId", "decorationLayerId", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nStyle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Style.kt\norg/jetbrains/letsPlot/core/plot/builder/presentation/Style\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1855#2,2:124\n*S KotlinDebug\n*F\n+ 1 Style.kt\norg/jetbrains/letsPlot/core/plot/builder/presentation/Style\n*L\n52#1:124,2\n*E\n"})
public final class Style {
    @NotNull
    public static final Style INSTANCE = new Style();
    @NotNull
    public static final String PLOT_CONTAINER = "plt-container";
    @NotNull
    public static final String PLOT_TITLE = "plot-title";
    @NotNull
    public static final String PLOT_SUBTITLE = "plot-subtitle";
    @NotNull
    public static final String PLOT_CAPTION = "plot-caption";
    @NotNull
    public static final String AXIS_TITLE = "axis-title";
    @NotNull
    public static final String AXIS_TEXT = "axis-text";
    @NotNull
    public static final String LEGEND_TITLE = "legend-title";
    @NotNull
    public static final String LEGEND_ITEM = "legend-item";
    @NotNull
    public static final String TOOLTIP_TEXT = "tooltip-text";
    @NotNull
    public static final String TOOLTIP_TITLE = "tooltip-title";
    @NotNull
    public static final String TOOLTIP_LABEL = "tooltip-label";
    @NotNull
    public static final String AXIS_TOOLTIP_TEXT = "axis-tooltip-text";
    @NotNull
    public static final String FACET_STRIP_TEXT = "facet-strip-text";
    @NotNull
    private static final String CSS = ".plt-container {\n   font-family: Lucida Grande, sans-serif;\n   user-select: none;\n   -webkit-user-select: none;\n   -moz-user-select: none;\n   -ms-user-select: none;\n}\ntext {\n   text-rendering: optimizeLegibility;\n}";

    private Style() {
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String generateCSS(@NotNull StyleSheet styleSheet, @Nullable String plotId, @Nullable String decorationLayerId) {
        Intrinsics.checkNotNullParameter((Object)styleSheet, (String)"styleSheet");
        css = new StringBuilder(Style.CSS);
        css.append('\n');
        $this$forEach$iv = styleSheet.getClasses();
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block12: {
                className = (String)element$iv;
                $i$a$-forEach-Style$generateCSS$1 = false;
                var11_11 = className;
                switch (var11_11.hashCode()) {
                    case 178593975: {
                        if (!var11_11.equals("tooltip-text")) {
                            break;
                        }
                        ** GOTO lbl30
                    }
                    case 1233917098: {
                        if (!var11_11.equals("tooltip-label")) {
                            break;
                        }
                        ** GOTO lbl30
                    }
                    case 1033192591: {
                        if (!var11_11.equals("axis-tooltip-text-y")) {
                            break;
                        }
                        ** GOTO lbl30
                    }
                    case 1033192590: {
                        if (!var11_11.equals("axis-tooltip-text-x")) {
                            break;
                        }
                        ** GOTO lbl30
                    }
                    case 1241561102: {
                        if (!var11_11.equals("tooltip-title")) break;
lbl30:
                        // 5 sources

                        v0 = decorationLayerId;
                        break block12;
                    }
                }
                v0 = plotId;
            }
            id = v0;
            css.append(styleSheet.toCSS(className, id));
        }
        v1 = css.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toString(...)");
        return v1;
    }

    @NotNull
    public final StyleSheet default() {
        return new StyleSheet(Defaults.INSTANCE.getDEFAULT_TEXT_STYLES$plot_builder(), "Lucida Grande, sans-serif");
    }

    @NotNull
    public final StyleSheet fromTheme(@NotNull Theme theme2, boolean flippedAxis) {
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        AxisTheme hAxisTheme = theme2.horizontalAxis(flippedAxis);
        String hAxisName = flippedAxis ? "y" : "x";
        AxisTheme vAxisTheme = theme2.verticalAxis(flippedAxis);
        String vAxisName = flippedAxis ? "x" : "y";
        Pair[] pairArray = new Pair[17];
        pairArray[0] = TuplesKt.to((Object)PLOT_TITLE, (Object)Style.fromTheme$ts(theme2.plot().titleStyle()));
        pairArray[1] = TuplesKt.to((Object)PLOT_SUBTITLE, (Object)Style.fromTheme$ts(theme2.plot().subtitleStyle()));
        pairArray[2] = TuplesKt.to((Object)PLOT_CAPTION, (Object)Style.fromTheme$ts(theme2.plot().captionStyle()));
        Color color = theme2.colors().brush();
        FontFace fontFace = FontFace.Companion.getNORMAL();
        pairArray[3] = TuplesKt.to((Object)"hyperlink-element", (Object)new TextStyle("", fontFace, -1.0, color));
        pairArray[4] = TuplesKt.to((Object)LEGEND_TITLE, (Object)Style.fromTheme$ts(theme2.legend().titleStyle()));
        pairArray[5] = TuplesKt.to((Object)LEGEND_ITEM, (Object)Style.fromTheme$ts(theme2.legend().textStyle()));
        pairArray[6] = TuplesKt.to((Object)("axis-title-" + hAxisName), (Object)Style.fromTheme$ts(hAxisTheme.titleStyle()));
        pairArray[7] = TuplesKt.to((Object)("axis-text-" + hAxisName), (Object)Style.fromTheme$ts(hAxisTheme.labelStyle()));
        pairArray[8] = TuplesKt.to((Object)("axis-tooltip-text-" + hAxisName), (Object)Style.fromTheme$ts(hAxisTheme.tooltipTextStyle()));
        pairArray[9] = TuplesKt.to((Object)("axis-title-" + vAxisName), (Object)Style.fromTheme$ts(vAxisTheme.titleStyle()));
        pairArray[10] = TuplesKt.to((Object)("axis-text-" + vAxisName), (Object)Style.fromTheme$ts(vAxisTheme.labelStyle()));
        pairArray[11] = TuplesKt.to((Object)("axis-tooltip-text-" + vAxisName), (Object)Style.fromTheme$ts(vAxisTheme.tooltipTextStyle()));
        pairArray[12] = TuplesKt.to((Object)"facet-strip-text-x", (Object)Style.fromTheme$ts(theme2.facets().horizontalFacetStrip().stripTextStyle()));
        pairArray[13] = TuplesKt.to((Object)"facet-strip-text-y", (Object)Style.fromTheme$ts(theme2.facets().verticalFacetStrip().stripTextStyle()));
        pairArray[14] = TuplesKt.to((Object)TOOLTIP_TEXT, (Object)Style.fromTheme$ts(theme2.tooltips().textStyle()));
        pairArray[15] = TuplesKt.to((Object)TOOLTIP_TITLE, (Object)Style.fromTheme$ts(theme2.tooltips().titleStyle()));
        pairArray[16] = TuplesKt.to((Object)TOOLTIP_LABEL, (Object)Style.fromTheme$ts(theme2.tooltips().labelStyle()));
        Map textStyles = MapsKt.mapOf((Pair[])pairArray);
        return new StyleSheet(textStyles, "Lucida Grande, sans-serif");
    }

    private static final TextStyle fromTheme$ts(ThemeTextStyle themeStyle) {
        return new TextStyle(themeStyle.getFamily().getName(), themeStyle.getFace(), themeStyle.getSize(), themeStyle.getColor());
    }
}

