/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.defaultTheme;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.layout.TextJustification;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.core.plot.base.theme.FontFamilyRegistry;
import org.jetbrains.letsPlot.core.plot.base.theme.PlotTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.ThemeTextStyle;
import org.jetbrains.letsPlot.core.plot.base.theme.TitlePosition;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.ThemeValuesAccess;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\"H\u0016J\b\u0010(\u001a\u00020\"H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020*H\u0016J\b\u0010,\u001a\u00020*H\u0016J\b\u0010-\u001a\u00020*H\u0016J\b\u0010.\u001a\u00020*H\u0016J\b\u0010/\u001a\u00020 H\u0016J\b\u00100\u001a\u00020\"H\u0016J\b\u00101\u001a\u00020&H\u0016J\b\u00102\u001a\u00020\u0019H\u0016J\b\u00103\u001a\u00020&H\u0016J\b\u00104\u001a\u00020 H\u0016J\b\u00105\u001a\u00020\"H\u0016J\b\u00106\u001a\u00020$H\u0016J\b\u00107\u001a\u00020&H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\r\u00a8\u00068"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/DefaultPlotTheme;", "Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeValuesAccess;", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PlotTheme;", "options", "", "", "", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;)V", "backgroundKey", "", "getBackgroundKey$plot_builder", "()Ljava/util/List;", "captionKey", "getCaptionKey$plot_builder", "insetKey", "marginKey", "messagesKey", "getMessagesKey$plot_builder", "subtitleKey", "getSubtitleKey$plot_builder", "titleKey", "getTitleKey$plot_builder", "backgroundColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "backgroundFill", "backgroundLineType", "Lorg/jetbrains/letsPlot/core/plot/base/render/linetype/LineType;", "backgroundStrokeWidth", "", "captionJustification", "Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification;", "captionMargins", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "captionPosition", "Lorg/jetbrains/letsPlot/core/plot/base/theme/TitlePosition;", "captionStyle", "Lorg/jetbrains/letsPlot/core/plot/base/theme/ThemeTextStyle;", "plotInset", "plotMargins", "showBackground", "", "showCaption", "showMessage", "showSubtitle", "showTitle", "subtitleJustification", "subtitleMargins", "subtitleStyle", "textColor", "textStyle", "titleJustification", "titleMargins", "titlePosition", "titleStyle", "plot-builder"})
public final class DefaultPlotTheme
extends ThemeValuesAccess
implements PlotTheme {
    @NotNull
    private final List<String> backgroundKey;
    @NotNull
    private final List<String> titleKey;
    @NotNull
    private final List<String> subtitleKey;
    @NotNull
    private final List<String> captionKey;
    @NotNull
    private final List<String> messagesKey;
    @NotNull
    private final List<String> marginKey;
    @NotNull
    private final List<String> insetKey;

    public DefaultPlotTheme(@NotNull Map<String, ? extends Object> options, @NotNull FontFamilyRegistry fontFamilyRegistry) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        super(options, fontFamilyRegistry);
        Object[] objectArray = new String[]{"plot_background", "rect"};
        this.backgroundKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"plot_title", "title", "text"};
        this.titleKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"plot_subtitle", "title", "text"};
        this.subtitleKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"plot_caption", "title", "text"};
        this.captionKey = CollectionsKt.listOf((Object[])objectArray);
        this.messagesKey = CollectionsKt.listOf((Object)"plot_message");
        this.marginKey = CollectionsKt.listOf((Object)"plot_margin");
        this.insetKey = CollectionsKt.listOf((Object)"plot_inset");
    }

    @NotNull
    public final List<String> getBackgroundKey$plot_builder() {
        return this.backgroundKey;
    }

    @NotNull
    public final List<String> getTitleKey$plot_builder() {
        return this.titleKey;
    }

    @NotNull
    public final List<String> getSubtitleKey$plot_builder() {
        return this.subtitleKey;
    }

    @NotNull
    public final List<String> getCaptionKey$plot_builder() {
        return this.captionKey;
    }

    @NotNull
    public final List<String> getMessagesKey$plot_builder() {
        return this.messagesKey;
    }

    @Override
    public boolean showBackground() {
        return !this.isElemBlank(this.backgroundKey);
    }

    @Override
    @NotNull
    public Color backgroundColor() {
        return this.getColor(this.getElemValue(this.backgroundKey), "color");
    }

    @Override
    @NotNull
    public Color backgroundFill() {
        return this.getColor(this.getElemValue(this.backgroundKey), "fill");
    }

    @Override
    public double backgroundStrokeWidth() {
        return this.getNumber(this.getElemValue(this.backgroundKey), "size");
    }

    @Override
    @NotNull
    public LineType backgroundLineType() {
        return this.getLineType(this.getElemValue(this.backgroundKey));
    }

    @Override
    @NotNull
    public ThemeTextStyle titleStyle() {
        return this.getTextStyle(this.getElemValue(this.titleKey));
    }

    @Override
    @NotNull
    public ThemeTextStyle subtitleStyle() {
        return this.getTextStyle(this.getElemValue(this.subtitleKey));
    }

    @Override
    @NotNull
    public ThemeTextStyle captionStyle() {
        return this.getTextStyle(this.getElemValue(this.captionKey));
    }

    @Override
    @NotNull
    public Color textColor() {
        return this.getColor(this.getElemValue(CollectionsKt.listOf((Object)"text")), "color");
    }

    @Override
    @NotNull
    public ThemeTextStyle textStyle() {
        return this.getTextStyle(this.getElemValue(CollectionsKt.listOf((Object)"text")));
    }

    @Override
    public boolean showTitle() {
        return !this.isElemBlank(this.titleKey);
    }

    @Override
    public boolean showSubtitle() {
        return !this.isElemBlank(this.subtitleKey);
    }

    @Override
    public boolean showCaption() {
        return !this.isElemBlank(this.captionKey);
    }

    @Override
    @NotNull
    public TextJustification titleJustification() {
        return this.getTextJustification(this.getElemValue(this.titleKey));
    }

    @Override
    @NotNull
    public TextJustification subtitleJustification() {
        return this.getTextJustification(this.getElemValue(this.subtitleKey));
    }

    @Override
    @NotNull
    public TextJustification captionJustification() {
        return this.getTextJustification(this.getElemValue(this.captionKey));
    }

    @Override
    @NotNull
    public Thickness titleMargins() {
        return this.getMargins(this.getElemValue(this.titleKey));
    }

    @Override
    @NotNull
    public Thickness subtitleMargins() {
        return this.getMargins(this.getElemValue(this.subtitleKey));
    }

    @Override
    @NotNull
    public Thickness captionMargins() {
        return this.getMargins(this.getElemValue(this.captionKey));
    }

    @Override
    @NotNull
    public Thickness plotMargins() {
        return this.getMargins(this.getElemValue(this.marginKey));
    }

    @Override
    @NotNull
    public Thickness plotInset() {
        return this.getPadding(this.getElemValue(this.insetKey));
    }

    @Override
    @NotNull
    public TitlePosition titlePosition() {
        Object object = this.getValue("plot_title_position");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.theme.TitlePosition");
        return (TitlePosition)((Object)object);
    }

    @Override
    @NotNull
    public TitlePosition captionPosition() {
        Object object = this.getValue("plot_caption_position");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.theme.TitlePosition");
        return (TitlePosition)((Object)object);
    }

    @Override
    public boolean showMessage() {
        return !this.isElemBlank(this.messagesKey);
    }
}

