/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.defaultTheme;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendArrangement;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendBoxJustification;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendDirection;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendJustification;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendPosition;
import org.jetbrains.letsPlot.core.plot.base.layout.TextJustification;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.core.plot.base.theme.FontFamilyRegistry;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.ThemeTextStyle;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.ThemeValuesAccess;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001aH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0018H\u0016J\b\u0010%\u001a\u00020\u0015H\u0016J\b\u0010&\u001a\u00020\u0015H\u0016J\b\u0010'\u001a\u00020\u001aH\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020)H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0016J\b\u00102\u001a\u000200H\u0016J\b\u00103\u001a\u00020)H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000205H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u00069"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/DefaultLegendTheme;", "Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeValuesAccess;", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "options", "", "", "", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;)V", "backgroundKey", "", "getBackgroundKey$plot_builder", "()Ljava/util/List;", "keyRectKey", "getKeyRectKey$plot_builder", "textKey", "getTextKey$plot_builder", "titleKey", "getTitleKey$plot_builder", "backgroundColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "backgroundFill", "backgroundLineType", "Lorg/jetbrains/letsPlot/core/plot/base/render/linetype/LineType;", "backgroundStrokeWidth", "", "boxArrangement", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendArrangement;", "boxJustification", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendBoxJustification;", "boxSpacing", "direction", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendDirection;", "justification", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendJustification;", "keyLineType", "keyRectColor", "keyRectFill", "keyRectStrokeWidth", "keySize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "keySpacing", "margins", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "position", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendPosition;", "showBackground", "", "showKeyRect", "showTitle", "spacing", "textStyle", "Lorg/jetbrains/letsPlot/core/plot/base/theme/ThemeTextStyle;", "titleJustification", "Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification;", "titleStyle", "plot-builder"})
public final class DefaultLegendTheme
extends ThemeValuesAccess
implements LegendTheme {
    @NotNull
    private final List<String> keyRectKey;
    @NotNull
    private final List<String> backgroundKey;
    @NotNull
    private final List<String> titleKey;
    @NotNull
    private final List<String> textKey;

    public DefaultLegendTheme(@NotNull Map<String, ? extends Object> options, @NotNull FontFamilyRegistry fontFamilyRegistry) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        super(options, fontFamilyRegistry);
        Object[] objectArray = new String[]{"legend_key", "rect"};
        this.keyRectKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"legend_background", "rect"};
        this.backgroundKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"legend_title", "title", "text"};
        this.titleKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"legend_text", "text"};
        this.textKey = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<String> getKeyRectKey$plot_builder() {
        return this.keyRectKey;
    }

    @NotNull
    public final List<String> getBackgroundKey$plot_builder() {
        return this.backgroundKey;
    }

    @NotNull
    public final List<String> getTitleKey$plot_builder() {
        return this.titleKey;
    }

    @NotNull
    public final List<String> getTextKey$plot_builder() {
        return this.textKey;
    }

    @Override
    @NotNull
    public DoubleVector keySize() {
        Object[] objectArray = new String[]{"legend_key_width", "legend_key_size"};
        double width2 = this.getNumber(CollectionsKt.listOf((Object[])objectArray));
        Object[] objectArray2 = new String[]{"legend_key_height", "legend_key_size"};
        double height = this.getNumber(CollectionsKt.listOf((Object[])objectArray2));
        return new DoubleVector(width2, height);
    }

    @Override
    public boolean showKeyRect() {
        return !this.isElemBlank(this.keyRectKey);
    }

    @Override
    @NotNull
    public Color keyRectFill() {
        return this.getColor(this.getElemValue(this.keyRectKey), "fill");
    }

    @Override
    @NotNull
    public Color keyRectColor() {
        return this.getColor(this.getElemValue(this.keyRectKey), "color");
    }

    @Override
    public double keyRectStrokeWidth() {
        return this.getNumber(this.getElemValue(this.keyRectKey), "size");
    }

    @Override
    @NotNull
    public LineType keyLineType() {
        return this.getLineType(this.getElemValue(this.keyRectKey));
    }

    @Override
    @NotNull
    public DoubleVector keySpacing() {
        Object[] objectArray = new String[]{"legend_key_spacing_x", "legend_key_spacing"};
        double spacingX = this.getNumber(CollectionsKt.listOf((Object[])objectArray));
        Object[] objectArray2 = new String[]{"legend_key_spacing_y", "legend_key_spacing"};
        double spacingY = this.getNumber(CollectionsKt.listOf((Object[])objectArray2));
        return new DoubleVector(spacingX, spacingY);
    }

    @Override
    @NotNull
    public Thickness margins() {
        return this.getMargins(this.getElemValue(CollectionsKt.listOf((Object)"legend_margin")));
    }

    @Override
    @NotNull
    public LegendArrangement boxArrangement() {
        Object object = this.getValue("legend_box");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.guide.LegendArrangement");
        return (LegendArrangement)((Object)object);
    }

    @Override
    public double boxSpacing() {
        return this.getNumber(CollectionsKt.listOf((Object)"legend_box_spacing"));
    }

    @Override
    @NotNull
    public LegendBoxJustification boxJustification() {
        Object object = this.getValue("legend_box_just");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.guide.LegendBoxJustification");
        return (LegendBoxJustification)((Object)object);
    }

    @Override
    @NotNull
    public DoubleVector spacing() {
        Object[] objectArray = new String[]{"legend_spacing_x", "legend_spacing"};
        double spacingX = this.getNumber(CollectionsKt.listOf((Object[])objectArray));
        Object[] objectArray2 = new String[]{"legend_spacing_y", "legend_spacing"};
        double spacingY = this.getNumber(CollectionsKt.listOf((Object[])objectArray2));
        return new DoubleVector(spacingX, spacingY);
    }

    @Override
    @NotNull
    public LegendPosition position() {
        Object object = this.getValue("legend_position");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.guide.LegendPosition");
        return (LegendPosition)object;
    }

    @Override
    @NotNull
    public LegendJustification justification() {
        Object object = this.getValue("legend_justification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.guide.LegendJustification");
        return (LegendJustification)object;
    }

    @Override
    @NotNull
    public LegendDirection direction() {
        Object object = this.getValue("legend_direction");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.guide.LegendDirection");
        return (LegendDirection)((Object)object);
    }

    @Override
    public boolean showTitle() {
        return !this.isElemBlank(this.titleKey);
    }

    @Override
    @NotNull
    public ThemeTextStyle titleStyle() {
        return this.getTextStyle(this.getElemValue(this.titleKey));
    }

    @Override
    @NotNull
    public TextJustification titleJustification() {
        return this.getTextJustification(this.getElemValue(this.titleKey));
    }

    @Override
    @NotNull
    public ThemeTextStyle textStyle() {
        return this.getTextStyle(this.getElemValue(this.textKey));
    }

    @Override
    public boolean showBackground() {
        return !this.isElemBlank(this.backgroundKey);
    }

    @Override
    @NotNull
    public Color backgroundColor() {
        return this.getColor(this.getElemValue(this.backgroundKey), "color");
    }

    @Override
    @NotNull
    public Color backgroundFill() {
        return this.getColor(this.getElemValue(this.backgroundKey), "fill");
    }

    @Override
    public double backgroundStrokeWidth() {
        return this.getNumber(this.getElemValue(this.backgroundKey), "size");
    }

    @Override
    @NotNull
    public LineType backgroundLineType() {
        return this.getLineType(this.getElemValue(this.backgroundKey));
    }
}

