/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SpecificIdRule;
import org.languagetool.rules.SuggestionWithMessage;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public abstract class AbstractSimpleReplaceRule2
extends Rule {
    private volatile boolean initialized;
    private Map<String, Integer> mStartSpace;
    private Map<String, Integer> mStartNoSpace;
    private Map<String, SuggestionWithMessage> mFullSpace;
    private Map<String, SuggestionWithMessage> mFullNoSpace;
    private static final int MAX_TOKENS_IN_MULTIWORD = 20;
    private boolean ignoreShortUppercaseWords = true;
    private int MAX_LENGTH_SHORT_WORDS = 4;
    private boolean ruleHasSuggestions = true;
    protected final Language language;
    protected boolean subRuleSpecificIds = false;

    protected boolean isCheckingCase() {
        return false;
    }

    public abstract List<String> getFileNames();

    public List<URL> getFilePaths() {
        return null;
    }

    @Override
    public abstract String getId();

    @Override
    public abstract String getDescription();

    public abstract String getShort();

    public abstract String getMessage();

    public String getSuggestionsSeparator() {
        return ", ";
    }

    public abstract Locale getLocale();

    public AbstractSimpleReplaceRule2(ResourceBundle messages, Language language) {
        super(messages);
        this.language = Objects.requireNonNull(language);
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    public void useSubRuleSpecificIds() {
        this.subRuleSpecificIds = true;
    }

    public CaseSensitivy getCaseSensitivy() {
        return CaseSensitivy.CI;
    }

    public String getDescription(String details) {
        return null;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        int sentStart;
        this.lazyInit();
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (sentStart = 1; sentStart < tokens.length && this.isPunctuationStart(tokens[sentStart].getToken()); ++sentStart) {
        }
        int[] checkCaseCoveredUpto = new int[]{0};
        for (int startIndex = sentStart; startIndex < tokens.length; ++startIndex) {
            String tok;
            if (this.isTokenException(tokens[startIndex]) || (tok = tokens[startIndex].getToken()).length() < 1) continue;
            for (int k = startIndex + 1; k < tokens.length && !tokens[k].isWhitespaceBefore(); ++k) {
                tok = tok + tokens[k].getToken();
            }
            if (this.getCaseSensitivy() == CaseSensitivy.CI) {
                tok = tok.toLowerCase();
            }
            if (this.mStartSpace.containsKey(tok)) {
                StringBuilder keyBuilder = new StringBuilder();
                int maxTokenLen = this.mStartSpace.get(tok);
                for (int endIndex = startIndex; endIndex < tokens.length && endIndex - startIndex < 20; ++endIndex) {
                    if (endIndex > startIndex && tokens[endIndex].isWhitespaceBefore()) {
                        keyBuilder.append(" ");
                    }
                    keyBuilder.append(tokens[endIndex].getToken());
                    String originalStr = keyBuilder.toString();
                    int numberOfSpaces = StringTools.numberOf(originalStr, " ");
                    if (numberOfSpaces + 1 > maxTokenLen) break;
                    if (numberOfSpaces <= 0) continue;
                    String keyStr = originalStr;
                    if (this.getCaseSensitivy() == CaseSensitivy.CI) {
                        keyStr = keyStr.toLowerCase();
                    }
                    SuggestionWithMessage suggestionWithMessage = this.mFullSpace.get(keyStr);
                    this.createMatch(ruleMatches, suggestionWithMessage, startIndex, endIndex, originalStr, tokens, sentence, sentStart, checkCaseCoveredUpto);
                    if (suggestionWithMessage != null || sentStart != startIndex || this.getCaseSensitivy() != CaseSensitivy.CSExceptAtSentenceStart || keyStr.equals(StringTools.lowercaseFirstChar(keyStr))) continue;
                    keyStr = StringTools.lowercaseFirstChar(keyStr);
                    suggestionWithMessage = this.mFullSpace.get(keyStr);
                    this.createMatch(ruleMatches, suggestionWithMessage, startIndex, endIndex, originalStr, tokens, sentence, sentStart, checkCaseCoveredUpto);
                }
            }
            if (!this.mStartNoSpace.containsKey(tok.substring(0, 1))) continue;
            StringBuilder keyBuilder = new StringBuilder();
            for (int endIndex = startIndex; !(endIndex >= tokens.length || endIndex - startIndex >= 20 || endIndex > startIndex && tokens[endIndex].isWhitespaceBefore()); ++endIndex) {
                String originalStr;
                keyBuilder.append(tokens[endIndex].getToken());
                String keyStr = originalStr = keyBuilder.toString();
                if (this.getCaseSensitivy() == CaseSensitivy.CI) {
                    keyStr = keyStr.toLowerCase();
                }
                SuggestionWithMessage suggestionWithMessage = this.mFullNoSpace.get(keyStr);
                this.createMatch(ruleMatches, suggestionWithMessage, startIndex, endIndex, originalStr, tokens, sentence, sentStart, checkCaseCoveredUpto);
                if (suggestionWithMessage != null || sentStart != startIndex || this.getCaseSensitivy() != CaseSensitivy.CSExceptAtSentenceStart || keyStr.equals(StringTools.lowercaseFirstChar(keyStr))) continue;
                keyStr = StringTools.lowercaseFirstChar(keyStr);
                suggestionWithMessage = this.mFullNoSpace.get(keyStr);
                this.createMatch(ruleMatches, suggestionWithMessage, startIndex, endIndex, originalStr, tokens, sentence, sentStart, checkCaseCoveredUpto);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private void createMatch(List<RuleMatch> ruleMatches, SuggestionWithMessage suggestionWithMessage, int startIndex, int endIndex, String originalStr, AnalyzedTokenReadings[] tokens, AnalyzedSentence sentence, int sentStart, int[] checkCaseCoveredUpto) {
        RuleMatch lastRuleMatch;
        RuleMatch lastRuleMatch2;
        if (suggestionWithMessage == null || this.isException(originalStr)) {
            return;
        }
        List<String> replacements = Arrays.asList(suggestionWithMessage.getSuggestion().split("\\|"));
        int fromPos = tokens[startIndex].getStartPos();
        int toPos = tokens[endIndex].getEndPos();
        if (ruleMatches.size() > 0 && (lastRuleMatch2 = ruleMatches.get(ruleMatches.size() - 1)).getFromPos() <= fromPos && lastRuleMatch2.getToPos() >= toPos) {
            return;
        }
        boolean firstWordInSuggIsCamelCase = replacements.stream().anyMatch(k -> StringTools.isCamelCase(k.split(" ")[0]));
        boolean isAllUppercase = StringTools.isAllUppercase(originalStr);
        boolean isCapitalized = StringTools.isCapitalizedWord(originalStr.split(" ")[0]);
        if (this.isCheckingCase()) {
            if (endIndex <= checkCaseCoveredUpto[0]) {
                return;
            }
            String replacementCheckCase = replacements.get(0);
            if (sentStart == startIndex && originalStr.equals(StringTools.uppercaseFirstChar(replacementCheckCase)) || originalStr.equals(replacementCheckCase)) {
                RuleMatch lastRuleMatch3;
                if (ruleMatches.size() > 0 && (lastRuleMatch3 = ruleMatches.get(ruleMatches.size() - 1)).getToPos() > fromPos) {
                    ruleMatches.remove(ruleMatches.size() - 1);
                }
                checkCaseCoveredUpto[0] = endIndex;
                return;
            }
            if (!firstWordInSuggIsCamelCase && originalStr.equals(originalStr.toUpperCase()) && (this.ignoreShortUppercaseWords || originalStr.length() > this.MAX_LENGTH_SHORT_WORDS)) {
                checkCaseCoveredUpto[0] = endIndex;
                return;
            }
        }
        ArrayList<String> finalReplacements = new ArrayList<String>();
        Iterator<String> lastRuleMatch3 = replacements.iterator();
        while (lastRuleMatch3.hasNext()) {
            String repl;
            String finalRepl = repl = lastRuleMatch3.next();
            if (!firstWordInSuggIsCamelCase && (sentStart == startIndex || isCapitalized && !this.isCheckingCase())) {
                finalRepl = StringTools.uppercaseFirstChar(repl);
            }
            if (!this.isCheckingCase() && isAllUppercase) {
                finalRepl = repl.toUpperCase();
            }
            if (!(repl.equals(originalStr) || finalRepl.equals(originalStr) || finalReplacements.contains(finalRepl))) {
                finalReplacements.add(finalRepl);
            }
            if (!finalRepl.equals(originalStr)) continue;
            finalReplacements.clear();
            break;
        }
        if (this.ruleHasSuggestions && finalReplacements.isEmpty()) {
            return;
        }
        String msg = suggestionWithMessage.getMessage();
        String url = null;
        if (msg != null && (msg.startsWith("http://") || msg.startsWith("https://"))) {
            url = msg = null;
        }
        if (msg == null) {
            String msgSuggestions = "";
            for (int k2 = 0; k2 < replacements.size(); ++k2) {
                if (k2 > 0) {
                    msgSuggestions = msgSuggestions + (k2 == replacements.size() - 1 ? this.getSuggestionsSeparator() : ", ");
                }
                msgSuggestions = msgSuggestions + "<suggestion>" + replacements.get(k2) + "</suggestion>";
            }
            msg = this.getMessage().replaceFirst("\\$match", originalStr).replaceFirst("\\$suggestions", msgSuggestions);
        }
        RuleMatch ruleMatch = new RuleMatch(this, sentence, fromPos, toPos, msg, this.getShort());
        if (this.subRuleSpecificIds) {
            String id = StringTools.toId(this.getId() + "_" + originalStr, this.language);
            String desc = this.getDescription().replace("$match", originalStr);
            SpecificIdRule specificIdRule = new SpecificIdRule(id, desc, this.isPremium(), this.getCategory(), this.getLocQualityIssueType(), this.getTags());
            ruleMatch = new RuleMatch(specificIdRule, sentence, fromPos, toPos, msg, this.getShort());
        }
        if (url != null) {
            ruleMatch.setUrl(Tools.getUrl(url));
        }
        if (this.ruleHasSuggestions) {
            ruleMatch.setSuggestedReplacements(finalReplacements);
        }
        if (this.isRuleMatchException(ruleMatch)) {
            return;
        }
        if (ruleMatches.size() > 0 && (lastRuleMatch = ruleMatches.get(ruleMatches.size() - 1)).getFromPos() >= fromPos && lastRuleMatch.getToPos() <= toPos) {
            ruleMatches.remove(ruleMatches.size() - 1);
        }
        ruleMatches.add(ruleMatch);
    }

    protected boolean isRuleMatchException(RuleMatch ruleMatch) {
        return false;
    }

    protected boolean isException(String matchedText) {
        return false;
    }

    protected boolean isTokenException(AnalyzedTokenReadings atr) {
        return false;
    }

    public boolean checkKeyWordsAreKnownToSpeller() {
        return false;
    }

    public boolean checkKeyWordsAreUnknownToSpeller() {
        return false;
    }

    public boolean separateKeyWordsBySpeller() {
        return false;
    }

    protected boolean isPunctuationStart(String word) {
        return StringUtils.getDigits((String)word).length() > 0 || StringTools.isPunctuationMark(word) || StringTools.isNotWordCharacter(word);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.initialized) {
            return;
        }
        AbstractSimpleReplaceRule2 abstractSimpleReplaceRule2 = this;
        synchronized (abstractSimpleReplaceRule2) {
            if (this.initialized) {
                return;
            }
            Object2IntOpenHashMap mStartSpace = new Object2IntOpenHashMap();
            Object2IntOpenHashMap mStartNoSpace = new Object2IntOpenHashMap();
            Object2ObjectOpenHashMap mFullSpace = new Object2ObjectOpenHashMap();
            Object2ObjectOpenHashMap mFullNoSpace = new Object2ObjectOpenHashMap();
            this.fillMaps((Map<String, Integer>)mStartSpace, (Map<String, Integer>)mStartNoSpace, (Map<String, SuggestionWithMessage>)mFullSpace, (Map<String, SuggestionWithMessage>)mFullNoSpace);
            mStartSpace.trim();
            mStartNoSpace.trim();
            mFullSpace.trim();
            mFullNoSpace.trim();
            this.mStartSpace = mStartSpace;
            this.mStartNoSpace = mStartNoSpace;
            this.mFullSpace = mFullSpace;
            this.mFullNoSpace = mFullNoSpace;
            this.initialized = true;
        }
    }

    private void fillMaps(Map<String, Integer> mStartSpace, Map<String, Integer> mStartNoSpace, Map<String, SuggestionWithMessage> mFullSpace, Map<String, SuggestionWithMessage> mFullNoSpace) {
        try {
            for (URL filePath : this.getAllFilePaths()) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(filePath.openStream(), StandardCharsets.UTF_8));
                while ((line = br.readLine()) != null) {
                    String[] wrongForms;
                    String msg;
                    String[] parts;
                    if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                    if (line.contains("  ") && !this.language.getShortCode().equals("ar")) {
                        throw new RuntimeException("More than one consecutive space in " + filePath + " - use a tab character as a delimiter for the message: " + line);
                    }
                    line = StringUtils.substringBefore((String)line, (String)"#").trim();
                    if (this.isCheckingCase()) {
                        parts = line.split("=");
                        line = parts[0].toLowerCase().trim() + "=" + parts[0].trim();
                        if (parts.length == 2) {
                            line = line + "\t" + parts[1].trim();
                        }
                    }
                    parts = line.split("\t");
                    String confPair = parts[0];
                    if (parts.length == 1) {
                        msg = null;
                    } else if (parts.length == 2) {
                        msg = parts[1];
                    } else {
                        throw new IOException("Format error in file " + filePath + ". Expected at most 1 '=' character and at most 1 tab character. Line: " + line);
                    }
                    String[] confPairParts = confPair.split("=");
                    String suggestion = "";
                    if (this.ruleHasSuggestions) {
                        if (confPairParts.length < 2) {
                            throw new IOException("Format error in file " + filePath + ". Missing suggestion after character '='. Line: " + line);
                        }
                        suggestion = confPairParts[1];
                    }
                    for (String wrongForm : wrongForms = confPairParts[0].split("\\|")) {
                        boolean containsSpace;
                        String searchKey;
                        String string2 = searchKey = this.getCaseSensitivy() == CaseSensitivy.CI ? wrongForm.toLowerCase() : wrongForm;
                        if (!this.isCheckingCase() && searchKey.equals(suggestion)) {
                            throw new IOException("Format error in file " + filePath + ". Found same word on left and right side of '='. Line: " + line);
                        }
                        SuggestionWithMessage suggestionWithMessage = new SuggestionWithMessage(suggestion, msg);
                        boolean bl = containsSpace = wrongForm.indexOf(32) > 0;
                        if (!containsSpace) {
                            String firstChar = searchKey.substring(0, 1);
                            if (mStartNoSpace.containsKey(firstChar)) {
                                if (mStartNoSpace.get(firstChar) < searchKey.length()) {
                                    mStartNoSpace.put(firstChar, searchKey.length());
                                }
                            } else {
                                mStartNoSpace.put(firstChar, searchKey.length());
                            }
                            mFullNoSpace.put(searchKey, suggestionWithMessage);
                            continue;
                        }
                        String[] tokens = searchKey.split(" ");
                        String firstToken = tokens[0];
                        if (mStartSpace.containsKey(firstToken)) {
                            if (mStartSpace.get(firstToken) < tokens.length) {
                                mStartSpace.put(firstToken, tokens.length);
                            }
                        } else {
                            mStartSpace.put(firstToken, tokens.length);
                        }
                        mFullSpace.put(searchKey, suggestionWithMessage);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<URL> getAllFilePaths() {
        ArrayList<URL> filePaths = new ArrayList<URL>();
        if (this.getFilePaths() != null) {
            filePaths.addAll(this.getFilePaths());
        }
        for (String fileName : this.getFileNames()) {
            filePaths.add(JLanguageTool.getDataBroker().getFromRulesDirAsUrl(fileName));
        }
        return filePaths;
    }

    public List<Map<String, SuggestionWithMessage>> getWrongWords() {
        this.lazyInit();
        ArrayList<Map<String, SuggestionWithMessage>> wrongWords = new ArrayList<Map<String, SuggestionWithMessage>>();
        wrongWords.add(this.mFullSpace);
        wrongWords.add(this.mFullNoSpace);
        return wrongWords;
    }

    protected boolean isIgnoreShortUppercaseWords() {
        return this.ignoreShortUppercaseWords;
    }

    protected void setIgnoreShortUppercaseWords(boolean value) {
        this.ignoreShortUppercaseWords = value;
    }

    protected void setRuleHasSuggestions(boolean value) {
        this.ruleHasSuggestions = value;
    }

    public static enum CaseSensitivy {
        CS,
        CI,
        CSExceptAtSentenceStart;

    }
}

