/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.execution;

import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookOfflineSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookRuntimeSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.ManagedJupyterServerNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterConfiguredServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u00a8\u0006\n"}, d2={"isRemoteRemoteJupyterServerSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isRemote", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;", "isLocal", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterConnectionSettingsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterConnectionSettingsUtil.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/JupyterConnectionSettingsUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class JupyterConnectionSettingsUtilKt {
    public static final boolean isRemoteRemoteJupyterServerSettings(@NotNull Project project, @Nullable VirtualFile virtualFile2) {
        boolean bl;
        JupyterNotebookRuntimeSettings notebookSettings;
        JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile3 = virtualFile2;
        if (virtualFile3 != null) {
            VirtualFile it = virtualFile3;
            boolean bl2 = false;
            jupyterNotebookRuntimeSettings = JupyterRuntimeService.Companion.getInstance(project).getRuntime(it);
        } else {
            jupyterNotebookRuntimeSettings = null;
        }
        JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings2 = notebookSettings = jupyterNotebookRuntimeSettings;
        if (jupyterNotebookRuntimeSettings2 instanceof JupyterNotebookOfflineSettings) {
            bl = JupyterConnectionSettingsUtilKt.isRemote(((JupyterNotebookOfflineSettings)notebookSettings).getConnectionSettings());
        } else if (jupyterNotebookRuntimeSettings2 instanceof JupyterNotebookSessionSettings) {
            bl = JupyterConnectionSettingsUtilKt.isRemote(((JupyterNotebookSessionSettings)notebookSettings).getConnectionSettings()) && !JupyterConnectionSettingsUtilKt.isLocal(((JupyterNotebookSessionSettings)notebookSettings).getSession().getJupyterServer().getConnectionParameters());
        } else if (jupyterNotebookRuntimeSettings2 instanceof ManagedJupyterServerNotebookSessionSettings) {
            bl = false;
        } else if (jupyterNotebookRuntimeSettings2 == null) {
            bl = JupyterConnectionSettingsUtilKt.isRemote(JupyterConnectionSettingsManager.Companion.getInstance().getConfigForVirtualFileOrDefault(virtualFile2, project));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static final boolean isRemote(@NotNull JupyterServerConfig $this$isRemote) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isRemote, (String)"<this>");
        JupyterServerConfig jupyterServerConfig = $this$isRemote;
        if (jupyterServerConfig instanceof JupyterManagedServerConfig) {
            bl = false;
        } else if (jupyterServerConfig instanceof JupyterConfiguredServerConfig) {
            bl = !((JupyterConfiguredServerConfig)$this$isRemote).isLocal();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static final boolean isLocal(@NotNull JupyterConnectionParameters $this$isLocal) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isLocal, (String)"<this>");
        try {
            InetAddress $this$isLocal_u24lambda_u241 = InetAddress.getByName($this$isLocal.getUri().getHost());
            boolean bl2 = false;
            bl = $this$isLocal_u24lambda_u241.isAnyLocalAddress() || $this$isLocal_u24lambda_u241.isLoopbackAddress();
        }
        catch (Exception e) {
            Exception exception = e;
            if (!(exception instanceof UnknownHostException) && !(exception instanceof SecurityException)) {
                throw e;
            }
            bl = false;
        }
        return bl;
    }
}

